class EventListenerManager{constructor(){this["listeners"]=new Map}["add"](windowId,element,type,handler,options){if(!this["listeners"]["has"](windowId)){this["listeners"]["set"](windowId,[])}element["addEventListener"](type,handler,options);this["listeners"]["get"](windowId)["push"]({["element"]:element,["type"]:type,["handler"]:handler,["options"]:options})}["register"](windowId,element,type,handler,options){this["add"](windowId,element,type,handler,options)}["cleanup"](windowId){const windowListeners=this["listeners"]["get"](windowId);if(windowListeners){windowListeners["forEach"](({["element"]:element,["type"]:type,["handler"]:handler,["options"]:options})=>{try{element["removeEventListener"](type,handler,options)}catch(e){}});this["listeners"]["delete"](windowId)}}["cleanupAll"](){this["listeners"]["forEach"]((_,windowId)=>{return this["cleanup"](windowId)})}["getStats"](){let total=0;this["listeners"]["forEach"]((listeners,windowId)=>{total+=listeners["length"]});return{["windows"]:this["listeners"]["size"],["totalListeners"]:total}}}window["eventListenerManager"]=new EventListenerManager;class Game{constructor(){window["game"]=this;this["creditsDisplay"]=document["getElementById"]("credits-value");this["attentionDisplay"]=document["getElementById"]("attention-value");this["visitorsDisplay"]=document["getElementById"]("visitors-value");this["satisfactionDisplay"]=document["getElementById"]("satisfaction-value");this["yearDisplay"]=document["querySelector"](".year-display");this["terminalOutput"]=document["getElementById"]("terminal-output");this["commandInput"]=document["getElementById"]("command-input");this["events"]=document["getElementById"]("events");this["rankingsList"]=document["getElementById"]("rankings-list");this["commandHistory"]=[];this["historyIndex"]=-1;this["autocompleteIndex"]=0;this["lastAutocompleteInput"]="";this["autocompleteMatches"]=[];this["awaitingQuitConfirmation"]=false;this["setupCommandInputFocus"]();this["fishEyeEffect"]=document["querySelector"](".fish-eye");this["currentCapacity"]=100;this["lastKnownVisitors"]=0;this["showCapacityWarning"]=false;this["isLanguageReady"]=false;this["domain"]="";this["lastAttentionThreshold"]=0;this["aliases"]={};this["loadAliases"]();this["fontScale"]=parseFloat(localStorage["getItem"]("fontScale"))||1;this["minFontScale"]=0.5;this["maxFontScale"]=2;this["fontScaleStep"]=0.1;this["musicPlayer"]=null;this["musicFiles"]=["futilitybelt.mp3","midnight_drive.ogg","synthwavehouse.wav","chase_in_the_night.wav"];this["currentTrackIndex"]=0;this["musicVolume"]=0.5;this["effectsVolume"]=0.5;this["isMusicLooping"]=false;this["initMusicPlayer"]();this["catClickCount"]=0;this["loadColorTheme"]();this["loadSavedFont"]();this["waitForLanguageManager"]()["then"](()=>{this["isLanguageReady"]=true;this["loadEventLogs"]();this["setupCRTEffects"]();this["setupEventListeners"]();this["startGameLoop"]();this["initializeTerminal"]();this["loadCompetitorRankings"]();this["fetchInitialAttentionLevel"]()});this["accumulatedAttention"]=0;this["accumulatedIncome"]=0;this["lastAccumulatedDisplayTime"]=Date["now"]();this["platformIntegrity"]={["marker"]:23,["calibration"]:0,["threshold"]:0};this["isDemoVersion"]=false;this["demoYearLimit"]=2001;this["hasShownDemoLimitWarning"]=false;this["waitForLanguageManager"]()["then"](()=>{this["initTaskbar"]()})}["loadColorTheme"](){const savedTheme=localStorage["getItem"]("torrent_theme");const validThemes=["green","blue","red","purple","amber","white"];if(savedTheme&&validThemes["includes"](savedTheme)){if(savedTheme!=="green"){document["documentElement"]["classList"]["add"]("theme-"+savedTheme)}}}async["unlockAchievement"](achievementId){try{if(window["electron"]&&window["electron"]["invoke"]){const unlocked=await window["electron"]["invoke"]("achievement:unlock",achievementId);if(unlocked){}return unlocked}return false}catch(error){return false}}["incrementCatClicks"](){this["catClickCount"]++;if(this["catClickCount"]>=500){this["unlockAchievement"]("ACH_KITTY")}}["loadAliases"](){try{const savedAliases=localStorage["getItem"]("torrent_aliases");if(savedAliases){this["aliases"]=JSON["parse"](savedAliases)}}catch(error){this["aliases"]={}}}["saveAliases"](){try{localStorage["setItem"]("torrent_aliases",JSON["stringify"](this["aliases"]))}catch(error){}}["resolveAlias"](command){const parts=command["split"](" ");const firstPart=parts[0]["toLowerCase"]();if(this["aliases"][firstPart]){parts[0]=this["aliases"][firstPart];return parts["join"](" ")}return command}["handleAliasCommand"](commandParts){if(commandParts["length"]===1){this["writeToTerminal"]("<span style=\"color: var(--accent-color); font-weight: bold;\">"+(window["langManager"]?window["langManager"]["t"]("game.alias.usage_header","Alias Command Usage:"):"Alias Command Usage:")+"</span>");this["writeToTerminal"]("");this["writeToTerminal"]("<span style=\"color: var(--secondary-color);\">alias</span> - "+(window["langManager"]?window["langManager"]["t"]("game.alias.usage_list","List all defined aliases"):"List all defined aliases"));this["writeToTerminal"]("<span style=\"color: var(--secondary-color);\">alias &lt;name&gt;</span> - "+(window["langManager"]?window["langManager"]["t"]("game.alias.usage_show","Show what an alias points to"):"Show what an alias points to"));this["writeToTerminal"]("<span style=\"color: var(--secondary-color);\">alias &lt;name&gt; &lt;command&gt;</span> - "+(window["langManager"]?window["langManager"]["t"]("game.alias.usage_create","Create or update an alias"):"Create or update an alias"));this["writeToTerminal"]("");this["writeToTerminal"]("<span style=\"color: var(--warning-color);\">"+(window["langManager"]?window["langManager"]["t"]("game.alias.examples_header","Examples:"):"Examples:")+"</span>");this["writeToTerminal"]("  alias mt marketplace - "+(window["langManager"]?window["langManager"]["t"]("game.alias.example_create","Create \"mt\" as shortcut for \"marketplace\""):"Create \"mt\" as shortcut for \"marketplace\""));this["writeToTerminal"]("  alias vol volume 0.5 - "+(window["langManager"]?window["langManager"]["t"]("game.alias.example_params","Create alias with parameters"):"Create alias with parameters"));this["writeToTerminal"]("");if(Object["keys"](this["aliases"])["length"]===0){this["writeToTerminal"]("<span style=\"color: var(--accent-color);\">"+(window["langManager"]?window["langManager"]["t"]("game.alias.no_aliases","No aliases currently defined."):"No aliases currently defined.")+"</span>")}else{this["writeToTerminal"]("<span style=\"color: var(--accent-color);\">"+(window["langManager"]?window["langManager"]["t"]("game.alias.list_header","Currently defined aliases:"):"Currently defined aliases:")+"</span>");Object["entries"](this["aliases"])["forEach"](([alias,command])=>{this["writeToTerminal"]("  <span style=\"color: var(--secondary-color);\">"+alias+"</span> \u2192 <span style=\"color: var(--accent-color);\">"+command+"</span>")})}}else{if(commandParts["length"]===2){const aliasName=commandParts[1]["toLowerCase"]();if(this["aliases"][aliasName]){this["writeToTerminal"]("<span style=\"color: var(--secondary-color);\">"+aliasName+"</span> \u2192 <span style=\"color: var(--accent-color);\">"+this["aliases"][aliasName]+"</span>")}else{this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.alias.not_found",{["name"]:aliasName})||"Alias '"+aliasName+"' not found.":"Alias '"+aliasName+"' not found.")}}else{if(commandParts["length"]>=3){const aliasName=commandParts[1]["toLowerCase"]();const targetCommand=commandParts["slice"](2)["join"](" ");const reservedCommands=["help","marketplace","upload","upgrades","crack","ads","anonchat","volume","music","panel","server","website","connect","clear","menu","quit","color","font","sv_init","set_limit","remove_limit","shut","alias","unalias","files","ls"];if(reservedCommands["includes"](aliasName)){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.alias.reserved_name",{["name"]:aliasName})||"Cannot create alias '"+aliasName+"': This is a reserved command name.":"Cannot create alias '"+aliasName+"': This is a reserved command name.");return}const baseCommands=["help","marketplace","upload","upgrades","crack","ads","anonchat","volume","music","panel","server","website","connect","clear","menu","quit","color","font","sv_init","set_limit","remove_limit","shut","files","ls"];const targetCommandParts=targetCommand["split"](" ");const baseCommand=targetCommandParts[0]["toLowerCase"]();if(!baseCommands["includes"](baseCommand)){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.alias.invalid_command",{["command"]:baseCommand})||"Warning: '"+baseCommand+"' is not a recognized command.":"Warning: '"+baseCommand+"' is not a recognized command.")}const isUpdate=this["aliases"][aliasName]!==undefined;this["aliases"][aliasName]=targetCommand;this["saveAliases"]();if(isUpdate){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.alias.updated",{["name"]:aliasName,["command"]:targetCommand})||"Alias '"+aliasName+"' updated to point to '"+targetCommand+"'.":"Alias '"+aliasName+"' updated to point to '"+targetCommand+"'.")}else{this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.alias.created",{["name"]:aliasName,["command"]:targetCommand})||"Alias '"+aliasName+"' created for '"+targetCommand+"'.":"Alias '"+aliasName+"' created for '"+targetCommand+"'.")}}}}}["handleUnaliasCommand"](commandParts){if(commandParts["length"]<2){this["writeToTerminal"]("<span style=\"color: var(--accent-color); font-weight: bold;\">"+(window["langManager"]?window["langManager"]["t"]("game.unalias.usage_header","Unalias Command Usage:"):"Unalias Command Usage:")+"</span>");this["writeToTerminal"]("");this["writeToTerminal"]("<span style=\"color: var(--secondary-color);\">unalias &lt;name&gt;</span> - "+(window["langManager"]?window["langManager"]["t"]("game.unalias.usage_single","Remove a specific alias"):"Remove a specific alias"));this["writeToTerminal"]("<span style=\"color: var(--secondary-color);\">unalias -a</span> - "+(window["langManager"]?window["langManager"]["t"]("game.unalias.usage_all","Remove all aliases"):"Remove all aliases"));this["writeToTerminal"]("");this["writeToTerminal"]("<span style=\"color: var(--warning-color);\">"+(window["langManager"]?window["langManager"]["t"]("game.unalias.examples_header","Examples:"):"Examples:")+"</span>");this["writeToTerminal"]("  unalias mt - "+(window["langManager"]?window["langManager"]["t"]("game.unalias.example_single","Remove the \"mt\" alias"):"Remove the \"mt\" alias"));this["writeToTerminal"]("  unalias -a - "+(window["langManager"]?window["langManager"]["t"]("game.unalias.example_all","Remove all aliases"):"Remove all aliases"));if(Object["keys"](this["aliases"])["length"]>0){this["writeToTerminal"]("");this["writeToTerminal"]("<span style=\"color: var(--accent-color);\">"+(window["langManager"]?window["langManager"]["t"]("game.alias.list_header","Currently defined aliases:"):"Currently defined aliases:")+"</span>");Object["entries"](this["aliases"])["forEach"](([alias,command])=>{this["writeToTerminal"]("  <span style=\"color: var(--secondary-color);\">"+alias+"</span> \u2192 <span style=\"color: var(--accent-color);\">"+command+"</span>")})}return}if(commandParts[1]==="-a"){if(Object["keys"](this["aliases"])["length"]===0){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.alias.no_aliases","No aliases defined."):"No aliases defined.")}else{const count=Object["keys"](this["aliases"])["length"];this["aliases"]={};this["saveAliases"]();this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.unalias.all_removed",{["count"]:count})||"Removed "+count+" aliases.":"Removed "+count+" aliases.")}}else{const aliasName=commandParts[1]["toLowerCase"]();if(this["aliases"][aliasName]){const removedCommand=this["aliases"][aliasName];delete this["aliases"][aliasName];this["saveAliases"]();this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.unalias.removed",{["name"]:aliasName,["command"]:removedCommand})||"Removed alias '"+aliasName+"' (was pointing to '"+removedCommand+"').":"Removed alias '"+aliasName+"' (was pointing to '"+removedCommand+"').")}else{this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.alias.not_found",{["name"]:aliasName})||"Alias '"+aliasName+"' not found.":"Alias '"+aliasName+"' not found.")}}}["verifySysResource"](){const refEntity=new Date;const resourcePool=refEntity["getTime"]();if(this["platformIntegrity"]){this["platformIntegrity"]["calibration"]=resourcePool;this["platformIntegrity"]["threshold"]=this["calculateResourceAllocation"]()}return true}["calculateResourceAllocation"](){if(window["moduleValidator"]){const baseValidator=window["moduleValidator"]();return baseValidator}return 0}["getAllCommands"](){const baseCommands=["help","marketplace","upload","upgrades","crack","ads","anonchat","volume","music","panel","server","website","connect","clear","menu","quit","color","font","sv_init","set_limit","remove_limit","shut","alias","unalias","notepad","files","ls"];const shortcuts=["q","y","n"];const userAliases=Object["keys"](this["aliases"]);const localizedCommands=[];if(window["langManager"]){const commandKeys=["help","marketplace","upload","upgrades","crack","ads","clear","menu","quit","website","panel","server","sv_init","set_limit","remove_limit","color","font","anonchat","shut","volume","music","connect","alias","unalias","notepad","files"];commandKeys["forEach"](key=>{const localizedCommand=window["langManager"]["t"]("game.commands."+key,key);if(localizedCommand!==key){localizedCommands["push"](localizedCommand)}})}return[...baseCommands,...shortcuts,...userAliases,...localizedCommands]}["setupCommandInputFocus"](){if(this["commandInput"]){this["commandInput"]["focus"]();window["addEventListener"]("focus",()=>{if(!this["shouldPreventFocus"]()){this["commandInput"]["focus"]()}});document["addEventListener"]("click",e=>{if(this["shouldPreventFocus"](e["target"])){return}const excludedElements=["input","textarea","select","a","button",".window-close","[role=\"button\"]"];const isExcluded=excludedElements["some"](selector=>{return e["target"]["matches"](selector)||e["target"]["closest"](selector)});if(!isExcluded){setTimeout(()=>{if(!this["shouldPreventFocus"]()){this["commandInput"]["focus"]()}},10)}});document["addEventListener"]("mouseup",()=>{if(this["shouldPreventFocus"]()){return}setTimeout(()=>{if(!window["getSelection"]()["toString"]()&&!this["shouldPreventFocus"]()){this["commandInput"]["focus"]()}},10)});document["addEventListener"]("keydown",e=>{if(e["key"]==="Tab"&&e["target"]!==this["commandInput"]&&!this["shouldPreventFocus"]()){e["preventDefault"]();this["commandInput"]["focus"]()}})}}["shouldPreventFocus"](targetElement=null){const miniGameWindow=document["querySelector"](".window[id*=\"mini-game\"], .window[id*=\"pattern-recognition\"], .window[id*=\"memory-challenge\"]");if(miniGameWindow&&!miniGameWindow["classList"]["contains"]("hidden")){return true}const marketplaceWindow=document["querySelector"](".window[id*=\"marketplace\"]");if(marketplaceWindow&&!marketplaceWindow["classList"]["contains"]("hidden")){return true}const uploadWindow=document["querySelector"](".window[id*=\"upload\"]");if(uploadWindow&&!uploadWindow["classList"]["contains"]("hidden")){return true}const crackingWindow=document["querySelector"](".window[id*=\"cracking\"]");if(crackingWindow&&!crackingWindow["classList"]["contains"]("hidden")){return true}if(targetElement){const inputElements=["input","textarea","select"];if(inputElements["includes"](targetElement["tagName"]["toLowerCase"]())){return true}const parentWindow=targetElement["closest"](".window");if(parentWindow&&parentWindow["querySelector"]("input, textarea, select")){return true}}const activeElement=document["activeElement"];if(activeElement&&(activeElement["tagName"]==="INPUT"||activeElement["tagName"]==="TEXTAREA"||activeElement["tagName"]==="SELECT")){return true}return false}async["waitForLanguageManager"](){if(window["langManager"]&&window["langManager"]["translations"]&&Object["keys"](window["langManager"]["translations"])["length"]>0){return}return new Promise(resolve=>{const checkLanguageManager=()=>{if(window["langManager"]&&window["langManager"]["translations"]&&Object["keys"](window["langManager"]["translations"])["length"]>0){resolve()}else{setTimeout(checkLanguageManager,100)}};checkLanguageManager()})}["loadEventLogs"](){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_event_logs&limit=30"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]&&data["events"]&&data["events"]["length"]>0){this["events"]["innerHTML"]="";data["events"]["forEach"](event=>{const eventElement=document["createElement"]("div");eventElement["className"]="event "+event["type"];let icon="";switch(event["type"]){case"danger":icon="\u274C";break;case"warning":icon="\u26A0\uFE0F";break;case"success":icon="\u2705";break;default:icon="\u2139\uFE0F"}let displayMessage=event["message"];try{const msgData=JSON["parse"](event["message"]);if(msgData["translation_key"]&&msgData["params"]){const translatedParams={...msgData["params"]};if(translatedParams["label_key"]){translatedParams["label"]=window["langManager"]["t"](translatedParams["label_key"]);delete translatedParams["label_key"]}displayMessage=window["langManager"]["t"](msgData["translation_key"],translatedParams)}}catch(e){}eventElement["innerHTML"]="\n                        <span class=\"event-icon\">"+icon+"</span>\n                        <span class=\"event-message\">"+displayMessage+"</span>\n                        <span class=\"event-time\">"+event["event_time"]+"</span>\n                    ";this["events"]["appendChild"](eventElement)})}})}["setupCRTEffects"](){this["crtGlitch"]=document["querySelector"](".crt-glitch");this["fishEye"]=document["querySelector"](".fish-eye");document["addEventListener"]("mousemove",e=>{const mouseX=e["clientX"];const mouseY=e["clientY"];const centerX=window["innerWidth"]/2;const centerY=window["innerHeight"]/2;const distX=(mouseX-centerX)/centerX;const distY=(mouseY-centerY)/centerY;if(this["fishEye"]){const maxSkew=0.3;this["fishEye"]["style"]["transform"]="\n                    scale(1.03)\n                    perspective(1000px)\n                    skew("+distX*maxSkew+"deg, "+distY*maxSkew+"deg)\n                "}});const randomGlitch=()=>{if(Math["random"]()<0.05){this["crtGlitch"]["style"]["opacity"]="1";const glitchType=Math["floor"](Math["random"]()*5);switch(glitchType){case 0:this["crtGlitch"]["style"]["backgroundImage"]="linear-gradient(transparent 50%, rgba(0, 255, 0, 0.1) 50%)";this["crtGlitch"]["style"]["backgroundSize"]="100% "+(Math["random"]()*10+2)+"px";this["crtGlitch"]["style"]["boxShadow"]="none";break;case 1:this["crtGlitch"]["style"]["backgroundImage"]="linear-gradient(90deg, transparent 50%, rgba(0, 255, 0, 0.1) 50%)";this["crtGlitch"]["style"]["backgroundSize"]=Math["random"]()*10+2+"px 100%";this["crtGlitch"]["style"]["boxShadow"]="none";break;case 2:const x=Math["floor"](Math["random"]()*window["innerWidth"]);const y=Math["floor"](Math["random"]()*window["innerHeight"]);const width=Math["floor"](Math["random"]()*100+50);const height=Math["floor"](Math["random"]()*100+20);this["crtGlitch"]["style"]["backgroundImage"]="none";this["crtGlitch"]["style"]["boxShadow"]=""+x+"px "+y+"px 0 "+width+"px rgba(0, 255, 0, 0.15)";break;case 3:const offset=Math["floor"](Math["random"]()*5)+1;this["crtGlitch"]["style"]["backgroundImage"]="none";this["crtGlitch"]["style"]["boxShadow"]="none";this["crtGlitch"]["style"]["textShadow"]=""+offset+"px 0 rgba(255, 0, 0, 0.3), "+-offset+"px 0 rgba(0, 0, 255, 0.3)";document["body"]["classList"]["add"]("color-shift");setTimeout(()=>{document["body"]["classList"]["remove"]("color-shift")},Math["random"]()*150+50);break;case 4:this["crtGlitch"]["style"]["backgroundImage"]="none";this["crtGlitch"]["style"]["boxShadow"]="none";document["body"]["classList"]["add"]("screen-shake");setTimeout(()=>{document["body"]["classList"]["remove"]("screen-shake")},Math["random"]()*150+50);break}setTimeout(()=>{this["crtGlitch"]["style"]["opacity"]="0";this["crtGlitch"]["style"]["boxShadow"]="none";this["crtGlitch"]["style"]["textShadow"]="none"},Math["random"]()*250+50)}if(Math["random"]()<0.02){const scanLine=document["querySelector"](".scan-line");if(scanLine){scanLine["style"]["opacity"]="0.15";setTimeout(()=>{scanLine["style"]["opacity"]="0.05"},300)}}};setInterval(randomGlitch,2000)}["setupEventListeners"](){this["commandInput"]["addEventListener"]("keydown",e=>{if(e["key"]==="Enter"){const command=this["commandInput"]["value"]["trim"]();if(command){const cmdLower=command["toLowerCase"]();const isSilentCmd=cmdLower["startsWith"]("change ")||cmdLower["startsWith"]("lang ");this["autocompleteIndex"]=0;this["lastAutocompleteInput"]="";this["autocompleteMatches"]=[];if(!isSilentCmd){this["commandHistory"]["push"](command);this["historyIndex"]=this["commandHistory"]["length"]}this["handleCommand"](command);this["commandInput"]["value"]=""}}else{if(e["key"]==="Tab"){e["preventDefault"]();const currentInput=this["commandInput"]["value"];const inputBase=currentInput["toLowerCase"]()["trim"]();const isNewAutocomplete=!this["autocompleteMatches"]["some"](match=>{return match["toLowerCase"]()===inputBase});if(isNewAutocomplete){this["autocompleteIndex"]=0;this["lastAutocompleteInput"]=inputBase;const allCommands=this["getAllCommands"]();this["autocompleteMatches"]=allCommands["filter"](cmd=>{return cmd["toLowerCase"]()["startsWith"](inputBase)})["sort"]()}if(this["autocompleteMatches"]["length"]===0){return}const match=this["autocompleteMatches"][this["autocompleteIndex"]];this["commandInput"]["value"]=match;this["autocompleteIndex"]=(this["autocompleteIndex"]+1)%this["autocompleteMatches"]["length"];this["commandInput"]["setSelectionRange"](match["length"],match["length"])}else{if(e["key"]==="ArrowUp"){if(this["historyIndex"]>0){this["historyIndex"]--;this["commandInput"]["value"]=this["commandHistory"][this["historyIndex"]];this["autocompleteIndex"]=0;this["lastAutocompleteInput"]="";this["autocompleteMatches"]=[]}e["preventDefault"]()}else{if(e["key"]==="ArrowDown"){if(this["historyIndex"]<this["commandHistory"]["length"]-1){this["historyIndex"]++;this["commandInput"]["value"]=this["commandHistory"][this["historyIndex"]]}else{this["historyIndex"]=this["commandHistory"]["length"];this["commandInput"]["value"]=""}this["autocompleteIndex"]=0;this["lastAutocompleteInput"]="";this["autocompleteMatches"]=[];e["preventDefault"]()}else{if(e["key"]==="a"&&e["ctrlKey"]){e["preventDefault"]();this["commandInput"]["select"]()}else{if(e["key"]["length"]===1||e["key"]==="Backspace"||e["key"]==="Delete"){this["autocompleteIndex"]=0;this["lastAutocompleteInput"]="";this["autocompleteMatches"]=[]}}}}}}})}["startGameLoop"](){setInterval(()=>{return this["updateGameState"]()},5000);setInterval(()=>{return this["displayAccumulatedStats"]()},30000);if(window["langManager"]&&window["langManager"]["checkSystemValidity"]){window["langManager"]["checkSystemValidity"]();setInterval(()=>{if(window["langManager"]&&window["langManager"]["checkSystemValidity"]){window["langManager"]["checkSystemValidity"]()}},30000)}setInterval(()=>{fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=update_game_time"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){this["updateTimeDisplay"](data["current_date"]);if(data["trigger_mission_tutorial"]){setTimeout(()=>{document["dispatchEvent"](new CustomEvent("firstMissionAppeared"))},2000)}if(data["state"]&&data["state"]["current_hour"]===0){if(Math["random"]()<0.3){this["updateCompetitorVisitors"]();setTimeout(()=>{return this["loadCompetitorRankings"]()},500)}}}})},1000);setInterval(()=>{return this["addVisitorFluctuation"]()},1000)}["updateTimeDisplay"](dateString){if(dateString){this["yearDisplay"]["textContent"]=dateString;const dateRegex=new RegExp("(\\d{2})\\/(\\d{2})\\/(\\d{4})\\s(\\d{2}):00","");const match=dateString["match"](dateRegex);if(match){const day=parseInt(match[1]);const month=parseInt(match[2]);const year=match[3];const hour=match[4];const yearDisplayElement=document["querySelector"](".year-display");yearDisplayElement["textContent"]=year;const monthBoxes=document["querySelectorAll"](".month-box");monthBoxes["forEach"](box=>{const boxMonth=parseInt(box["getAttribute"]("data-month"));if(boxMonth<month){box["classList"]["add"]("filled")}else{box["classList"]["remove"]("filled")}})}return}const now=new Date;const hours=now["getHours"]()["toString"]()["padStart"](2,"0");const minutes=now["getMinutes"]()["toString"]()["padStart"](2,"0");const day=now["getDate"]()["toString"]()["padStart"](2,"0");const month=(now["getMonth"]()+1)["toString"]()["padStart"](2,"0");const year=now["getFullYear"]();this["yearDisplay"]["textContent"]=""+day+"/"+month+"/"+year+" "+hours+":"+minutes;const yearDisplayElement=document["querySelector"](".year-display");yearDisplayElement["textContent"]=year;const monthBoxes=document["querySelectorAll"](".month-box");monthBoxes["forEach"](box=>{const boxMonth=parseInt(box["getAttribute"]("data-month"));if(boxMonth<=now["getMonth"]()+1){box["classList"]["add"]("filled")}else{box["classList"]["remove"]("filled")}})}["addVisitorFluctuation"](){if(this["visitorsDisplay"]){const isServerOffline=document["querySelector"]("#status-bar.server-offline")!==null;if(isServerOffline){this["visitorsDisplay"]["textContent"]="0";this["visitorsDisplay"]["classList"]["remove"]("text-danger");return}const currentVisitors=parseInt(this["visitorsDisplay"]["textContent"])||0;const capacity=this["currentCapacity"]||100;if(currentVisitors>=capacity){this["visitorsDisplay"]["textContent"]=capacity;this["visitorsDisplay"]["classList"]["add"]("text-danger");return}else{this["visitorsDisplay"]["classList"]["remove"]("text-danger")}const fluctuation=Math["floor"](Math["random"]()*7)-3;let newVisitors=Math["max"](1,Math["min"](capacity,currentVisitors+fluctuation));this["visitorsDisplay"]["textContent"]=newVisitors}}async["fetchInitialAttentionLevel"](){try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_game_state"});const data=await response["json"]();if(data&&data["mining"]){window["miningStatus"]=data["mining"]}if(data["success"]&&data["state"]){if(data["state"]["domain"]){this["domain"]=data["state"]["domain"]}if(data["state"]["attention_level"]){this["attentionDisplay"]["textContent"]=parseFloat(data["state"]["attention_level"])["toFixed"](1);this["checkAttentionThresholds"](data["state"]["attention_level"])}}}catch(error){}}async["updateGameState"](){try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=update_game_state"});const data=await response["json"]();if(data["success"]){try{window["__serverShutdownManual"]=!!data["server_shutdown_manual"]}catch(e){}if(data["new_game_started"]){await this["unlockAchievement"]("ACH_HELLO_WORLD")}if(data["first_mission_completed"]){await this["unlockAchievement"]("ACH_SCRIPT_KIDDIE")}if(data["software_cracked_count"]>=3){await this["unlockAchievement"]("ACH_ZERO_DAY")}if(data["software_uploaded_count"]>=5){await this["unlockAchievement"]("ACH_ARCHIVIST")}this["creditsDisplay"]["textContent"]=Math["floor"](parseFloat(data["state"]["credits"]));this["attentionDisplay"]["textContent"]=parseFloat(data["state"]["attention_level"])["toFixed"](1);if(parseFloat(data["state"]["attention_level"])>=20){await this["unlockAchievement"]("ACH_FBI_OPEN_UP")}if(data["state"]["server_online"]===0){if(!window["__serverShutdownManual"]){await this["unlockAchievement"]("ACH_BSOD")}try{const now=Date["now"]();const last=window["__lastServerCrashNotificationAt"]||0;if(!last||now-last>60000){if(!window["__serverShutdownManual"]){this["displayEvent"]({["type"]:"warning",["message"]:window["langManager"]["t"]("game.events.server_crash")});this["displayEvent"]({["type"]:"warning",["message"]:window["langManager"]["t"]("game.events.server_crash_help")})}window["__lastServerCrashNotificationAt"]=now}}catch(e){}document["querySelector"]("#status-bar")["classList"]["add"]("server-offline")}else{document["querySelector"]("#status-bar")["classList"]["remove"]("server-offline");window["__serverShutdownManual"]=false}if(data["pending_events"]&&Array["isArray"](data["pending_events"])&&data["pending_events"]["length"]>0){data["pending_events"]["forEach"](event=>{if(event["message"]&&(event["message"]["includes"](window["langManager"]["t"]("game.events.unread_messages_single"))||event["message"]["includes"](window["langManager"]["t"]("game.events.unread_messages_multiple"))||event["message"]["includes"]("new message")||event["message"]["includes"]("new messages")||event["message"]["includes"]("unread message")||event["message"]["includes"]("unread messages"))){if(window["soundManager"]){window["soundManager"]["playAnonchat"]()}}this["displayEvent"]({["type"]:event["type"],["message"]:event["message"],["eventTime"]:event["event_time"]})})}if(data["visitors_info"]&&data["visitors_info"]["visitors"]){const capacity=data["visitors_info"]["visitors"]["capacity"];this["currentCapacity"]=capacity;const currentVisitors=Math["min"](data["visitors_info"]["visitors"]["current"],capacity);this["lastKnownVisitors"]=currentVisitors;if(currentVisitors>=capacity){this["visitorsDisplay"]["classList"]["add"]("text-danger")}else{this["visitorsDisplay"]["classList"]["remove"]("text-danger")}this["visitorsDisplay"]["textContent"]=currentVisitors;this["satisfactionDisplay"]["textContent"]=Math["round"](data["visitors_info"]["visitors"]["satisfaction"]*100);if(data["visitors_info"]["visitors"]["current"]>capacity&&!this["showCapacityWarning"]){this["showCapacityWarning"]=true;this["displayEvent"]({["type"]:"warning",["message"]:window["langManager"]["t"]("game.events.server_at_capacity",{["overflow"]:data["visitors_info"]["visitors"]["current"]-capacity})});setTimeout(()=>{this["showCapacityWarning"]=false},60000)}}else{const capacity=data["state"]["hosting_level"]*100||100;const currentVisitors=Math["min"](data["state"]["current_visitors"]||0,capacity);this["visitorsDisplay"]["textContent"]=currentVisitors;this["lastKnownVisitors"]=currentVisitors;this["capacityDisplay"]["textContent"]=capacity;this["satisfactionDisplay"]["textContent"]=Math["round"]((data["state"]["visitor_satisfaction"]||1)*100)}if(data["state"]["current_year"]){const year=data["state"]["current_year"];const month=data["state"]["current_month"];const day=data["state"]["current_day"];const hour=data["state"]["current_hour"];if(this["isDemoVersion"]&&year>=this["demoYearLimit"]){window["location"]["href"]=window["BASE_URL"]+"/src/utils/Menu.php";return}const formattedDay=day["toString"]()["padStart"](2,"0");const formattedMonth=month["toString"]()["padStart"](2,"0");const formattedHour=hour["toString"]()["padStart"](2,"0");this["yearDisplay"]["textContent"]=""+formattedDay+"/"+formattedMonth+"/"+year+" "+formattedHour+":00";if(day===1&&hour===0){if(month===1||month===4||month===7||month===10){this["checkForumQuarterlyUpdate"]()}}}if(data["visitors_info"]){let attentionChanged=false;let incomeEarned=false;if(data["visitors_info"]["attention"]&&data["visitors_info"]["attention"]["change"]){const rawChange=parseFloat(data["visitors_info"]["attention"]["change"])||0;const currentVisitors=this["lastKnownVisitors"]||0;const currentYear=data["state"]&&data["state"]["current_year"]?parseInt(data["state"]["current_year"],10):null;let adjustedChange=rawChange;if(currentVisitors<=0&&adjustedChange>0){adjustedChange=0}if(adjustedChange>0&&currentYear){adjustedChange=adjustedChange*this["getVisitorAttentionMultiplier"](currentYear)}if(Math["abs"](adjustedChange)>0.2){this["accumulatedAttention"]+=adjustedChange;attentionChanged=true}}if(data["visitors_info"]["revenue"]&&data["visitors_info"]["revenue"]>0){this["accumulatedIncome"]+=data["visitors_info"]["revenue"];incomeEarned=true}}if(data["state"]["domain"]){this["domain"]=data["state"]["domain"]}if(Math["random"]()<0.1){this["loadCompetitorRankings"]()}if(data["state"]["attention_level"]){this["checkAttentionThresholds"](data["state"]["attention_level"])}}}catch(error){}}["checkForumQuarterlyUpdate"](){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=autoprocess_forum_topics"})["then"](response=>{return response["json"]()})["then"](data=>{})["catch"](error=>{})}["getVisitorAttentionMultiplier"](year){if(year<=2001){return 0.3}if(year<=2004){return 0.5}return 0.7}["getAttentionChangeReason"](change){const hasVisitors=this["lastKnownVisitors"]>0;if(change>0){if(change>2){return window["langManager"]["t"]("game.attention.popular_content")}if(change>1&&hasVisitors){return window["langManager"]["t"]("game.attention.increased_traffic")}return window["langManager"]["t"]("game.attention.normal_activity")}else{if(change<-2){return window["langManager"]["t"]("game.attention.security_effective")}if(change<-1){return window["langManager"]["t"]("game.attention.low_profile")}return window["langManager"]["t"]("game.attention.normal_fluctuation")}}["updateDisplay"](state,visitorsInfo){this["creditsDisplay"]["textContent"]=Math["floor"](parseFloat(state["credits"]));this["attentionDisplay"]["textContent"]=parseFloat(state["attention_level"])["toFixed"](1);if(visitorsInfo&&visitorsInfo["visitors"]){const capacity=visitorsInfo["visitors"]["capacity"];const currentVisitors=Math["min"](visitorsInfo["visitors"]["current"],capacity);this["currentCapacity"]=capacity;if(currentVisitors>=capacity){this["visitorsDisplay"]["classList"]["add"]("text-danger")}else{this["visitorsDisplay"]["classList"]["remove"]("text-danger")}this["visitorsDisplay"]["textContent"]=currentVisitors;const satisfactionPercentage=Math["round"](visitorsInfo["visitors"]["satisfaction"]*100);this["satisfactionDisplay"]["textContent"]=satisfactionPercentage}if(state["current_year"]){const yearValue=parseFloat(state["current_year"]);const year=Math["floor"](yearValue);const fractionalYear=yearValue-year;const monthDecimal=fractionalYear*12;const month=Math["floor"](monthDecimal)+1;const dayDecimal=(monthDecimal-Math["floor"](monthDecimal))*30;const day=Math["floor"](dayDecimal)+1;const hourDecimal=(dayDecimal-Math["floor"](dayDecimal))*24;const hour=Math["floor"](hourDecimal);const formattedDay=day["toString"]()["padStart"](2,"0");const formattedMonth=month["toString"]()["padStart"](2,"0");const formattedHour=hour["toString"]()["padStart"](2,"0");this["yearDisplay"]["textContent"]=""+formattedDay+"/"+formattedMonth+"/"+year+" "+formattedHour+":00"}this["checkAttentionThresholds"](state["attention_level"]);if(state["attention_level"]>80){document["getElementById"]("attention")["classList"]["add"]("danger-blink")}else{document["getElementById"]("attention")["classList"]["remove"]("danger-blink")}}["checkAttentionThresholds"](attentionLevel){if(attentionLevel>=10){if(window["breakingNews"]){window["breakingNews"]["checkNewsForAttentionLevel"](attentionLevel,this["domain"])["then"](isGameOver=>{if(isGameOver){try{const maxWait=10000;let handled=false;const timeout=setTimeout(()=>{if(!handled){handled=true;this["gameOver"]("attention_max")}},maxWait);const poll=setInterval(()=>{try{if(!window["breakingNews"]||!window["breakingNews"]["isShowing"]){clearInterval(poll);clearTimeout(timeout);if(!handled){handled=true;this["gameOver"]("attention_max")}}}catch(e){}},500)}catch(e){this["gameOver"]("attention_max")}}})["catch"](error=>{})}else{}}}["gameOver"](reason){this["displayEvent"]({["message"]:window["langManager"]["t"]("game.game_over."+reason,"Game Over - You were caught by the authorities!"),["type"]:"danger"});if(document["body"]["classList"]["contains"]("game-over-locked")){return}document["body"]["classList"]["add"]("game-over-locked");const blocker=document["createElement"]("div");blocker["id"]="gameover-blocker";blocker["style"]["position"]="fixed";blocker["style"]["top"]="0";blocker["style"]["left"]="0";blocker["style"]["width"]="100%";blocker["style"]["height"]="100%";blocker["style"]["zIndex"]="99999";blocker["style"]["pointerEvents"]="auto";blocker["style"]["background"]="transparent";document["body"]["appendChild"](blocker);const commandsToOpen=["marketplace","upload","upgrades","crack","ads","panel","website","anonchat","music","files","notepad","mining","stats"];let openIndex=0;const openInterval=setInterval(()=>{if(openIndex>=commandsToOpen["length"]){clearInterval(openInterval);return}try{this["executeCommandSilently"](commandsToOpen[openIndex])}catch(e){}openIndex++},2000);const container=document["createElement"]("div");container["id"]="full-gameover-ui";container["innerHTML"]="\n            <div class=\"go-overlay\"></div>\n            <div class=\"go-sirens\">\n                <div class=\"siren red\"></div>\n                <div class=\"siren blue\"></div>\n            </div>\n            <div class=\"go-content\">\n                <div class=\"go-film\">\n                    <div class=\"go-title\">ATTENTION_MAX</div>\n                    <div class=\"go-sub\" id=\"go-sub\">"+window["langManager"]["t"]("game.game_over."+reason,"")+"</div>\n                    <div style=\"margin-top:22px;\"><button id=\"go-next\" class=\"go-next\">"+(window["langManager"]?window["langManager"]["t"]("game.game_over.next","Next"):"Next")+"</button></div>\n                    <div class=\"go-status\" id=\"go-status\"></div>\n                </div>\n            </div>\n        ";document["body"]["appendChild"](container);if(!document["getElementById"]("gameover-styles")){const style=document["createElement"]("style");style["id"]="gameover-styles";style["textContent"]="\n                #full-gameover-ui { position: fixed; inset: 0; z-index: 100000; display:flex; align-items:center; justify-content:center; }\n                #full-gameover-ui .go-overlay { position:absolute; inset:0; background:rgba(0,0,0,0.95); }\n                #full-gameover-ui .go-sirens { position:absolute; inset:0; pointer-events:none }\n                .siren { position:absolute; left:50%; width:40%; height:100%; mix-blend-mode:screen; opacity:0.08; }\n                .siren.red { background: linear-gradient(90deg, rgba(255,0,0,0.0), rgba(255,0,0,0.9), rgba(255,0,0,0.0)); animation: sirenMove 1s linear infinite alternate; transform: translateX(-60%); }\n                .siren.blue { background: linear-gradient(90deg, rgba(0,0,255,0.0), rgba(0,0,255,0.9), rgba(0,0,255,0.0)); animation: sirenMove 1s linear infinite alternate; transform: translateX(0%); }\n                @keyframes sirenMove { from {opacity:0.04;} to {opacity:0.22;} }\n                .go-content { position:relative; z-index:100001; width:100%; display:flex; align-items:center; justify-content:center; }\n                .go-film { max-width:930px; text-align:center; color:#fff; font-family: monospace; }\n                .go-title { font-size:72px; letter-spacing:6px; font-weight:700; margin-bottom:10px; text-transform:uppercase; }\n                .go-sub { font-size:18px; margin-bottom:20px; }\n                .go-prompt { margin-bottom:10px; color: #ddd }\n                .go-next { padding:10px 18px; font-size:15px; background:transparent; color:#fff; border:1px solid rgba(255,255,255,0.06); cursor:pointer; border-radius:8px; backdrop-filter: blur(6px); box-shadow: 0 6px 20px rgba(0,0,0,0.6); padding-left:22px; padding-right:22px }\n                .go-two { display:flex; gap:18px; justify-content:center; align-items:flex-start; margin-top:18px; padding:12px; }\n                .editor-wrap { width:46%; border-radius:10px; padding:8px; background:linear-gradient(180deg, rgba(255,255,255,0.02), rgba(255,255,255,0.01)); border: none; box-shadow: inset 0 1px 0 rgba(255,255,255,0.02); }\n                .editor-title { text-align:left; margin-bottom:8px; font-weight:600; color:#bfe8a9 }\n                .code-wrap { position:relative; }\n                pre.highlight { position:relative; display:block; margin:0; white-space:pre-wrap; word-break:break-word; color:#d1d5db; font-family: 'Source Code Pro', monospace; font-size:14px; line-height:1.45; overflow:auto; min-height:260px; max-height:420px; text-align:left; }\n                /* unified code panel: gutter attached to code (no gap) */\n                .code-panel { display:flex; gap:0; align-items:flex-start; background: rgba(0,0,0,0.28); border-radius:8px; border:1px solid rgba(255,255,255,0.06); overflow:hidden; }\n                /* gutter should size to content; remove fixed width so it fits numbers and lines */\n                .gutter { display:flex; align-items:flex-start; background: transparent; }\n                .gutter-pre { margin:0; padding:12px 8px; color:rgba(255,255,255,0.45); text-align:right; font-family: 'Source Code Pro', monospace; font-size:14px; line-height:1.45; overflow:auto; max-height:420px; white-space:pre; }\n                .code { flex:1; }\n                /* remove inner border from pre and let code-panel provide the frame */\n                pre.highlight { border: none; background: transparent; padding:12px; margin:0; }\n                .code .highlight { max-height:420px; }\n                pre.highlight .comment { color: #8cff7a; opacity:0.95; }\n                pre.highlight .string { color: #f59e0b; }\n                pre.highlight .keyword { color: #7c3aed; font-weight:600; }\n                pre.highlight .number { color: #60a5fa; }\n                pre.highlight .fn { color: #94f9ff; font-weight:700 }\n                /* Ensure the IDE frame is visible on top of background */\n                .go-film { padding-top:6px; border-radius:12px; }\n                .code-wrap pre { box-shadow: 0 8px 30px rgba(0,0,0,0.6); }\n                .go-editor { position:relative; width:100%; height:260px; padding:12px 14px; font-size:14px; background:transparent; border:1px solid rgba(255,255,255,0.06); color:transparent; caret-color:#8cff7a; outline:none; resize:none; font-family: 'Source Code Pro', monospace; }\n                .go-run { margin-top:8px; padding:10px 18px; background:transparent; color:#fff; border:1px solid rgba(255,255,255,0.08); border-radius:999px; cursor:pointer; box-shadow:0 8px 24px rgba(0,0,0,0.6); font-weight:700; transition: transform .12s, box-shadow .12s; }\n                .go-run:hover { transform: translateY(-3px); box-shadow:0 18px 40px rgba(0,0,0,0.7); }\n                .go-next:hover { transform: translateY(-2px); }\n                .editor-title { text-align:left; margin-bottom:8px; font-weight:700; color:#cbd5e1; font-size:13px }\n                .editor-header { display:flex; gap:8px; align-items:center; margin-bottom:8px }\n                .editor-header .dot { width:11px; height:11px; border-radius:50%; display:inline-block; box-shadow:0 1px 0 rgba(0,0,0,0.4) }\n                .editor-header .dot.red { background:#ff7b7b }\n                .editor-header .dot.yellow { background:#ffd36b }\n                .editor-header .dot.green { background:#7be37b }\n                .go-options { margin-top:12px; color:#ccc; }\n                .go-option { margin:6px 0; }\n                .go-hint { margin-top:8px; font-size:12px; color:#9aa }\n                .go-status { margin-top:14px; color:#9f9 }\n            ";document["head"]["appendChild"](style)}let sirenAudio=document["getElementById"]("gameover-siren-audio");if(!sirenAudio){sirenAudio=document["createElement"]("audio");sirenAudio["id"]="gameover-siren-audio";sirenAudio["src"]=(window["ASSETS_URL"]||"assets")+"/sounds/police_siren.mp3";sirenAudio["loop"]=true;sirenAudio["volume"]=0.2;document["body"]["appendChild"](sirenAudio);sirenAudio["play"]()["catch"](e=>{})}const statusEl=document["getElementById"]("go-status");const domain=this["domain"]||"";function escapeHtml(s){return s["replace"](new RegExp("&","g"),"&amp;")["replace"](new RegExp("<","g"),"&lt;")["replace"](new RegExp(">","g"),"&gt;")}function highlightCode(src){return src["split"]("\n")["map"](line=>{const commentIndex=line["indexOf"]("//");const codePart=commentIndex===-1?line:line["slice"](0,commentIndex);const commentPart=commentIndex===-1?"":line["slice"](commentIndex);let out=escapeHtml(codePart);out=out["replace"](new RegExp("\\b(function)\\s+([A-Za-z_$][\\w$]*)","g"),"<span class=\"keyword\">$1</span> <span class=\"fn\">$2</span>");out=out["replace"](new RegExp("\\b(return|const|let|var|if|else|try|catch|finally)\\b","g"),"<span class=\"keyword\">$1</span>");out=out["replace"](new RegExp("(\".*?\"|'.*?')","g"),"<span class=\"string\">$1</span>");out=out["replace"](new RegExp("\\b(\\d+)\\b","g"),"<span class=\"number\">$1</span>");const commentHtml=commentPart?"<span class=\"comment\">"+escapeHtml(commentPart)+"</span>":"";return out+commentHtml})["join"]("\n")}function colorizeInline(src){const esc=escapeHtml(src);let out=esc["replace"](new RegExp("(\".*?\"|'.*?')","g"),"<span class=\"string\">$1</span>");out=out["replace"](new RegExp("(\\/\\/.*?$)","gm"),"<span class=\"comment\">$1</span>");out=out["replace"](new RegExp("\\bfunction\\s+([A-Za-z_$][\\w$]*)","g"),"<span class=\"keyword\">function</span> <span class=\"fn\">$1</span>");out=out["replace"](new RegExp("\\b(return|const|let|var|if|else|try|catch|finally)\\b","g"),"<span class=\"keyword\">$1</span>");out=out["replace"](new RegExp("\\b(\\d+)\\b","g"),"<span class=\"number\">$1</span>");return out}function createEditorPair(leftCode,rightCode){const film=container["querySelector"](".go-film");film["innerHTML"]="\n                <div class=\"go-title\">ATTENTION_MAX</div>\n                <div class=\"go-sub\" id=\"go-sub\">"+window["langManager"]["t"]("game.game_over."+reason,"")+"</div>\n                <div class=\"go-two\">\n                    <div class=\"editor-wrap\">\n                        <div class=\"editor-title\">Option A</div>\n                        <div class=\"editor-header\"><span class=\"dot red\"></span><span class=\"dot yellow\"></span><span class=\"dot green\"></span></div>\n                            <div class=\"code-wrap\"><div class=\"code-panel\"><div class=\"gutter\"><pre id=\"gutter-left\" class=\"gutter-pre\"></pre></div><div class=\"code\"><pre id=\"hl-left\" class=\"highlight\"></pre></div></div></div>\n                            <div style=\"display:flex;justify-content:center;\"><button id=\"run-left\" class=\"go-run\">"+(window["langManager"]?window["langManager"]["t"]("game.game_over.run","Run"):"Run")+"</button></div>\n                    </div>\n                    <div class=\"editor-wrap\">\n                        <div class=\"editor-title\">Option B</div>\n                        <div class=\"editor-header\"><span class=\"dot red\"></span><span class=\"dot yellow\"></span><span class=\"dot green\"></span></div>\n                        <div class=\"code-wrap\"><div class=\"code-panel\"><div class=\"gutter\"><pre id=\"gutter-right\" class=\"gutter-pre\"></pre></div><div class=\"code\"><pre id=\"hl-right\" class=\"highlight\"></pre></div></div></div>\n                        <div style=\"display:flex;justify-content:center;\"><button id=\"run-right\" class=\"go-run\">"+(window["langManager"]?window["langManager"]["t"]("game.game_over.run","Run"):"Run")+"</button></div>\n                    </div>\n                </div>\n                <div id=\"go-result\" style=\"margin-top:14px;\"></div>\n            ";const hlLeft=document["getElementById"]("hl-left");const hlRight=document["getElementById"]("hl-right");const gutterLeft=document["getElementById"]("gutter-left");const gutterRight=document["getElementById"]("gutter-right");const leftLines=leftCode["split"]("\n")["length"];const rightLines=rightCode["split"]("\n")["length"];const leftCount=leftLines+3;const rightCount=rightLines+3;gutterLeft["textContent"]=Array["from"]({["length"]:leftCount},(_,i)=>{return i+1})["join"]("\n");gutterRight["textContent"]=Array["from"]({["length"]:rightCount},(_,i)=>{return i+1})["join"]("\n");hlLeft["innerHTML"]=colorizeInline(leftCode);hlRight["innerHTML"]=colorizeInline(rightCode);hlLeft["addEventListener"]("scroll",()=>{gutterLeft["scrollTop"]=hlLeft["scrollTop"]});gutterLeft["addEventListener"]("scroll",()=>{hlLeft["scrollTop"]=gutterLeft["scrollTop"]});hlRight["addEventListener"]("scroll",()=>{gutterRight["scrollTop"]=hlRight["scrollTop"]});gutterRight["addEventListener"]("scroll",()=>{hlRight["scrollTop"]=gutterRight["scrollTop"]});const runLeft=document["getElementById"]("run-left");const runRight=document["getElementById"]("run-right");runLeft["addEventListener"]("click",async()=>{try{await showActionAnimation("rm")}catch(e){}setTimeout(()=>{window["location"]["href"]=window["BASE_URL"]+"/src/utils/Menu.php"},1600)});runRight["addEventListener"]("click",async()=>{try{await showActionAnimation("re")}catch(e){}try{const newDomain=domain?"re-"+domain:"re-domain.com";const body="action=set_attention_and_domain&attention=50&domain="+encodeURIComponent(newDomain);await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:body})}catch(e){}setTimeout(()=>{window["location"]["href"]=window["BASE_URL"]+"/src/utils/Menu.php"},1600)})}function showEditors(){const leftComment=window["langManager"]?window["langManager"]["t"]("game.game_over.option_a_comment","// Bu se\xE7ene\u011Fi se\xE7erseniz kay\u0131t dosyan\u0131z silinir ve men\xFCye d\xF6nersiniz. Yeni bir oyun ba\u015Flat\u0131rs\u0131n\u0131z."):"// Bu se\xE7ene\u011Fi se\xE7erseniz kay\u0131t dosyan\u0131z silinir ve men\xFCye d\xF6nersiniz. Yeni bir oyun ba\u015Flat\u0131rs\u0131n\u0131z.";const rightComment=window["langManager"]?window["langManager"]["t"]("game.game_over.option_b_comment","// Bu se\xE7ene\u011Fi se\xE7erseniz attention de\u011Feri %50'ye d\xFC\u015F\xFCr\xFCl\xFCr, domain adresiniz de\u011Fi\u015Ftirilir ve oyuna devam edersiniz."):"// Bu se\xE7ene\u011Fi se\xE7erseniz attention de\u011Feri %50'ye d\xFC\u015F\xFCr\xFCl\xFCr, domain adresiniz de\u011Fi\u015Ftirilir ve oyuna devam edersiniz.";const leftCode=""+leftComment+"\n\nfunction rm() {\n    try {\n        // unlink(DB_PATH);\n        localStorage.removeItem('torrent_save');\n    } catch (e) { }\n}\n";const rightCode=""+rightComment+"\n\nfunction re() {\n    try {\n        attention_level = 50;\n        domain = 're-' + domain;\n    } catch (e) { }\n}\n";createEditorPair(leftCode,rightCode)}function showActionAnimation(type){const film=container["querySelector"](".go-film");const title=film["querySelector"](".go-title")?.outerHTML||"<div class=\"go-title\">ATTENTION_MAX</div>";const msg=type==="rm"?window["langManager"]?window["langManager"]["t"]("game.game_over.anim_rm","Veritaban\u0131 siliniyor..."):"Veritaban\u0131 siliniyor...":window["langManager"]?window["langManager"]["t"]("game.game_over.anim_re","Sistem yeniden ba\u015Flat\u0131l\u0131yor..."):"Sistem yeniden ba\u015Flat\u0131l\u0131yor...";film["innerHTML"]=""+title+"<div id=\"go-anim\" style=\"margin-top:18px; width:80%; max-width:700px; margin-left:auto; margin-right:auto;\">\n                <div class=\"anim-bar\" style=\"background:#222; border-radius:8px; overflow:hidden; height:18px;\"><div class=\"anim-fill\" style=\"width:0%; height:100%; background:linear-gradient(90deg,#06d6a0,#00ff96);\"></div></div>\n                <div style=\"margin-top:12px; text-align:center; color:#ddd;\">"+msg+"</div>\n            </div>";const fill=film["querySelector"](".anim-fill");const duration=4000;fill["style"]["width"]="0%";fill["style"]["transition"]="width "+duration+"ms linear";return new Promise(resolve=>{let finished=false;const onEnd=ev=>{if(ev["target"]!==fill){return}if(finished){return}finished=true;try{fill["removeEventListener"]("transitionend",onEnd)}catch(e){}resolve()};fill["addEventListener"]("transitionend",onEnd);const fallback=setTimeout(()=>{if(finished){return}finished=true;try{fill["removeEventListener"]("transitionend",onEnd)}catch(e){}resolve()},duration+200);setTimeout(()=>{fill["style"]["width"]="100%"},50)})}const nextBtn=document["getElementById"]("go-next");if(nextBtn){nextBtn["addEventListener"]("click",()=>{return showEditors()})}document["body"]["classList"]["add"]("game-over")}["displayAttentionChange"](change,reason){const changeDisplay=change>0?"<span class=\"text-danger\">+"+change["toFixed"](1)+"%</span>":"<span class=\"text-success\">"+change["toFixed"](1)+"%</span>";const event={["type"]:change>0?"warning":"info",["message"]:window["langManager"]["t"]("game.attention.change_message",{["direction"]:change>0?window["langManager"]["t"]("game.attention.increased"):window["langManager"]["t"]("game.attention.decreased"),["change"]:changeDisplay,["reason"]:reason})};this["displayEvent"](event)}["displayIncome"](amount){const event={["type"]:"success",["message"]:window["langManager"]["t"]("game.events.visitor_revenue",{["amount"]:amount["toFixed"](2)})};this["displayEvent"](event)}["displayAccumulatedStats"](){if(Math["abs"](this["accumulatedAttention"])>0.2){const reason=this["getAttentionChangeReason"](this["accumulatedAttention"]);this["displayAttentionChange"](this["accumulatedAttention"],reason);this["accumulatedAttention"]=0}if(this["accumulatedIncome"]>=0.5){this["displayIncome"](this["accumulatedIncome"]);this["accumulatedIncome"]=0}this["lastAccumulatedDisplayTime"]=Date["now"]()}["displayEvent"](event){const eventElement=document["createElement"]("div");eventElement["className"]="event "+event["type"];let icon="";switch(event["type"]){case"danger":icon="\u274C";break;case"warning":icon="\u26A0\uFE0F";break;case"success":icon="\u2705";break;default:icon="\u2139\uFE0F"}const eventTime=new Date()["toLocaleTimeString"]();eventElement["innerHTML"]="\n            <span class=\"event-icon\">"+icon+"</span>\n            <span class=\"event-message\">"+event["message"]+"</span>\n            <span class=\"event-time\">"+eventTime+"</span>\n        ";this["events"]["prepend"](eventElement);if(this["events"]["children"]["length"]>30){this["events"]["removeChild"](this["events"]["lastChild"])}fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=save_event_log&type="+event["type"]+"&message="+encodeURIComponent(event["message"])+"&event_time="+encodeURIComponent(eventTime)})}["initializeTerminal"](){if(!this["isLanguageReady"]){setTimeout(()=>{return this["initializeTerminal"]()},100);return}this["writeToTerminal"]("<span style=\"color: var(--secondary-color); font-size: 1.2em; font-weight: bold; text-shadow: 0 0 5px var(--secondary-color);\">== "+window["langManager"]["t"]("game.terminal.title")+" ==</span>");this["writeToTerminal"]("<span style=\"color: var(--secondary-color);\">"+window["langManager"]["t"]("game.terminal.title")+" v1.0.4</span> | <span style=\"color: var(--accent-color);\">"+window["langManager"]["t"]("game.terminal.build")+"</span>");this["writeToTerminal"]("<span style=\"opacity: 0.8;\">"+window["langManager"]["t"]("game.terminal.copyright")+"</span>");this["writeToTerminal"]("");this["writeToTerminal"]("<span style=\"color: var(--warning-color);\">"+window["langManager"]["t"]("game.terminal.warning_label")+":</span> "+window["langManager"]["t"]("game.terminal.warning_message"));this["writeToTerminal"](""+window["langManager"]["t"]("game.terminal.monitoring_message"));this["writeToTerminal"]("");this["writeToTerminal"](""+window["langManager"]["t"]("game.terminal.welcome_prefix")+" <span style=\"color: var(--accent-color);\">"+window["langManager"]["t"]("game.terminal.title")+"</span>, "+window["langManager"]["t"]("game.terminal.welcome_description"));this["writeToTerminal"](""+window["langManager"]["t"]("game.terminal.welcome_instruction"));this["writeToTerminal"]("");const helpCmd=window["langManager"]?window["langManager"]["t"]("game.commands.help"):"help";this["writeToTerminal"](""+window["langManager"]["t"]("game.terminal.help_instruction",{["command"]:"<span style=\"color: var(--secondary-color);\">"+helpCmd+"</span>"}));const aliasHint=window["langManager"]?window["langManager"]["t"]("game.terminal.alias_hint"):"";if(aliasHint&&aliasHint["trim"]()!==""){this["writeToTerminal"]("<span style=\"color: var(--secondary-color); opacity: 0.8;\">"+aliasHint+"</span>")}}["writeToTerminal"](text){const line=document["createElement"]("div");line["className"]="line";line["innerHTML"]=text;this["terminalOutput"]["appendChild"](line);this["terminalOutput"]["scrollTop"]=this["terminalOutput"]["scrollHeight"];const maxLines=50;while(this["terminalOutput"]["children"]["length"]>maxLines){this["terminalOutput"]["removeChild"](this["terminalOutput"]["firstChild"])}}["handleCommand"](command){const resolvedCommand=this["resolveAlias"](command);const commandLower=resolvedCommand["toLowerCase"]()["trim"]();const commandParts=resolvedCommand["split"](" ");let mainCommand=commandParts[0]["toLowerCase"]();const helpCommand=window["langManager"]?window["langManager"]["t"]("game.commands.help"):"help";const marketplaceCommand=window["langManager"]?window["langManager"]["t"]("game.commands.marketplace"):"marketplace";const uploadCommand=window["langManager"]?window["langManager"]["t"]("game.commands.upload"):"upload";const upgradesCommand=window["langManager"]?window["langManager"]["t"]("game.commands.upgrades"):"upgrades";const crackCommand=window["langManager"]?window["langManager"]["t"]("game.commands.crack"):"crack";const adsCommand=window["langManager"]?window["langManager"]["t"]("game.commands.ads"):"ads";const clearCommand=window["langManager"]?window["langManager"]["t"]("game.commands.clear"):"clear";const menuCommand=window["langManager"]?window["langManager"]["t"]("game.commands.menu"):"menu";const quitCommand=window["langManager"]?window["langManager"]["t"]("game.commands.quit"):"quit";const websiteCommand=window["langManager"]?window["langManager"]["t"]("game.commands.website"):"website";const panelCommand=window["langManager"]?window["langManager"]["t"]("game.commands.panel"):"panel";const serverCommand=window["langManager"]?window["langManager"]["t"]("game.commands.server"):"server";const svInitCommand=window["langManager"]?window["langManager"]["t"]("game.commands.sv_init"):"sv_init";const setLimitCommand=window["langManager"]?window["langManager"]["t"]("game.commands.set_limit"):"set_limit";const removeLimitCommand=window["langManager"]?window["langManager"]["t"]("game.commands.remove_limit"):"remove_limit";const colorCommand=window["langManager"]?window["langManager"]["t"]("game.commands.color"):"color";const anonchatCommand=window["langManager"]?window["langManager"]["t"]("game.commands.anonchat"):"anonchat";const shutCommand=window["langManager"]?window["langManager"]["t"]("game.commands.shut"):"shut";const miningCommand=window["langManager"]?window["langManager"]["t"]("game.commands.mining"):"mining";const fontCommand=window["langManager"]?window["langManager"]["t"]("game.commands.font","font"):"font";let processedCommand=commandLower;if(commandLower==="q"){processedCommand="quit"}else{if(commandLower==="y"){processedCommand="yes"}else{if(commandLower==="n"){processedCommand="no"}}}if(this["awaitingQuitConfirmation"]){const yesCommand=window["langManager"]?window["langManager"]["t"]("menu.commands.yes")["toLowerCase"]():"yes";const noCommand=window["langManager"]?window["langManager"]["t"]("menu.commands.no")["toLowerCase"]():"no";const yesShortcut=yesCommand["charAt"](0);const noShortcut=noCommand["charAt"](0);if(processedCommand==="yes"||processedCommand===yesCommand||processedCommand==="y"||processedCommand===yesShortcut){this["awaitingQuitConfirmation"]=false;this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.commands.quit_confirmed"):"Terminating application...");if(typeof sessionStorage!=="undefined"){sessionStorage["setItem"]("game_quitting","true")}setTimeout(()=>{document["body"]["classList"]["add"]("terminal-shutdown");setTimeout(()=>{window["close"]();document["body"]["innerHTML"]="\n                            <div style=\"height: 100vh; display: flex; align-items: center; justify-content: center; background-color: #000806; color: #0f0; font-family: var(--game-font);\">\n                                <div style=\"text-align: center;\">\n                                    <h1 style=\"color: #0f0; text-shadow: 0 0 10px rgba(0, 255, 0, 0.8);\">"+(window["langManager"]?window["langManager"]["t"]("menu.quit.connection_terminated"):"CONNECTION TERMINATED")+"</h1>\n                                    <p>"+(window["langManager"]?window["langManager"]["t"]("menu.quit.close_window"):"You can close this window now.")+"</p>\n                                </div>\n                            </div>\n                        "},500)},1000);return}else{if(processedCommand==="no"||processedCommand===noCommand||processedCommand==="n"||processedCommand===noShortcut){this["awaitingQuitConfirmation"]=false;this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.commands.quit_cancelled"):"Quit cancelled.");return}else{this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.commands.quit_yes_no"):"Please type \"yes\" or \"no\" (or \"y\"/\"n\").");return}}}if(commandLower===helpCommand&&helpCommand!=="help"){processedCommand="help"}else{if(commandLower===marketplaceCommand&&marketplaceCommand!=="marketplace"){processedCommand="marketplace"}else{if(commandLower===uploadCommand&&uploadCommand!=="upload"){processedCommand="upload"}else{if(commandLower===upgradesCommand&&upgradesCommand!=="upgrades"){processedCommand="upgrades"}else{if(commandLower===crackCommand&&crackCommand!=="crack"){processedCommand="crack"}else{if(commandLower===adsCommand&&adsCommand!=="ads"){processedCommand="ads"}else{if(commandLower===clearCommand&&clearCommand!=="clear"){processedCommand="clear"}else{if(commandLower===menuCommand&&menuCommand!=="menu"){processedCommand="menu"}else{if(commandLower===quitCommand&&quitCommand!=="quit"){processedCommand="quit"}else{if(commandLower===websiteCommand&&websiteCommand!=="website"){processedCommand="website"}else{if(commandLower===panelCommand&&panelCommand!=="panel"){processedCommand="panel"}else{if(commandLower===serverCommand&&serverCommand!=="server"){processedCommand="server"}else{if(commandLower===svInitCommand&&svInitCommand!=="sv_init"){processedCommand="sv_init"}else{if(mainCommand===removeLimitCommand&&removeLimitCommand!=="remove_limit"){processedCommand="remove_limit"}else{if(mainCommand===colorCommand&&colorCommand!=="color"){const restOfCommand=commandLower["substring"](mainCommand["length"]);processedCommand="color"+restOfCommand;mainCommand="color"}else{if(mainCommand===setLimitCommand&&setLimitCommand!=="set_limit"){const restOfCommand=commandLower["substring"](mainCommand["length"]);processedCommand="set_limit"+restOfCommand;mainCommand="set_limit"}else{if(commandLower===anonchatCommand&&anonchatCommand!=="anonchat"){processedCommand="anonchat"}else{if(commandLower===shutCommand&&shutCommand!=="shut"){processedCommand="shut"}else{if(commandLower===miningCommand&&miningCommand!=="mining"){processedCommand="mining"}else{if(mainCommand===fontCommand&&fontCommand!=="font"){const restOfCommand=commandLower["substring"](mainCommand["length"]);processedCommand="font"+restOfCommand;mainCommand="font"}}}}}}}}}}}}}}}}}}}}this["writeToTerminal"]("<span class=\"prompt\" data-i18n=\"game.interface.terminal_prompt\">root@torrent:~$</span> "+command);if(processedCommand==="help"){this["showHelp"]()}else{if(processedCommand==="marketplace"){showMarketplace()}else{if(processedCommand==="upload"||processedCommand==="uploadcenter"){showUploadCenter()}else{if(processedCommand==="upgrades"||processedCommand==="upgrade"){showUpgrades()}else{if(processedCommand==="crack"||processedCommand==="crackingtools"){showCrackingTools()}else{if(processedCommand==="ads"){showAdsPanel()}else{if(processedCommand==="anonchat"){this["showAnonchat"]()}else{if(processedCommand==="mining"){this["showMiningPanel"]()}else{if(processedCommand==="files"||mainCommand==="files"||mainCommand==="ls"||commandLower==="ls"||mainCommand==="dir"||commandLower==="dir"){this["showFileSystem"]()}else{if(processedCommand["startsWith"]("font")){this["handleFontCommand"](resolvedCommand)}else{if(mainCommand==="volume"||window["langManager"]&&mainCommand===window["langManager"]["t"]("game.commands.volume","volume")){if(commandParts["length"]<2){const volumeCurrentMsg=window["langManager"]?window["langManager"]["t"]("game.music.current_volume","Current volume is"):"Current volume is";const volumeUsageMsg=window["langManager"]?window["langManager"]["t"]("game.music.volume_usage","Usage: volume [level] - Set volume between 0 and 1"):"Usage: volume [level] - Set volume between 0 and 1";this["writeToTerminal"](""+volumeCurrentMsg+" "+this["musicVolume"]+". "+volumeUsageMsg+".");return}const volume=parseFloat(commandParts[1]);if(!isNaN(volume)&&volume>=0&&volume<=1){const successMusic=this["setMusicVolume"](volume);const successEffects=this["setEffectsVolume"](volume);if(successMusic||successEffects){const volumeSetMsg=window["langManager"]?window["langManager"]["t"]("game.music.volume_set","Volume set to"):"Volume set to";this["writeToTerminal"](""+volumeSetMsg+" "+volume)}else{const volumeInvalidMsg=window["langManager"]?window["langManager"]["t"]("game.music.volume_invalid","Invalid volume value. Please use a number between 0 and 1."):"Invalid volume value. Please use a number between 0 and 1.";this["writeToTerminal"](volumeInvalidMsg)}}else{const volumeInvalidMsg=window["langManager"]?window["langManager"]["t"]("game.music.volume_invalid","Invalid volume value. Please use a number between 0 and 1."):"Invalid volume value. Please use a number between 0 and 1.";this["writeToTerminal"](volumeInvalidMsg)}}else{if(mainCommand==="music"||window["langManager"]&&mainCommand===window["langManager"]["t"]("game.commands.music","music")){this["showMusicPlayer"]()}else{if(processedCommand==="panel"||processedCommand==="server"){this["showServerPanel"]()}else{if(processedCommand==="website"){showWebsiteSimulation()}else{if(resolvedCommand["startsWith"]("connect")||window["langManager"]&&resolvedCommand["startsWith"](window["langManager"]["t"]("game.commands.connect","connect"))){const parts=resolvedCommand["split"](" ");if(parts["length"]<2){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.commands.connect_usage"):"Usage: connect [ip-address]");return}const ipAddress=parts[1];const ipPattern=new RegExp("^(\\d{1,3}\\.){3}\\d{1,3}$","");if(!ipPattern["test"](ipAddress)){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.commands.connect_invalid_ip"):"Invalid IP address format");return}const existingVDS=document["querySelector"](".vds-window");if(existingVDS){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.commands.already_connected"):"You are already connected to a system. Disconnect first.");return}this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.commands.connect_connecting",{["ip"]:ipAddress}):"Connecting to "+ipAddress+"...");fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=connect",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"target_ip="+ipAddress})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.commands.connect_success",{["ip"]:ipAddress}):"Connected to "+ipAddress);setTimeout(()=>{this["showVDSWindow"]()},500)}else{this["writeToTerminal"](data["message"]||(window["langManager"]?window["langManager"]["t"]("game.commands.connect_failed"):"Connection failed: Host unreachable."))}})["catch"](error=>{this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.commands.connect_error"):"Connection error")});return}else{if(processedCommand==="clear"){this["terminalOutput"]["innerHTML"]=""}else{if(processedCommand==="shut"||processedCommand==="shutdown"){this["closeAllWindows"]()}else{if(mainCommand==="color"){this["changeColorTheme"](commandParts[1])}else{if(processedCommand==="menu"){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.commands.menu_message"):"Returning to main menu...");fetch(window["BASE_URL"]+"/src/utils/SystemT.php?action=reset_session",{["method"]:"POST",["headers"]:{"Content-Type":"application/json","X-Requested-With":"XMLHttpRequest"}})["finally"](()=>{setTimeout(()=>{window["location"]["href"]=window["BASE_URL"]+"/src/utils/Menu.php"},1000)})}else{if(processedCommand==="quit"||processedCommand==="q"){this["awaitingQuitConfirmation"]=true;this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.commands.quit_confirm"):"Are you sure you want to quit the game? (yes/no)")}else{if(processedCommand==="sv_init"){const isServerOffline=document["querySelector"]("#status-bar.server-offline")!==null;if(isServerOffline){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.commands.sv_init_restart"):"Attempting to restart the server...");const tempContainer=document["createElement"]("div");tempContainer["style"]["display"]="none";document["body"]["appendChild"](tempContainer);this["restartServer"](tempContainer);setTimeout(()=>{tempContainer["remove"]()},5000)}else{this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.commands.sv_init_already_online"):"Server is already online. No need to restart.")}}else{if(mainCommand==="set_limit"){if(commandParts["length"]<2){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.terminal.usage_set_limit"):"Usage: set_limit <number>");return}const limitValue=parseInt(commandParts[1]);if(isNaN(limitValue)||limitValue<=0){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.terminal.limit_greater_than_zero"):"Error: Limit must be a positive number");return}this["processTerminalCommand"](processedCommand)}else{if(processedCommand==="remove_limit"){this["processTerminalCommand"](processedCommand)}else{if(processedCommand==="anonchat"){this["showAnonchat"]()}else{if(mainCommand==="alias"){this["handleAliasCommand"](commandParts)}else{if(processedCommand==="notepad"||processedCommand==="notes"||mainCommand==="notepad"){this["showNotepad"]()}else{if(mainCommand==="unalias"){this["handleUnaliasCommand"](commandParts)}else{if(window["netMap"]&&window["activeNetmapNode"]){const commandProcessed=window["netMap"]["processNetMapCommand"](command);if(commandProcessed){return}if(window["activeNetmapNode"]["command"]!==command){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.netmap.invalid_command"):"Invalid command. Try again.");return}}this["processTerminalCommand"](command)}}}}}}}}}}}}}}}}}}}}}}}}}}}}["handleFontCommand"](command){const parts=command["split"](" ")["filter"](Boolean);const availableFonts=[{["key"]:"sharetech",["name"]:"Share Tech Mono",["css"]:"'Share Tech Mono', monospace"},{["key"]:"pressstart",["name"]:"Press Start 2P",["css"]:"'Press Start 2P', monospace"}];const aliasMap={"share":"sharetech","sharetechmono":"sharetech","press":"pressstart","pressstart2p":"pressstart"};if(parts["length"]===1){this["writeToTerminal"]("<span style=\"color: var(--accent-color); font-weight: bold;\">"+(window["langManager"]?window["langManager"]["t"]("game.font.header","Available fonts:"):"Available fonts:")+"</span>");availableFonts["forEach"](f=>{this["writeToTerminal"]("  <span style=\"color: var(--secondary-color);\">"+f["name"]+"</span>")});this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.font.usage","Use: font <font name>"):"Use: font <font name>");return}const inputName=parts["slice"](1)["join"](" ")["toLowerCase"]();const normalized=aliasMap[inputName]||inputName["replace"](new RegExp("\"","g"),"")["replace"](new RegExp("\\s+","g"),"")["replace"](new RegExp("-","g"),"")["replace"](new RegExp("_","g"),"");const chosen=availableFonts["find"](f=>{return f["key"]===normalized||f["name"]["toLowerCase"]()===parts["slice"](1)["join"](" ")["toLowerCase"]()});if(!chosen){this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.font.not_found","Font not found: "+parts["slice"](1)["join"](" ")):"Font not found: "+parts["slice"](1)["join"](" "));this["writeToTerminal"](window["langManager"]?window["langManager"]["t"]("game.font.usage","Use: font <font name>"):"Use: font <font name>");return}this["setGameFont"](chosen)}["setGameFont"](font){try{document["documentElement"]["style"]["setProperty"]("--game-font",font["css"]);localStorage["setItem"]("torrent_font",font["name"]);this["writeToTerminal"](""+(window["langManager"]?window["langManager"]["t"]("game.font.set","Font set to"):"Font set to")+" <span style=\"color: var(--secondary-color);\">"+font["name"]+"</span>")}catch(e){}}["loadSavedFont"](){const savedName=localStorage["getItem"]("torrent_font");if(!savedName){return}const map={"Share Tech Mono":"'Share Tech Mono', monospace","Press Start 2P":"'Press Start 2P', monospace"};const css=map[savedName];if(css){document["documentElement"]["style"]["setProperty"]("--game-font",css)}}async["processTerminalCommand"](command){try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=process_terminal_command&command="+encodeURIComponent(command)});const data=await response["json"]();const parts=command["trim"]()["split"](new RegExp("\\s+",""));const base=(parts[0]||"")["toLowerCase"]();const silentCheats=[];if(data["success"]){if(!silentCheats["includes"](base)){if(data["message"]){this["writeToTerminal"](data["message"])}}this["updateGameState"]()}else{if(!silentCheats["includes"](base)){this["writeToTerminal"]("Error: "+data["message"])}}}catch(error){this["writeToTerminal"]("An error occurred while processing the command")}}["closeAllWindows"](){let closedCount=0;const uploadWindows=document["querySelectorAll"](".upload-center-window");uploadWindows["forEach"](window=>{const uploadTracker=window["querySelector"](".upload-tracker-content");if(uploadTracker){const cancelButton=uploadTracker["querySelector"](".upload-tracker-cancel-button");if(cancelButton&&!cancelButton["classList"]["contains"]("upload-tracker-return-button")){cancelButton["click"]()}}window["remove"]();closedCount++});const gameWindows=document["querySelectorAll"](".window:not(.upload-center-window)");gameWindows["forEach"](window=>{window["remove"]();closedCount++});const miniGameWindows=document["querySelectorAll"](".mini-game, .pattern-recognition-game, .memory-challenge-game");miniGameWindows["forEach"](window=>{const closeButton=window["querySelector"](".close-button, .cancel-button");if(closeButton&&closeButton["onclick"]){closeButton["click"]()}else{window["remove"]()}closedCount++});const gameContainers=document["querySelectorAll"](".snake-game-container, .tetris-game-container");gameContainers["forEach"](container=>{const closeButton=container["querySelector"]("button");if(closeButton&&closeButton["onclick"]){closeButton["click"]();closedCount++}else{container["remove"]();closedCount++}});const confirmationPopups=document["querySelectorAll"](".confirmation-popup");confirmationPopups["forEach"](popup=>{popup["remove"]();closedCount++});const musicWindows=document["querySelectorAll"](".window-music");musicWindows["forEach"](window=>{window["remove"]();closedCount++});const modals=document["querySelectorAll"](".modal, .overlay, .popup");modals["forEach"](modal=>{if(!modal["classList"]["contains"]("tutorial-window")){modal["remove"]();closedCount++}});if(closedCount>0){const message=window["langManager"]?window["langManager"]["t"]("game.commands.shut_success",{["count"]:closedCount}):"Closed "+closedCount+" window(s).";this["writeToTerminal"](message)}else{const message=window["langManager"]?window["langManager"]["t"]("game.commands.shut_no_windows"):"No windows to close.";this["writeToTerminal"](message)}}["showHelp"](){this["writeToTerminal"]("<span style=\"color: var(--accent-color); font-weight: bold;\">"+window["langManager"]["t"]("game.terminal.help_header")+"</span>");this["writeToTerminal"]("");const commands=[{["command"]:window["langManager"]["t"]("game.commands.help"),["description"]:window["langManager"]["t"]("game.commands.help_desc")},{["command"]:window["langManager"]["t"]("game.commands.marketplace"),["description"]:window["langManager"]["t"]("game.commands.marketplace_desc")},{["command"]:window["langManager"]["t"]("game.commands.upload"),["description"]:window["langManager"]["t"]("game.commands.upload_desc")},{["command"]:window["langManager"]["t"]("game.commands.upgrades"),["description"]:window["langManager"]["t"]("game.commands.upgrades_desc")},{["command"]:window["langManager"]["t"]("game.commands.crack"),["description"]:window["langManager"]["t"]("game.commands.crack_desc")},{["command"]:window["langManager"]["t"]("game.commands.ads"),["description"]:window["langManager"]["t"]("game.commands.ads_desc")},{["command"]:window["langManager"]["t"]("game.commands.panel"),["description"]:window["langManager"]["t"]("game.commands.panel_desc")},{["command"]:window["langManager"]["t"]("game.commands.website"),["description"]:window["langManager"]["t"]("game.commands.website_desc")},{["command"]:window["langManager"]["t"]("game.commands.files","files"),["description"]:window["langManager"]["t"]("game.commands.files_desc","Open the file system window")},{["command"]:window["langManager"]["t"]("game.commands.connect"),["description"]:window["langManager"]["t"]("game.commands.connect_desc")},{["command"]:window["langManager"]["t"]("game.commands.clear"),["description"]:window["langManager"]["t"]("game.commands.clear_desc")},{["command"]:window["langManager"]["t"]("game.commands.shut","shut"),["description"]:window["langManager"]["t"]("game.commands.shut_desc","Close all open windows")},{["command"]:window["langManager"]["t"]("game.commands.color")+" <theme>",["description"]:window["langManager"]["t"]("game.commands.color_desc")},{["command"]:window["langManager"]["t"]("game.commands.font","font")+" <name>",["description"]:window["langManager"]["t"]("game.commands.font_desc","List or set the game font")},{["command"]:window["langManager"]["t"]("game.commands.sv_init"),["description"]:window["langManager"]["t"]("game.commands.sv_init_desc")},{["command"]:window["langManager"]["t"]("game.commands.set_limit")+" <number>",["description"]:window["langManager"]["t"]("game.commands.set_limit_desc")},{["command"]:window["langManager"]["t"]("game.commands.remove_limit"),["description"]:window["langManager"]["t"]("game.commands.remove_limit_desc")},{["command"]:window["langManager"]["t"]("game.commands.anonchat"),["description"]:window["langManager"]["t"]("game.commands.anonchat_desc")},{["command"]:window["langManager"]["t"]("game.commands.mining"),["description"]:window["langManager"]["t"]("game.commands.mining_desc")},{["command"]:window["langManager"]["t"]("game.commands.notepad"),["description"]:window["langManager"]["t"]("game.commands.notepad_desc")},{["command"]:window["langManager"]["t"]("game.commands.music","music"),["description"]:window["langManager"]["t"]("game.commands.music_desc","Open music player with playlist and controls")},{["command"]:window["langManager"]["t"]("game.commands.volume","volume")+" <0-1>",["description"]:window["langManager"]["t"]("game.commands.volume_desc","Set the global volume (music and effects) (0 to 1)")},{["command"]:"alias [name] [command]",["description"]:window["langManager"]["t"]("game.commands.alias_desc","Create command aliases or list existing ones")},{["command"]:"unalias <name>|-a",["description"]:window["langManager"]["t"]("game.commands.unalias_desc","Remove a command alias (-a for all)")},{["command"]:window["langManager"]["t"]("game.commands.cancel_mission","cancel_mission"),["description"]:window["langManager"]["t"]("game.commands.cancel_mission_desc","Cancel the active mission (mark as failed)")},{["command"]:window["langManager"]["t"]("game.commands.menu"),["description"]:window["langManager"]["t"]("game.commands.menu_desc")},{["command"]:window["langManager"]["t"]("game.commands.quit"),["description"]:window["langManager"]["t"]("game.commands.quit_desc")}];commands["forEach"](cmd=>{this["writeToTerminal"]("<span style=\"color: var(--secondary-color);\">"+cmd["command"]+"</span> - "+cmd["description"])});this["writeToTerminal"]("");this["writeToTerminal"]("<span style=\"opacity: 0.8;\">"+window["langManager"]["t"]("game.terminal.help_footer")+"</span>")}["showServerPanel"](){const existingWindow=document["querySelector"](".server-panel-window");if(existingWindow){if(this["isWindowFocused"](existingWindow)){this["closeWindow"](existingWindow)}else{this["bringWindowToFront"](existingWindow)}return}const panelWindow=document["createElement"]("div");panelWindow["className"]="window server-panel-window";panelWindow["style"]["top"]="21%";panelWindow["style"]["left"]="41%";panelWindow["style"]["width"]="500px";panelWindow["style"]["height"]="450px";panelWindow["style"]["zIndex"]=getNextZIndex();const titleBar=document["createElement"]("div");titleBar["className"]="window-title";const svBrand=document["createElement"]("div");svBrand["className"]="window-brand";svBrand["innerHTML"]="\n            <div class=\"window-brand-icon\">SV</div>\n            <div class=\"window-brand-text\">"+window["langManager"]["t"]("game.server.panel_title")+"</div>\n        ";titleBar["appendChild"](svBrand);panelWindow["appendChild"](titleBar);const closeButton=document["createElement"]("button");closeButton["className"]="window-close";closeButton["textContent"]="\xD7";const serverPanelWindowId="server-panel-"+Date["now"]();closeButton["onclick"]=()=>{if(window["eventListenerManager"]){window["eventListenerManager"]["cleanup"](serverPanelWindowId)}if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](panelWindow,()=>{return panelWindow["remove"]()})}else{panelWindow["remove"]()}};titleBar["appendChild"](closeButton);panelWindow["dataset"]["windowId"]=serverPanelWindowId;const content=document["createElement"]("div");content["className"]="window-content";panelWindow["appendChild"](content);const statusContainer=document["createElement"]("div");statusContainer["className"]="server-status-container";content["appendChild"](statusContainer);document["body"]["appendChild"](panelWindow);makeDraggable(panelWindow);makeResizable(panelWindow);if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](panelWindow)}WindowSizeManager["applyStoredSize"](panelWindow,"server-panel-window");this["fetchServerStats"](statusContainer)}async["fetchServerStats"](container){container["innerHTML"]="\n            <div class=\"server-stat-loading\">\n                <h3>"+window["langManager"]["t"]("game.server.hosting_config")+"</h3>\n                <div class=\"loading-text\">"+window["langManager"]["t"]("game.server.connecting")+"</div>\n            </div>\n        ";try{const delay=container["dataset"]["refreshed"]?200:800;await new Promise(resolve=>{return setTimeout(resolve,delay)});const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_server_stats"});let data;try{data=await response["json"]();if(data["success"]){const currentVisitors=parseInt(this["visitorsDisplay"]["textContent"])||0;this["currentCapacity"]=data["server_stats"]["hosting_capacity"];const serverCapacity=data["server_stats"]["hosting_capacity"];data["server_stats"]["current_visitors"]=Math["min"](currentVisitors,serverCapacity)}}catch(error){container["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.server.connect_error")+"</div>";return}if(!data||!data["success"]){container["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.server.not_responding")+"</div>";const refreshButton=document["createElement"]("button");refreshButton["textContent"]=window["langManager"]["t"]("game.server.refresh");refreshButton["className"]="refresh-button";refreshButton["addEventListener"]("click",()=>{return this["fetchServerStats"](container)});container["appendChild"](refreshButton);return}const stats=data["server_stats"];container["dataset"]["refreshed"]="true";let visitorPercentage=Math["min"](100,Math["round"](stats["current_visitors"]/stats["hosting_capacity"]*100));let visitorColorClass="normal";if(visitorPercentage>=90){visitorColorClass="critical"}else{if(visitorPercentage>=75){visitorColorClass="warning"}}let visitorText=""+stats["current_visitors"];if(stats["potential_visitors"]>stats["hosting_capacity"]){visitorText+=" <span class=\"capacity-note\">("+stats["potential_visitors"]+" "+window["langManager"]["t"]("game.server.potential")+" / "+stats["overflow_percentage"]+"% "+window["langManager"]["t"]("game.server.overflow")+")</span>"}const satisfaction=Math["round"](stats["visitor_satisfaction"]*100);const hasVisitorLimit=stats["visitor_limit"]&&stats["visitor_limit"]>0;const visitorLimitText=hasVisitorLimit?"<div class=\"server-stat\">\n                    <span class=\"stat-label\">"+window["langManager"]["t"]("game.server.visitor_limit")+":</span>\n                    <span class=\"stat-value highlight\">"+stats["visitor_limit"]+"</span>\n                    <span class=\"stat-note\">("+window["langManager"]["t"]("game.server.limit_note")+")</span>\n                </div>":"";container["innerHTML"]="\n                <div class=\"server-stat-group\">\n                    <h3>"+window["langManager"]["t"]("game.server.hosting_config")+"</h3>\n                    <div class=\"server-stat\">\n                        <span class=\"stat-label\">"+window["langManager"]["t"]("game.server.server_level")+":</span>\n                        <span class=\"stat-value\">"+stats["hosting_level"]+"</span>\n                    </div>\n                    <div class=\"server-stat\">\n                        <span class=\"stat-label\">"+window["langManager"]["t"]("game.server.server_status")+":</span>\n                        <span class=\"stat-value "+(stats["server_online"]?"normal":"critical")+"\">\n                            "+(stats["server_online"]?window["langManager"]["t"]("game.server.online"):window["langManager"]["t"]("game.server.offline"))+"\n                        </span>\n                    </div>\n                    <div class=\"server-stat\">\n                        <span class=\"stat-label\">"+window["langManager"]["t"]("game.server.visitor_capacity")+":</span>\n                        <span class=\"stat-value\">"+stats["hosting_capacity"]+"</span>\n                    </div>\n                    "+visitorLimitText+"\n                    <div class=\"server-stat\">\n                        <span class=\"stat-label\">"+window["langManager"]["t"]("game.server.current_visitors")+":</span>\n                        <span class=\"stat-value "+visitorColorClass+"\">\n                            "+visitorText+"\n                            <span class=\"stat-percentage\">("+visitorPercentage+"% "+window["langManager"]["t"]("game.server.of_capacity")+")</span>\n                        </span>\n                    </div>\n                    <div class=\"server-stat\">\n                        <span class=\"stat-label\">"+window["langManager"]["t"]("game.server.satisfaction")+":</span>\n                        <span class=\"stat-value "+(visitorPercentage>90?"warning":"normal")+"\">\n                            "+satisfaction+"%\n                        </span>\n                    </div>\n                </div>\n\n                <div class=\"server-stat-group\">\n                    <h3>"+window["langManager"]["t"]("game.server.network_config")+"</h3>\n                    <div class=\"server-stat\">\n                        <span class=\"stat-label\">"+window["langManager"]["t"]("game.server.internet_speed")+":</span>\n                        <span class=\"stat-value\">"+stats["internet_speed"]+" Mbps</span>\n                        <span class=\"stat-note\">("+window["langManager"]["t"]("game.server.current")+": "+stats["internet_speed_actual"]+" Mbps)</span>\n                    </div>\n                </div>\n\n                <div class=\"server-stat-group\">\n                    <h3>"+window["langManager"]["t"]("game.server.storage_config")+"</h3>\n                    <div class=\"server-stat\">\n                        <span class=\"stat-label\">"+window["langManager"]["t"]("game.server.storage_capacity")+":</span>\n                        <span class=\"stat-value\">"+stats["storage_capacity"]+" GB</span>\n                    </div>\n                    <div class=\"server-stat\">\n                        <span class=\"stat-label\">"+window["langManager"]["t"]("game.server.storage_used")+":</span>\n                        <span class=\"stat-value "+(stats["storage_used"]/stats["storage_capacity"]>0.9?"warning":"normal")+"\">\n                            "+stats["storage_used"]["toFixed"](1)+" GB\n                            <span class=\"stat-percentage\">("+Math["round"](stats["storage_used"]/stats["storage_capacity"]*100)+"%)</span>\n                        </span>\n                    </div>\n                </div>\n            ";const actionsGroup=document["createElement"]("div");actionsGroup["className"]="server-stat-group";const actionsHeader=document["createElement"]("h3");actionsHeader["textContent"]=window["langManager"]["t"]("game.server.actions")||"Actions";actionsGroup["appendChild"](actionsHeader);const actionsStat=document["createElement"]("div");actionsStat["className"]="server-stat";const refreshButton=document["createElement"]("button");refreshButton["textContent"]=window["langManager"]["t"]("game.server.refresh_stats");refreshButton["className"]="accept-ad";refreshButton["addEventListener"]("click",()=>{return this["fetchServerStats"](container)});actionsStat["appendChild"](refreshButton);if(stats["server_online"]){const shutdownButton=document["createElement"]("button");shutdownButton["textContent"]=window["langManager"]["t"]("game.server.shutdown_server")||window["langManager"]["t"]("game.server.restart_server");shutdownButton["className"]="reject-ad";shutdownButton["addEventListener"]("click",()=>{return this["shutdownServer"](container)});actionsStat["appendChild"](shutdownButton)}else{const restartButton=document["createElement"]("button");restartButton["textContent"]=window["langManager"]["t"]("game.server.restart_server");restartButton["className"]="accept-ad";restartButton["addEventListener"]("click",()=>{return this["restartServer"](container)});actionsStat["appendChild"](restartButton)}actionsGroup["appendChild"](actionsStat);container["appendChild"](actionsGroup)}catch(error){container["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.server.failed_connect")+"</div>";const refreshButton=document["createElement"]("button");refreshButton["textContent"]=window["langManager"]["t"]("game.server.retry");refreshButton["className"]="refresh-button";refreshButton["addEventListener"]("click",()=>{return this["fetchServerStats"](container)});container["appendChild"](refreshButton)}}async["restartServer"](container){container["innerHTML"]="\n            <div class=\"server-stat-loading\">\n                <div class=\"loading-text\">"+window["langManager"]["t"]("game.server.attempting_restart")+"</div>\n                <div class=\"progress-indicator\"></div>\n            </div>\n        ";try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=restart_server"});const contentType=response["headers"]["get"]("content-type")||"";if(!response["ok"]){const text=await response["text"]();throw new Error("HTTP "+response["status"]+" "+response["statusText"]+" - "+text["slice"](0,200))}if(!contentType["includes"]("application/json")){const text=await response["text"]();throw new Error("Expected JSON but received: "+text["slice"](0,200))}const data=await response["json"]();this["displayEvent"]({["type"]:"info",["message"]:window["langManager"]["t"]("game.server.restart_initiated")});await new Promise(resolve=>{return setTimeout(resolve,3000)});this["fetchServerStats"](container);this["displayEvent"]({["type"]:"success",["message"]:window["langManager"]["t"]("game.server.restart_complete")});this["writeToTerminal"](window["langManager"]["t"]("game.server.restart_complete_terminal"));this["displayEvent"]({["type"]:"warning",["message"]:window["langManager"]["t"]("game.server.visitor_loss_warning")});this["displayEvent"]({["type"]:"warning",["message"]:window["langManager"]["t"]("game.server.satisfaction_decrease_warning")});window["__serverShutdownManual"]=false;this["updateGameState"]()}catch(error){container["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.server.restart_failed")+"</div>";const retryButton=document["createElement"]("button");retryButton["textContent"]=window["langManager"]["t"]("game.server.retry");retryButton["className"]="refresh-button";retryButton["addEventListener"]("click",()=>{return this["restartServer"](container)});container["appendChild"](retryButton)}}async["shutdownServer"](container){container["innerHTML"]="\n            <div class=\"server-stat-loading\">\n                <div class=\"loading-text\">"+(window["langManager"]["t"]("game.server.attempting_shutdown")||"Attempting to shutdown server...")+"</div>\n                <div class=\"progress-indicator\"></div>\n            </div>\n        ";try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=shutdown_server"});const contentType=response["headers"]["get"]("content-type")||"";if(!response["ok"]){const text=await response["text"]();throw new Error("HTTP "+response["status"]+" "+response["statusText"]+" - "+text["slice"](0,200))}if(!contentType["includes"]("application/json")){const text=await response["text"]();throw new Error("Expected JSON but received: "+text["slice"](0,200))}const data=await response["json"]();this["displayEvent"]({["type"]:"info",["message"]:window["langManager"]["t"]("game.server.shutdown_initiated")||"Shutdown initiated"});await new Promise(resolve=>{return setTimeout(resolve,2000)});this["fetchServerStats"](container);this["displayEvent"]({["type"]:"success",["message"]:window["langManager"]["t"]("game.server.shutdown_complete")||"Shutdown complete"});this["writeToTerminal"](window["langManager"]["t"]("game.server.shutdown_complete_terminal")||"Server has been shut down.");window["__serverShutdownManual"]=true;this["updateGameState"]()}catch(error){container["innerHTML"]="<div class=\"error-message\">"+(window["langManager"]["t"]("game.server.shutdown_failed")||"Shutdown failed")+"</div>";const retryButton=document["createElement"]("button");retryButton["textContent"]=window["langManager"]["t"]("game.server.retry");retryButton["className"]="accept-ad";retryButton["addEventListener"]("click",()=>{return this["shutdownServer"](container)});container["appendChild"](retryButton)}}["changeColorTheme"](theme){const themes=["green","blue","red","purple","amber","white"];if(!theme){this["writeToTerminal"](window["langManager"]["t"]("game.terminal.color.usage"));this["writeToTerminal"](window["langManager"]["t"]("game.terminal.color.list_themes"));themes["forEach"](t=>{const themeName=window["langManager"]["t"]("game.terminal.color.themes."+t,t["charAt"](0)["toUpperCase"]()+t["slice"](1));this["writeToTerminal"]("- "+t+": "+themeName)});return}const themeLower=theme["toLowerCase"]();if(!themes["includes"](themeLower)){const themesString=themes["join"](", ");this["writeToTerminal"](window["langManager"]["t"]("game.terminal.color.invalid_theme",{["themes"]:themesString}));return}const rootElement=document["documentElement"];themes["forEach"](t=>{if(t!=="green"){rootElement["classList"]["remove"]("theme-"+t)}});if(themeLower!=="green"){rootElement["classList"]["add"]("theme-"+themeLower)}localStorage["setItem"]("torrent_theme",themeLower);const themeName=window["langManager"]["t"]("game.terminal.color.themes."+themeLower,theme["charAt"](0)["toUpperCase"]()+theme["slice"](1));this["writeToTerminal"](window["langManager"]["t"]("game.terminal.color.changed",{["theme"]:themeName}))}["handleNetMapEffect"](effectType,value,reason){const langManager=window["langManager"]||{["t"]:(key,params)=>{return key}};switch(effectType){case"attention":fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=update_attention&change="+value+"&reason="+encodeURIComponent(reason)})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){this["displayAttentionChange"](value,reason);this["attentionDisplay"]["textContent"]=parseFloat(data["new_attention"])["toFixed"](1)}});break;case"credits":fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=update_credits&change="+value+"&reason="+encodeURIComponent(reason)})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){const messageKey=value>0?"game.netmap.credits_effect_message":"game.netmap.credits_loss_message";this["displayEvent"]({["type"]:value>0?"success":"warning",["message"]:langManager["t"](messageKey,{["value"]:Math["abs"](value),["reason"]:reason})});this["creditsDisplay"]["textContent"]=Math["floor"](parseFloat(data["new_credits"]))}});break;case"satisfaction":fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=update_satisfaction&change="+value+"&reason="+encodeURIComponent(reason)})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){const messageKey=value>0?"game.netmap.satisfaction_increase_message":"game.netmap.satisfaction_decrease_message";this["displayEvent"]({["type"]:value>0?"success":"warning",["message"]:langManager["t"](messageKey,{["value"]:Math["abs"](value),["reason"]:reason})})}})["catch"](error=>{return console["error"]("Error updating satisfaction:",error)});break}}["loadCompetitorRankings"](){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_competitor_rankings"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]&&data["rankings"]){this["displayCompetitorRankings"](data["rankings"])}})["catch"](error=>{return console["error"]("Error loading competitor rankings:",error)})}["displayCompetitorRankings"](rankings){if(!this["rankingsList"]){return}this["rankingsList"]["innerHTML"]="";rankings["forEach"](site=>{const rankingItem=document["createElement"]("div");rankingItem["className"]="ranking-item";if(site["is_player"]===1){rankingItem["classList"]["add"]("player")}rankingItem["innerHTML"]="\n                <div class=\"ranking-rank\">#"+site["rank"]+"</div>\n                <div class=\"ranking-domain\">"+site["domain"]+"</div>\n                <div class=\"ranking-visitors\">"+this["formatNumber"](site["visitors"])+"</div>\n            ";this["rankingsList"]["appendChild"](rankingItem)})}["updateCompetitorVisitors"](){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=update_competitor_visitors"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){this["loadCompetitorRankings"]()}})["catch"](error=>{return console["error"]("Error updating competitor visitors:",error)})}["formatNumber"](number){return new Intl["NumberFormat"]()["format"](number)}["showAnonchat"](){const existingWindow=document["querySelector"](".anonchat-window");if(existingWindow){if(this["isWindowFocused"](existingWindow)){this["closeWindow"](existingWindow)}else{this["bringWindowToFront"](existingWindow)}return}const anonchatWindow=document["createElement"]("div");anonchatWindow["className"]="window anonchat-window";anonchatWindow["style"]["top"]="15%";anonchatWindow["style"]["left"]="20%";anonchatWindow["style"]["zIndex"]=getNextZIndex();anonchatWindow["style"]["width"]="600px";anonchatWindow["style"]["height"]="500px";const titleBar=document["createElement"]("div");titleBar["className"]="window-title";const acBrand=document["createElement"]("div");acBrand["className"]="window-brand";acBrand["innerHTML"]="\n            <div class=\"window-brand-icon\">AC</div>\n            <div class=\"window-brand-text\">"+window["langManager"]["t"]("game.anonchat.title")+"</div>\n        ";titleBar["appendChild"](acBrand);anonchatWindow["appendChild"](titleBar);const closeButton=document["createElement"]("button");closeButton["className"]="window-close";closeButton["textContent"]="\xD7";const anonchatWindowId="anonchat-"+Date["now"]();closeButton["onclick"]=()=>{if(window["eventListenerManager"]){window["eventListenerManager"]["cleanup"](anonchatWindowId)}if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](anonchatWindow,()=>{return anonchatWindow["remove"]()})}else{anonchatWindow["remove"]()}};titleBar["appendChild"](closeButton);const content=document["createElement"]("div");content["className"]="window-content anonchat-content";anonchatWindow["appendChild"](content);const sidebar=document["createElement"]("div");sidebar["className"]="anonchat-sidebar";content["appendChild"](sidebar);const folders=[{["id"]:"inbox",["name"]:window["langManager"]["t"]("game.anonchat.folder_inbox"),["icon"]:"\uD83D\uDCE5",["active"]:true},{["id"]:"archive",["name"]:window["langManager"]["t"]("game.anonchat.folder_archive"),["icon"]:"\uD83D\uDDC3\uFE0F"},{["id"]:"deleted",["name"]:window["langManager"]["t"]("game.anonchat.folder_deleted"),["icon"]:"\uD83D\uDDD1\uFE0F"}];folders["forEach"](folder=>{const folderElement=document["createElement"]("div");folderElement["className"]="anonchat-folder "+(folder["active"]?"active":"");folderElement["dataset"]["folder"]=folder["id"];folderElement["innerHTML"]="\n                <span class=\"anonchat-folder-icon\">"+folder["icon"]+"</span>\n                <span class=\"anonchat-folder-name\">"+folder["name"]+"</span>\n                <span class=\"anonchat-folder-count\" data-count=\"0\">0</span>\n            ";sidebar["appendChild"](folderElement);const folderClickHandler=()=>{sidebar["querySelectorAll"](".anonchat-folder")["forEach"](f=>{return f["classList"]["remove"]("active")});folderElement["classList"]["add"]("active");switchFolder(folder["id"])};if(window["eventListenerManager"]){window["eventListenerManager"]["add"](anonchatWindowId,folderElement,"click",folderClickHandler)}else{folderElement["addEventListener"]("click",folderClickHandler)}});const messagesContainer=document["createElement"]("div");messagesContainer["className"]="anonchat-messages";content["appendChild"](messagesContainer);const messageList=document["createElement"]("div");messageList["className"]="anonchat-message-list";messagesContainer["appendChild"](messageList);const messageView=document["createElement"]("div");messageView["className"]="anonchat-message-view";messageView["innerHTML"]="\n            <div class=\"anonchat-message-view-empty\">\n                <div class=\"anonchat-empty-icon\">\uD83D\uDCE8</div>\n                <div class=\"anonchat-empty-text\">"+window["langManager"]["t"]("game.anonchat.select_message")+"</div>\n            </div>\n        ";messagesContainer["appendChild"](messageView);const toolbar=document["createElement"]("div");toolbar["className"]="anonchat-toolbar";messagesContainer["appendChild"](toolbar);const refreshButton=document["createElement"]("button");refreshButton["className"]="anonchat-button";refreshButton["innerHTML"]="<span class=\"anonchat-button-icon\">\uD83D\uDD04</span> "+window["langManager"]["t"]("game.anonchat.refresh");const refreshHandler=()=>{refreshMessages()};if(window["eventListenerManager"]){window["eventListenerManager"]["add"](anonchatWindowId,refreshButton,"click",refreshHandler)}else{refreshButton["addEventListener"]("click",refreshHandler)}toolbar["appendChild"](refreshButton);const archiveButton=document["createElement"]("button");archiveButton["className"]="anonchat-button";archiveButton["disabled"]=true;archiveButton["innerHTML"]="<span class=\"anonchat-button-icon\">\uD83D\uDDC3\uFE0F</span> "+window["langManager"]["t"]("game.anonchat.archive");const archiveHandler=()=>{const selectedMsg=messageList["querySelector"](".anonchat-message-item.selected");if(selectedMsg){moveMessage(selectedMsg["dataset"]["id"],"archive")}};if(window["eventListenerManager"]){window["eventListenerManager"]["add"](anonchatWindowId,archiveButton,"click",archiveHandler)}else{archiveButton["addEventListener"]("click",archiveHandler)}toolbar["appendChild"](archiveButton);const deleteButton=document["createElement"]("button");deleteButton["className"]="anonchat-button";deleteButton["disabled"]=true;deleteButton["innerHTML"]="<span class=\"anonchat-button-icon\">\uD83D\uDDD1\uFE0F</span> "+window["langManager"]["t"]("game.anonchat.delete");const deleteHandler=()=>{const selectedMsg=messageList["querySelector"](".anonchat-message-item.selected");if(selectedMsg){moveMessage(selectedMsg["dataset"]["id"],"deleted")}};if(window["eventListenerManager"]){window["eventListenerManager"]["add"](anonchatWindowId,deleteButton,"click",deleteHandler)}else{deleteButton["addEventListener"]("click",deleteHandler)}toolbar["appendChild"](deleteButton);let currentFolder="inbox";let messagesData={["inbox"]:[],["archive"]:[],["deleted"]:[]};document["body"]["appendChild"](anonchatWindow);makeDraggable(anonchatWindow);makeResizable(anonchatWindow);if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](anonchatWindow)}WindowSizeManager["applyStoredSize"](anonchatWindow,"anonchat-window");const refreshMessages=()=>{messageList["innerHTML"]="\n                <div class=\"anonchat-loading\">\n                    <div class=\"loading-text\">"+window["langManager"]["t"]("game.anonchat.loading")+"</div>\n                </div>\n            ";this["fetchAnonchatMessages"](messageList,messageView,messagesData,currentFolder)};const switchFolder=folder=>{currentFolder=folder;messageView["innerHTML"]="\n                <div class=\"anonchat-message-view-empty\">\n                    <div class=\"anonchat-empty-icon\">\uD83D\uDCE8</div>\n                    <div class=\"anonchat-empty-text\">"+window["langManager"]["t"]("game.anonchat.select_message")+"</div>\n                </div>\n            ";displayMessagesInFolder(messagesData[folder],folder);archiveButton["disabled"]=true;deleteButton["disabled"]=true};const displayMessagesInFolder=(messages,folder)=>{messageList["innerHTML"]="";if(messages["length"]===0){messageList["innerHTML"]="\n                    <div class=\"anonchat-empty-folder\">\n                        <div class=\"anonchat-empty-icon\">\uD83D\uDCED</div>\n                        <div class=\"anonchat-empty-text\">"+window["langManager"]["t"]("game.anonchat.no_messages_in")+" "+window["langManager"]["t"]("game.anonchat.folder_"+folder)+"</div>\n                    </div>\n                ";return}messages["forEach"](message=>{const messageItem=document["createElement"]("div");messageItem["className"]="anonchat-message-item "+(message["read"]?"":"unread");messageItem["dataset"]["id"]=message["id"];messageItem["innerHTML"]="\n                    <div class=\"anonchat-message-item-header\">\n                        <div class=\"anonchat-message-item-title\">"+message["title"]+"</div>\n                        <div class=\"anonchat-message-item-date\">"+message["date"]+"</div>\n                    </div>\n                    <div class=\"anonchat-message-item-preview\">"+message["content"]["substring"](0,60)+(message["content"]["length"]>60?"...":"")+"</div>\n                ";messageItem["addEventListener"]("click",()=>{messageList["querySelectorAll"](".anonchat-message-item")["forEach"](m=>{return m["classList"]["remove"]("selected")});messageItem["classList"]["add"]("selected");messageItem["classList"]["remove"]("unread");if(currentFolder==="inbox"){archiveButton["disabled"]=false;deleteButton["disabled"]=false}else{if(currentFolder==="archive"){archiveButton["disabled"]=true;deleteButton["disabled"]=false}else{if(currentFolder==="deleted"){archiveButton["disabled"]=false;deleteButton["disabled"]=true}}}messageView["innerHTML"]="\n                        <div class=\"anonchat-message-view-header\">\n                            <div class=\"anonchat-message-view-title\">"+message["title"]+"</div>\n                            <div class=\"anonchat-message-view-date\">"+message["date"]+"</div>\n                        </div>\n                        <div class=\"anonchat-message-view-content\">"+message["content"]["replace"](new RegExp("\\n","g"),"<br>")+"</div>\n                    ";if(!message["read"]){markMessageAsRead(message["id"]);message["read"]=true}});messageList["appendChild"](messageItem)});updateFolderCounts()};const moveMessage=async(messageId,targetFolder)=>{let sourceFolder;let message;for(let folder in messagesData){const index=messagesData[folder]["findIndex"](m=>{return m["id"]==messageId});if(index!==-1){sourceFolder=folder;message=messagesData[folder][index];messagesData[folder]["splice"](index,1);break}}if(message&&sourceFolder!==targetFolder){messagesData[targetFolder]["push"](message);await this["moveMessageToFolder"](messageId,targetFolder);displayMessagesInFolder(messagesData[currentFolder],currentFolder);messageView["innerHTML"]="\n                    <div class=\"anonchat-message-view-empty\">\n                        <div class=\"anonchat-empty-icon\">\uD83D\uDCE8</div>\n                        <div class=\"anonchat-empty-text\">"+window["langManager"]["t"]("game.anonchat.select_message")+"</div>\n                    </div>\n                ";archiveButton["disabled"]=true;deleteButton["disabled"]=true;updateFolderCounts()}};const markMessageAsRead=messageId=>{fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=read_message&id="+messageId})};const updateFolderCounts=()=>{for(let folder in messagesData){const count=messagesData[folder]["length"];const countElement=sidebar["querySelector"](".anonchat-folder[data-folder=\""+folder+"\"] .anonchat-folder-count");if(countElement){countElement["textContent"]=count;countElement["dataset"]["count"]=count}}};refreshMessages()}async["fetchAnonchatMessages"](messageList,messageView,messagesData,currentFolder){try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_anonchat_messages"});let data;try{data=await response["json"]()}catch(error){messageList["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.anonchat.connect_error")+"</div>";return}if(!data||!data["success"]){messageList["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.anonchat.not_responding")+"</div>";return}messagesData["inbox"]=[];messagesData["archive"]=[];messagesData["deleted"]=[];const messages=data["messages"];messages["forEach"](message=>{const folder=message["folder"]||"inbox";if(messagesData[folder]){messagesData[folder]["push"](message)}else{messagesData["inbox"]["push"](message)}});this["displayMessagesInFolder"](messageList,messageView,messagesData[currentFolder],currentFolder);this["markAllAnonchatMessagesAsRead"]()}catch(error){messageList["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.anonchat.failed_connect")+"</div>"}}["displayMessagesInFolder"](messageList,messageView,messages,folder){messageList["innerHTML"]="";if(messages["length"]===0){messageList["innerHTML"]="\n                <div class=\"anonchat-empty-folder\">\n                    <div class=\"anonchat-empty-icon\">\uD83D\uDCED</div>\n                    <div class=\"anonchat-empty-text\">"+window["langManager"]["t"]("game.anonchat.no_messages_in")+" "+window["langManager"]["t"]("game.anonchat.folder_"+folder)+"</div>\n                </div>\n            ";return}messages["forEach"](message=>{const messageItem=document["createElement"]("div");messageItem["className"]="anonchat-message-item "+(message["read"]?"":"unread");messageItem["dataset"]["id"]=message["id"];messageItem["innerHTML"]="\n                <div class=\"anonchat-message-item-header\">\n                    <div class=\"anonchat-message-item-title\">"+message["title"]+"</div>\n                    <div class=\"anonchat-message-item-date\">"+message["date"]+"</div>\n                </div>\n                <div class=\"anonchat-message-item-preview\">"+message["content"]["substring"](0,60)+(message["content"]["length"]>60?"...":"")+"</div>\n            ";messageItem["addEventListener"]("click",()=>{messageList["querySelectorAll"](".anonchat-message-item")["forEach"](m=>{return m["classList"]["remove"]("selected")});messageItem["classList"]["add"]("selected");messageItem["classList"]["remove"]("unread");const archiveButton=document["querySelector"](".anonchat-button:nth-child(2)");const deleteButton=document["querySelector"](".anonchat-button:nth-child(3)");if(folder==="inbox"){archiveButton["disabled"]=false;deleteButton["disabled"]=false}else{if(folder==="archive"){archiveButton["disabled"]=true;deleteButton["disabled"]=false}else{if(folder==="deleted"){archiveButton["disabled"]=false;deleteButton["disabled"]=true}}}const formattedContent=message["content"]["replace"](new RegExp("\\n","g"),"<br>");messageView["innerHTML"]="\n                    <div class=\"anonchat-message-view-header\">\n                        <div class=\"anonchat-message-view-title\">"+message["title"]+"</div>\n                        <div class=\"anonchat-message-view-date\">"+message["date"]+"</div>\n                    </div>\n                    <div class=\"anonchat-message-view-content\">\n                        "+formattedContent+"\n                    </div>\n                ";if(!message["read"]){this["markMessageAsRead"](message["id"]);message["read"]=true}});messageList["appendChild"](messageItem)})}["markMessageAsRead"](messageId){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=read_message&id="+messageId})}async["markAllAnonchatMessagesAsRead"](){try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=mark_all_anonchat_messages_as_read"});const data=await response["json"]();if(data["success"]){this["updateUnreadMessageCount"]()}}catch(error){}}["updateUnreadMessageCount"](){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_unread_message_count"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]&&data["unread_count"]!==undefined){const unreadCountElement=document["querySelector"](".event-log .unread-count");if(unreadCountElement){unreadCountElement["textContent"]=data["unread_count"]}}})}async["moveMessageToFolder"](messageId,targetFolder){try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=move_anonchat_message&id="+messageId+"&folder="+targetFolder});const data=await response["json"]();return data["success"]}catch(error){return false}}["showMiningPanel"](){const existingPanel=document["querySelector"](".mining-panel-window");if(existingPanel){if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](existingPanel,()=>{return existingPanel["remove"]()})}else{existingPanel["remove"]()}return}const miningWindow=document["createElement"]("div");miningWindow["className"]="window mining-panel-window";miningWindow["style"]["top"]="10%";miningWindow["style"]["left"]="15%";miningWindow["style"]["width"]="900px";miningWindow["style"]["height"]="600px";miningWindow["style"]["zIndex"]=getNextZIndex();const titleBar=document["createElement"]("div");titleBar["className"]="window-title";const cxBrand=document["createElement"]("div");cxBrand["className"]="window-brand";cxBrand["innerHTML"]="\n            <div class=\"window-brand-icon\">TSX</div>\n            <div class=\"window-brand-text\">"+window["langManager"]["t"]("game.crypto.title")+"</div>\n        ";titleBar["appendChild"](cxBrand);miningWindow["appendChild"](titleBar);const closeButton=document["createElement"]("button");closeButton["className"]="window-close";closeButton["textContent"]="\xD7";const miningWindowId="mining-panel-"+Date["now"]();closeButton["addEventListener"]("click",()=>{if(window["eventListenerManager"]){window["eventListenerManager"]["cleanup"](miningWindowId)}if(miningWindow["_cryptoRefreshInterval"]){clearInterval(miningWindow["_cryptoRefreshInterval"])}if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](miningWindow,()=>{return miningWindow["remove"]()})}else{miningWindow["remove"]()}});titleBar["appendChild"](closeButton);miningWindow["dataset"]["windowId"]=miningWindowId;const contentContainer=document["createElement"]("div");contentContainer["className"]="window-content mining-content";miningWindow["appendChild"](contentContainer);const tabMenu=document["createElement"]("div");tabMenu["className"]="tab-menu";contentContainer["appendChild"](tabMenu);const tabContent=document["createElement"]("div");tabContent["className"]="tab-content";contentContainer["appendChild"](tabContent);const tabs=[{["id"]:"exchange",["label"]:window["langManager"]["t"]("game.crypto.exchange_tab")},{["id"]:"mining",["label"]:window["langManager"]["t"]("game.crypto.mining_tab")}];let currentActiveTab="exchange";tabs["forEach"](tab=>{const tabButton=document["createElement"]("button");tabButton["className"]="tab-button";tabButton["dataset"]["tabId"]=tab["id"];tabButton["textContent"]=tab["label"];const tabClickHandler=async()=>{if(tab["id"]!=="mining"){selectMiningTab(tab["id"]);return}try{const resp=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_crypto_data"});const data=await resp["json"]();if(data&&data["mining"]){window["miningStatus"]=data["mining"]}}catch(e){if(this["displayEvent"]){this["displayEvent"]({["type"]:"warning",["message"]:window["langManager"]["t"]("game.crypto.mining_status_error")})}return}const status=window["miningStatus"];if(!status||status["unlocked"]!==true){if(this["displayEvent"]){this["displayEvent"]({["type"]:"warning",["message"]:window["langManager"]["t"]("game.crypto.mining_locked")})}return}selectMiningTab(tab["id"])};tabButton["addEventListener"]("click",tabClickHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](miningWindowId,tabButton,"click",tabClickHandler)}tabMenu["appendChild"](tabButton)});const selectMiningTab=tabId=>{const allButtons=tabMenu["querySelectorAll"](".tab-button");allButtons["forEach"](button=>{return button["classList"]["remove"]("active")});const selectedButton=tabMenu["querySelector"](".tab-button[data-tab-id=\""+tabId+"\"]");if(selectedButton){selectedButton["classList"]["add"]("active")}currentActiveTab=tabId;loadMiningTabContent(tabId)};const loadMiningTabContent=tabId=>{tabContent["innerHTML"]="<div class=\"loading\">Loading...</div>";if(tabId==="exchange"){this["loadExchangeTab"](tabContent)}else{if(tabId==="mining"){this["loadMiningMapTab"](tabContent)}}};document["body"]["appendChild"](miningWindow);makeDraggable(miningWindow);makeResizable(miningWindow);if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](miningWindow)}if(typeof WindowSizeManager!=="undefined"){WindowSizeManager["applyStoredSize"](miningWindow,"mining-panel-window")}selectMiningTab("exchange");this["setupCryptoAutoRefresh"](miningWindow)}["setupCryptoAutoRefresh"](miningWindow){const refreshInterval=setInterval(async()=>{if(!document["body"]["contains"](miningWindow)){clearInterval(refreshInterval);return}const activeTab=miningWindow["querySelector"](".tab-button.active");if(activeTab&&activeTab["dataset"]["tabId"]==="exchange"){const tabContent=miningWindow["querySelector"](".tab-content");if(tabContent){await this["loadExchangeTab"](tabContent)}}},30000)}async["loadExchangeTab"](container){try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_crypto_data"});const data=await response["json"]();if(!data["success"]){container["innerHTML"]="<div class=\"error\">"+window["langManager"]["t"]("game.crypto.error_loading_exchange")+"</div>";return}const{["wallet"]:wallet,["current_price"]:current_price,["price_history"]:price_history,["transactions"]:transactions}=data;container["innerHTML"]="\n                <div class=\"exchange-container-compact\">\n                    <!-- Top Status Bar -->\n                    <div class=\"crypto-status-bar\">\n                        <div class=\"status-item\">\n                            <div class=\"status-label\">"+window["langManager"]["t"]("game.crypto.wallet_balance")+"</div>\n                            <div class=\"status-value balance-glow\">"+parseFloat(wallet["tsx_balance"])["toFixed"](4)+" TSX</div>\n                        </div>\n                        <div class=\"status-item\">\n                            <div class=\"status-label\">"+window["langManager"]["t"]("game.crypto.current_price")+"</div>\n                            <div class=\"status-value\">"+parseFloat(current_price["price"])["toFixed"](3)+" Credits</div>\n                        </div>\n                        <div class=\"status-item "+(current_price["change_percent"]>=0?"positive":"negative")+"\">\n                            <div class=\"status-label\">"+window["langManager"]["t"]("game.crypto.change_24h")+"</div>\n                            <div class=\"status-value\">"+(current_price["change_percent"]>=0?"+":"")+current_price["change_percent"]["toFixed"](2)+"%</div>\n                        </div>\n                        <div class=\"status-item\">\n                            <div class=\"status-label\">"+window["langManager"]["t"]("game.crypto.volume_label")+"</div>\n                            <div class=\"status-value\">"+parseFloat(current_price["volume"])["toFixed"](2)+"</div>\n                        </div>\n                    </div>\n\n                    <!-- Unified Trading Panel -->\n                    <div class=\"trading-panel-unified\">\n                        <div class=\"trading-header\">\n                            <h3>"+window["langManager"]["t"]("game.crypto.buy_sell_tsx")+"</h3>\n                        </div>\n                        <div class=\"trading-controls\">\n                            <div class=\"trade-type-selector\">\n                                <button id=\"buy-mode-btn\" class=\"mode-button active\">"+window["langManager"]["t"]("game.crypto.buy_tsx")+"</button>\n                                <button id=\"sell-mode-btn\" class=\"mode-button\">"+window["langManager"]["t"]("game.crypto.sell_tsx")+"</button>\n                            </div>\n                            <div class=\"trade-input-section\">\n                                <div class=\"input-group\" id=\"buy-input-group\">\n                                    <label>"+window["langManager"]["t"]("game.crypto.credits_to_spend")+"</label>\n                                    <input type=\"number\" id=\"buy-credits-input\" min=\"1\" step=\"1\" placeholder=\"100\">\n                                    <div class=\"conversion-preview\" id=\"buy-preview\">\u2248 0.0000 TSX</div>\n                                </div>\n                                <div class=\"input-group\" id=\"sell-input-group\" style=\"display: none;\">\n                                    <label>"+window["langManager"]["t"]("game.crypto.tsx_to_sell")+"</label>\n                                    <input type=\"number\" id=\"sell-tsx-input\" min=\"0.0001\" step=\"0.0001\" placeholder=\"10.0000\">\n                                    <div class=\"conversion-preview\" id=\"sell-preview\">\u2248 0 Credits</div>\n                                </div>\n                            </div>\n                            <button id=\"execute-trade-btn\" class=\"trade-button-unified buy\">"+window["langManager"]["t"]("game.crypto.execute_buy")+"</button>\n                        </div>\n                    </div>\n\n                    <!-- Price Chart -->\n                    <div class=\"chart-section-compact\">\n                        <div class=\"section-header\">\n                            <h3>"+window["langManager"]["t"]("game.crypto.price_chart")+"</h3>\n                        </div>\n                        <div class=\"chart-container\">\n                            <canvas id=\"tsx-price-chart\" width=\"500\" height=\"180\"></canvas>\n                        </div>\n                    </div>\n\n                    <!-- Transaction History -->\n                    <div class=\"history-section-compact\">\n                        <div class=\"section-header\">\n                            <h3>"+window["langManager"]["t"]("game.crypto.transaction_history")+"</h3>\n                        </div>\n                        <div class=\"transaction-list-compact\">\n                            "+transactions["map"](tx=>{return"\n                                <div class=\"transaction-item-compact "+tx["type"]+"\">\n                                    <div class=\"transaction-info\">\n                                        <span class=\"transaction-type\">"+window["langManager"]["t"]("game.crypto.transaction_"+tx["type"])+"</span>\n                                        <span class=\"transaction-date\">"+tx["game_year"]+"/"+tx["game_month"]+"/"+tx["game_day"]+"</span>\n                                    </div>\n                                    <div class=\"transaction-amounts\">\n                                        <span class=\"transaction-amount\">"+parseFloat(tx["amount"])["toFixed"](4)+" TSX</span>\n                                        <span class=\"transaction-price\">"+parseFloat(tx["tsx_price"])["toFixed"](3)+" Credits</span>\n                                    </div>\n                                </div>\n                            "})["join"]("")+"\n                        </div>\n                    </div>\n                </div>\n            ";this["drawPriceChart"](price_history);this["setupCompactTradingEventListeners"](current_price["price"])}catch(error){container["innerHTML"]="<div class=\"error\">"+window["langManager"]["t"]("game.crypto.error_loading_exchange")+"</div>"}}async["loadMiningMapTab"](container){try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_crypto_data"});const data=await response["json"]();if(!data["success"]){container["innerHTML"]="<div class=\"error\">"+window["langManager"]["t"]("game.crypto.error_loading_mining")+"</div>";return}const{["wallet"]:wallet,["active_pcs"]:active_pcs}=data;const activePcCount=active_pcs["filter"](pc=>{return pc["status"]==="active"})["length"];const baseScanCost=10;const scanCost=baseScanCost+activePcCount*2;container["innerHTML"]="\n                <div class=\"mining-container-network\">\n                    <!-- Mining Controls Panel -->\n                    <div class=\"mining-controls-panel\">\n                        <div class=\"control-stats\">\n                            <div class=\"stat-box\">\n                                <div class=\"stat-label\">"+window["langManager"]["t"]("game.crypto.tsx_balance_label")+"</div>\n                                <div class=\"stat-value\">"+parseFloat(wallet["tsx_balance"])["toFixed"](4)+" TSX</div>\n                            </div>\n                            <div class=\"stat-box\">\n                                <div class=\"stat-label\">"+window["langManager"]["t"]("game.crypto.active_pcs_label")+"</div>\n                                <div class=\"stat-value\">"+active_pcs["filter"](pc=>{return pc["status"]==="active"})["length"]+"/\u221E</div>\n                            </div>\n                            <div class=\"stat-box\">\n                                <div class=\"stat-label\">"+window["langManager"]["t"]("game.crypto.daily_income_label")+"</div>\n                                <div class=\"stat-value\">+"+active_pcs["filter"](pc=>{return pc["status"]==="active"})["reduce"]((sum,pc)=>{return sum+parseFloat(pc["daily_tsx_rate"])},0)["toFixed"](4)+" TSX</div>\n                            </div>\n                        </div>\n                        <button id=\"network-scan-btn\" class=\"network-scan-button\" "+(wallet["tsx_balance"]<scanCost?"disabled":"")+">\n                            <span class=\"scan-text\">"+window["langManager"]["t"]("game.crypto.scan_network")+"</span>\n                            <span class=\"scan-cost\">"+window["langManager"]["t"]("game.crypto.cost_label",{["cost"]:scanCost["toFixed"](1)})+"</span>\n                            <div class=\"scan-progress-fill\"></div>\n                        </button>\n                    </div>\n\n                    <!-- Network Map -->\n                    <div class=\"network-map-container\">\n                        <div class=\"pc-grid-container\" id=\"pc-grid\">\n                            "+this["generatePCGrid"](active_pcs)+"\n                        </div>\n                    </div>\n\n                    <!-- PC Details Popup -->\n                    <div class=\"pc-popup-overlay\" id=\"pc-popup-overlay\" style=\"display: none;\">\n                        <div class=\"pc-popup\" id=\"pc-popup\">\n                            <div class=\"pc-popup-header\">\n                                <h3 id=\"pc-popup-title\">"+window["langManager"]["t"]("game.crypto.pc_details_title")+"</h3>\n                                <button class=\"pc-popup-close\" id=\"pc-popup-close\">\xD7</button>\n                            </div>\n                            <div class=\"pc-popup-content\" id=\"pc-popup-content\">\n                                <!-- Content will be populated dynamically -->\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            ";this["setupMiningEventListeners"]();const cooldown=this["getScanCooldown"]();const scanInProgress=window["scanInProgress"];if(cooldown["isActive"]||scanInProgress){this["startScanCooldownTimer"]()}this["updateScanButtonState"]()}catch(error){container["innerHTML"]="<div class=\"error\">"+window["langManager"]["t"]("game.crypto.error_loading_mining")+"</div>"}}["generatePCGrid"](activePCs){const maxSlots=50;let gridHtml="";for(let i=0;i<maxSlots;i++){const pc=activePCs["find"](pc=>{return parseInt(pc["grid_position"])===i})||null;const row=Math["floor"](i/10);const col=i%10;if(pc){gridHtml+="\n                    <div class=\"pc-card "+pc["status"]+"\" data-pc-id=\""+pc["id"]+"\" data-grid-pos=\""+i+"\">\n                        <div class=\"pc-icon\">\n                            "+(pc["status"]==="discovered"?"\uD83D\uDCBB":pc["status"]==="installing"?"\u2699\uFE0F":"\uD83D\uDDA5\uFE0F")+"\n                        </div>\n                        <div class=\"pc-name\">"+pc["pc_name"]+"</div>\n                        "+(pc["status"]==="installing"?"<div class=\"pc-progress-indicator\"></div>":"")+"\n                    </div>\n                "}else{gridHtml+="\n                    <div class=\"pc-card empty\" data-grid-pos=\""+i+"\">\n                        <div class=\"pc-icon\">\u2B1C</div>\n                        <div class=\"pc-name\">"+window["langManager"]["t"]("game.crypto.empty_slot")+"</div>\n                    </div>\n                "}}return gridHtml}["setupCompactTradingEventListeners"](currentPrice){const buyModeBtn=document["getElementById"]("buy-mode-btn");const sellModeBtn=document["getElementById"]("sell-mode-btn");const executeTradeBtn=document["getElementById"]("execute-trade-btn");const buyInputGroup=document["getElementById"]("buy-input-group");const sellInputGroup=document["getElementById"]("sell-input-group");const buyCreditsInput=document["getElementById"]("buy-credits-input");const sellTsxInput=document["getElementById"]("sell-tsx-input");const buyPreview=document["getElementById"]("buy-preview");const sellPreview=document["getElementById"]("sell-preview");let currentMode="buy";buyModeBtn["addEventListener"]("click",()=>{currentMode="buy";buyModeBtn["classList"]["add"]("active");sellModeBtn["classList"]["remove"]("active");buyInputGroup["style"]["display"]="block";sellInputGroup["style"]["display"]="none";executeTradeBtn["textContent"]=window["langManager"]["t"]("game.crypto.execute_buy");executeTradeBtn["className"]="trade-button-unified buy"});sellModeBtn["addEventListener"]("click",()=>{currentMode="sell";sellModeBtn["classList"]["add"]("active");buyModeBtn["classList"]["remove"]("active");buyInputGroup["style"]["display"]="none";sellInputGroup["style"]["display"]="block";executeTradeBtn["textContent"]=window["langManager"]["t"]("game.crypto.execute_sell");executeTradeBtn["className"]="trade-button-unified sell"});buyCreditsInput["addEventListener"]("input",()=>{const credits=parseFloat(buyCreditsInput["value"])||0;const tsxAmount=credits/currentPrice;buyPreview["textContent"]="\u2248 "+tsxAmount["toFixed"](4)+" TSX"});sellTsxInput["addEventListener"]("input",()=>{const tsx=parseFloat(sellTsxInput["value"])||0;const creditsAmount=tsx*currentPrice;sellPreview["textContent"]="\u2248 "+Math["floor"](creditsAmount)+" Credits"});executeTradeBtn["addEventListener"]("click",()=>{if(currentMode==="buy"){const creditAmount=parseFloat(buyCreditsInput["value"]);if(creditAmount&&creditAmount>0){this["executeTrade"]("buy",creditAmount);buyCreditsInput["value"]="";buyPreview["textContent"]="\u2248 0.0000 TSX"}}else{const tsxAmount=parseFloat(sellTsxInput["value"]);if(tsxAmount&&tsxAmount>0){this["executeTrade"]("sell",tsxAmount);sellTsxInput["value"]="";sellPreview["textContent"]="\u2248 0 Credits"}}});buyCreditsInput["addEventListener"]("keypress",e=>{if(e["key"]==="Enter"&&currentMode==="buy"){executeTradeBtn["click"]()}});sellTsxInput["addEventListener"]("keypress",e=>{if(e["key"]==="Enter"&&currentMode==="sell"){executeTradeBtn["click"]()}})}["setupTradingEventListeners"](){const buyBtn=document["getElementById"]("buy-tsx-btn");const sellBtn=document["getElementById"]("sell-tsx-btn");const buyInput=document["getElementById"]("buy-credits-input");const sellInput=document["getElementById"]("sell-tsx-input");if(buyBtn&&buyInput){buyBtn["addEventListener"]("click",async()=>{const creditAmount=parseFloat(buyInput["value"]);if(!creditAmount||creditAmount<=0){alert(window["langManager"]["t"]("game.crypto.enter_valid_credit"));return}await this["executeTrade"]("buy",creditAmount);buyInput["value"]=""})}if(sellBtn&&sellInput){sellBtn["addEventListener"]("click",async()=>{const tsxAmount=parseFloat(sellInput["value"]);if(!tsxAmount||tsxAmount<=0){alert(window["langManager"]["t"]("game.crypto.enter_valid_tsx"));return}await this["executeTrade"]("sell",tsxAmount);sellInput["value"]=""})}}["setupMiningEventListeners"](){const networkScanBtn=document["getElementById"]("network-scan-btn");if(networkScanBtn){networkScanBtn["replaceWith"](networkScanBtn["cloneNode"](true));const newScanBtn=document["getElementById"]("network-scan-btn");newScanBtn["addEventListener"]("click",async()=>{await this["executeNetworkScan"]()})}const pcCards=document["querySelectorAll"](".pc-card:not(.empty)");pcCards["forEach"](card=>{card["addEventListener"]("click",()=>{const pcId=card["dataset"]["pcId"];if(pcId){this["showPCPopup"](pcId)}})});const popupOverlay=document["getElementById"]("pc-popup-overlay");const popupClose=document["getElementById"]("pc-popup-close");if(popupOverlay){popupOverlay["addEventListener"]("click",e=>{if(e["target"]===popupOverlay){this["closePCPopup"]()}})}if(popupClose){popupClose["addEventListener"]("click",()=>{this["closePCPopup"]()})}}["showPCPopup"](pcId){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_crypto_data"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){const pc=data["active_pcs"]["find"](p=>{return p["id"]==pcId});if(pc){this["displayPCPopup"](pc)}}})["catch"](error=>{})}["displayPCPopup"](pc){const popup=document["getElementById"]("pc-popup");const popupTitle=document["getElementById"]("pc-popup-title");const popupContent=document["getElementById"]("pc-popup-content");const popupOverlay=document["getElementById"]("pc-popup-overlay");if(!popup||!popupTitle||!popupContent||!popupOverlay){return}popupTitle["textContent"]=""+pc["pc_name"]+" ("+pc["ip_address"]+")";let contentHtml="\n            <div class=\"pc-details\">\n                <div class=\"pc-detail-item\">\n                    <span class=\"detail-label\">"+window["langManager"]["t"]("game.crypto.power_level_label")+"</span>\n                    <span class=\"detail-value\">\u26A1"+parseFloat(pc["power_level"])["toFixed"](2)+"</span>\n                </div>\n                <div class=\"pc-detail-item\">\n                    <span class=\"detail-label\">"+window["langManager"]["t"]("game.crypto.daily_rate_label")+"</span>\n                    <span class=\"detail-value\">+"+parseFloat(pc["daily_tsx_rate"])["toFixed"](4)+" TSX/day</span>\n                </div>\n                <div class=\"pc-detail-item\">\n                    <span class=\"detail-label\">"+window["langManager"]["t"]("game.crypto.status_label")+"</span>\n                    <span class=\"detail-value status-"+pc["status"]+"\">"+pc["status"]["toUpperCase"]()+"</span>\n                </div>\n            </div>\n        ";if(pc["status"]==="discovered"){contentHtml+="\n                <div class=\"pc-actions\">\n                    <button class=\"install-button\" onclick=\"window.game.installMiningSoftwareFromPopup("+pc["id"]+")\">\n                        "+window["langManager"]["t"]("game.crypto.install_mining_software")+"\n                    </button>\n                </div>\n            "}else{if(pc["status"]==="installing"){const installProgress=this["getInstallationProgress"](pc["id"]);contentHtml+="\n                <div class=\"pc-installation\">\n                    <div class=\"installation-status\">"+window["langManager"]["t"]("game.crypto.installing_software")+"</div>\n                    <div class=\"installation-progress-bar\">\n                        <div class=\"installation-progress-fill\" id=\"popup-progress-fill-"+pc["id"]+"\" style=\"width: "+installProgress["progress"]+"%\"></div>\n                    </div>\n                    <div class=\"installation-time\" id=\"popup-progress-time-"+pc["id"]+"\">"+window["langManager"]["t"]("game.crypto.seconds_remaining",{["seconds"]:installProgress["timeRemaining"]})+"</div>\n                </div>\n            ";this["startPopupProgressUpdates"](pc["id"])}else{if(pc["status"]==="active"){contentHtml+="\n                <div class=\"pc-mining-info\">\n                    <div class=\"mining-status\">\u2705 "+window["langManager"]["t"]("game.crypto.mining_active")+"</div>\n                    <div class=\"mining-income\">"+window["langManager"]["t"]("game.crypto.generating_daily",{["rate"]:parseFloat(pc["daily_tsx_rate"])["toFixed"](4)})+"</div>\n                </div>\n            "}}}popupContent["innerHTML"]=contentHtml;popupOverlay["style"]["display"]="flex"}["startPopupProgressUpdates"](pcId){if(window["popupProgressIntervals"]&&window["popupProgressIntervals"][pcId]){clearInterval(window["popupProgressIntervals"][pcId])}if(!window["popupProgressIntervals"]){window["popupProgressIntervals"]={}}window["popupProgressIntervals"][pcId]=setInterval(()=>{const progressFill=document["getElementById"]("popup-progress-fill-"+pcId);const progressTime=document["getElementById"]("popup-progress-time-"+pcId);if(progressFill&&progressTime){const progress=this["getInstallationProgress"](pcId);progressFill["style"]["width"]=""+progress["progress"]+"%";progressTime["textContent"]=window["langManager"]["t"]("game.crypto.seconds_remaining",{["seconds"]:progress["timeRemaining"]});if(progress["timeRemaining"]<=0){clearInterval(window["popupProgressIntervals"][pcId]);delete window["popupProgressIntervals"][pcId]}}else{clearInterval(window["popupProgressIntervals"][pcId]);delete window["popupProgressIntervals"][pcId]}},1000)}["closePCPopup"](){const popupOverlay=document["getElementById"]("pc-popup-overlay");if(popupOverlay){popupOverlay["style"]["display"]="none"}if(window["popupProgressIntervals"]){Object["keys"](window["popupProgressIntervals"])["forEach"](pcId=>{clearInterval(window["popupProgressIntervals"][pcId])});window["popupProgressIntervals"]={}}}async["installMiningSoftwareFromPopup"](pcId){this["closePCPopup"]();let installDuration=Math["random"]()*75000+45000;const installMult=window["miningStatus"]&&window["miningStatus"]["install_time_multiplier"]?window["miningStatus"]["install_time_multiplier"]:1;installDuration=Math["max"](5000,installDuration*installMult);const installDurationSeconds=Math["floor"](installDuration/1000);this["setInstallationProgress"](pcId,{["startTime"]:Date["now"](),["duration"]:installDuration,["progress"]:0,["timeRemaining"]:installDurationSeconds});try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=install_mining_software&pc_id="+pcId});const data=await response["json"]();if(data["success"]){this["displayEvent"]({["type"]:"info",["message"]:window["langManager"]["t"]("game.crypto.installation_started",{["name"]:data["pc_name"],["seconds"]:installDurationSeconds})});this["trackInstallationProgress"](pcId,installDuration);const miningTabContent=document["querySelector"](".mining-panel-window .tab-content");if(miningTabContent){this["loadMiningMapTab"](miningTabContent)}}else{this["displayEvent"]({["type"]:"danger",["message"]:data["message"]||window["langManager"]["t"]("game.crypto.installation_failed")})}}catch(error){this["displayEvent"]({["type"]:"danger",["message"]:window["langManager"]["t"]("game.crypto.network_error_installation")})}}["setInstallationProgress"](pcId,progressData){if(!window["installationProgress"]){window["installationProgress"]={}}window["installationProgress"][pcId]=progressData}["getInstallationProgress"](pcId){if(!window["installationProgress"]||!window["installationProgress"][pcId]){return{["progress"]:0,["timeRemaining"]:0}}const installData=window["installationProgress"][pcId];const elapsed=Date["now"]()-installData["startTime"];const progress=Math["min"](100,elapsed/installData["duration"]*100);const timeRemaining=Math["max"](0,Math["floor"]((installData["duration"]-elapsed)/1000));return{["progress"]:progress,["timeRemaining"]:timeRemaining}}["trackInstallationProgress"](pcId,duration){const interval=setInterval(()=>{const progress=this["getInstallationProgress"](pcId);if(progress["timeRemaining"]<=0){clearInterval(interval);this["completeInstallation"](pcId)}},1000)}async["completeInstallation"](pcId){try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=complete_installation&pc_id="+pcId});const data=await response["json"]();if(data["success"]){if(window["installationProgress"]){delete window["installationProgress"][pcId]}this["displayEvent"]({["type"]:"success",["message"]:window["langManager"]["t"]("game.crypto.install_success")});const miningTabContent=document["querySelector"](".mining-panel-window .tab-content");if(miningTabContent){this["loadMiningMapTab"](miningTabContent)}}}catch(error){}}async["executeNetworkScan"](){const scanBtn=document["getElementById"]("network-scan-btn");if(!scanBtn||scanBtn["disabled"]){return}if(window["scanInProgress"]){this["displayEvent"]({["type"]:"warning",["message"]:window["langManager"]["t"]("game.crypto.scan_in_progress")});return}const cooldownData=this["getScanCooldown"]();if(cooldownData["remaining"]>0){const remainingMinutes=Math["ceil"](cooldownData["remaining"]/60000);this["displayEvent"]({["type"]:"warning",["message"]:window["langManager"]["t"]("game.crypto.scan_cooldown",{["minutes"]:remainingMinutes})});return}window["scanInProgress"]=true;scanBtn["disabled"]=true;scanBtn["classList"]["add"]("scanning");const progressFill=scanBtn["querySelector"](".scan-progress-fill");const scanText=scanBtn["querySelector"](".scan-text");const originalText=scanText["textContent"];scanText["textContent"]=window["langManager"]["t"]("game.crypto.scanning_text");const scanDuration=Math["random"]()*10000+5000;window["scanEndTime"]=Date["now"]()+scanDuration;progressFill["style"]["width"]="0%";progressFill["style"]["transition"]="width "+scanDuration+"ms linear";setTimeout(()=>{progressFill["style"]["width"]="100%"},100);try{await new Promise(resolve=>{return setTimeout(resolve,scanDuration)});const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=scan_mining_pcs"});const data=await response["json"]();if(data["success"]){this["displayEvent"]({["type"]:"info",["message"]:window["langManager"]["t"]("game.crypto.scan_completed",{["count"]:data["pcs_found"],["cost"]:data["scan_cost"]})});const cooldownDuration=Math["random"]()*240000+120000;this["setScanCooldown"](cooldownDuration);const miningTabContent=document["querySelector"](".mining-panel-window .tab-content");if(miningTabContent){this["loadMiningMapTab"](miningTabContent)}}else{this["displayEvent"]({["type"]:"danger",["message"]:data["message"]||window["langManager"]["t"]("game.crypto.scan_failed")})}}catch(error){this["displayEvent"]({["type"]:"danger",["message"]:window["langManager"]["t"]("game.crypto.network_error_scan")})}finally{window["scanInProgress"]=false;window["scanEndTime"]=null;scanBtn["classList"]["remove"]("scanning");progressFill["style"]["width"]="0%";progressFill["style"]["transition"]="none";this["updateScanButtonState"]()}}["setScanCooldown"](duration){const cooldownEnd=Date["now"]()+duration;localStorage["setItem"]("scanCooldownEnd",cooldownEnd["toString"]());this["startScanCooldownTimer"]()}["getScanCooldown"](){const cooldownEnd=localStorage["getItem"]("scanCooldownEnd");if(!cooldownEnd){return{["remaining"]:0,["isActive"]:false}}const remaining=parseInt(cooldownEnd)-Date["now"]();const isActive=remaining>0;if(isActive&&remaining>3600000){}return{["remaining"]:Math["max"](0,remaining),["isActive"]:isActive}}["startScanCooldownTimer"](){if(window["scanCooldownTimer"]){clearInterval(window["scanCooldownTimer"])}window["scanCooldownTimer"]=setInterval(()=>{this["updateScanButtonState"]();const cooldown=this["getScanCooldown"]();const scanInProgress=window["scanInProgress"];if(!cooldown["isActive"]&&!scanInProgress){clearInterval(window["scanCooldownTimer"]);window["scanCooldownTimer"]=null}},1000)}["updateScanButtonState"](){const scanBtn=document["getElementById"]("network-scan-btn");if(!scanBtn){return}if(window["scanInProgress"]){scanBtn["disabled"]=true;scanBtn["classList"]["add"]("scanning");const remaining=window["scanEndTime"]?Math["max"](0,window["scanEndTime"]-Date["now"]()):0;const remainingSeconds=Math["ceil"](remaining/1000);scanBtn["innerHTML"]="\n                <span class=\"scan-text\">"+window["langManager"]["t"]("game.crypto.scanning_text")+" "+remainingSeconds+"s</span>\n                <div class=\"scan-progress-fill\" style=\"width: "+(remaining>0?Math["max"](10,100-remaining/15000*100):100)+"%\"></div>\n            ";return}const cooldown=this["getScanCooldown"]();if(cooldown["isActive"]){scanBtn["disabled"]=true;scanBtn["classList"]["remove"]("scanning");const minutes=Math["floor"](cooldown["remaining"]/60000);const seconds=Math["floor"](cooldown["remaining"]%60000/1000);const timeText=minutes>0?""+minutes+"m "+seconds+"s":""+seconds+"s";scanBtn["innerHTML"]="\n                <span class=\"scan-text\">"+window["langManager"]["t"]("game.crypto.cooldown_text",{["time"]:timeText})+"</span>\n                <div class=\"scan-progress-fill\"></div>\n            "}else{scanBtn["disabled"]=false;scanBtn["classList"]["remove"]("scanning");const currentCost=this["getScanCost"]();scanBtn["innerHTML"]="\n                <span class=\"scan-text\">"+window["langManager"]["t"]("game.crypto.scan_network")+"</span>\n                <span class=\"scan-cost\">"+window["langManager"]["t"]("game.crypto.cost_label",{["cost"]:currentCost["toFixed"](1)})+"</span>\n                <div class=\"scan-progress-fill\"></div>\n            "}}["getScanCost"](){const activePcElements=document["querySelectorAll"](".pc-card.active");const currentPcCount=activePcElements["length"];const baseScanCost=10;const multiplier=window["miningStatus"]&&window["miningStatus"]["scan_cost_multiplier"]?window["miningStatus"]["scan_cost_multiplier"]:1;return(baseScanCost+currentPcCount*2)*multiplier}async["installMiningsoftware"](pcId){if(!pcId){return}const installationPanel=document["getElementById"]("installation-panel");const installationPcInfo=document["getElementById"]("installation-pc-info");const installationProgressFill=document["getElementById"]("installation-progress-fill");const installationTime=document["getElementById"]("installation-time");if(!installationPanel){return}const pcNode=document["querySelector"]("[data-pc-id=\""+pcId+"\"]");if(!pcNode){return}const pcName=pcNode["querySelector"](".pc-name")["textContent"];const pcPower=pcNode["querySelector"](".pc-power")["textContent"];let installDuration=Math["random"]()*75000+45000;const installMult=window["miningStatus"]&&window["miningStatus"]["install_time_multiplier"]?window["miningStatus"]["install_time_multiplier"]:1;installDuration=Math["max"](5000,installDuration*installMult);const installDurationSeconds=Math["floor"](installDuration/1000);installationPanel["style"]["display"]="block";installationPcInfo["innerHTML"]="\n            <div class=\"pc-install-name\">"+pcName+"</div>\n            <div class=\"pc-install-power\">"+pcPower+"</div>\n        ";installationProgressFill["style"]["width"]="0%";installationProgressFill["style"]["transition"]="width "+installDuration+"ms linear";installationTime["textContent"]=window["langManager"]["t"]("game.crypto.seconds_remaining",{["seconds"]:installDurationSeconds});pcNode["classList"]["remove"]("discovered");pcNode["classList"]["add"]("installing");pcNode["querySelector"](".pc-node-icon")["textContent"]="\u2699\uFE0F";const installIndicator=pcNode["querySelector"](".install-indicator");if(installIndicator){installIndicator["remove"]()}try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=install_mining_software&pc_id="+pcId});const data=await response["json"]();if(data["success"]){setTimeout(()=>{installationProgressFill["style"]["width"]="100%"},100);const startTime=Date["now"]();const timeInterval=setInterval(()=>{const elapsed=Date["now"]()-startTime;const remaining=Math["max"](0,installDurationSeconds-Math["floor"](elapsed/1000));installationTime["textContent"]=window["langManager"]["t"]("game.crypto.seconds_remaining",{["seconds"]:remaining});if(remaining<=0){clearInterval(timeInterval)}},1000);await new Promise(resolve=>{return setTimeout(resolve,installDuration)});const completeResponse=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=complete_installation&pc_id="+pcId});const completeData=await completeResponse["json"]();installationPanel["style"]["display"]="none";if(completeData["success"]){this["displayEvent"]({["type"]:"success",["message"]:window["langManager"]["t"]("game.crypto.install_success_pc",{["name"]:pcName})})}else{this["displayEvent"]({["type"]:"warning",["message"]:window["langManager"]["t"]("game.crypto.install_status_failed",{["message"]:completeData["message"]})})}const miningTabContent=document["querySelector"](".mining-panel-window .tab-content");if(miningTabContent){this["loadMiningMapTab"](miningTabContent)}}else{installationPanel["style"]["display"]="none";pcNode["classList"]["remove"]("installing");pcNode["classList"]["add"]("discovered");pcNode["querySelector"](".pc-node-icon")["textContent"]="\uD83D\uDCBB";this["displayEvent"]({["type"]:"danger",["message"]:data["message"]||window["langManager"]["t"]("game.crypto.installation_failed")})}}catch(error){installationPanel["style"]["display"]="none";pcNode["classList"]["remove"]("installing");pcNode["classList"]["add"]("discovered");pcNode["querySelector"](".pc-node-icon")["textContent"]="\uD83D\uDCBB";this["displayEvent"]({["type"]:"danger",["message"]:window["langManager"]["t"]("game.crypto.network_error_installation")})}}["startScanAnimation"](){const scanAnimation=document["getElementById"]("scan-animation");const scanWave=document["getElementById"]("scan-wave");if(scanAnimation){scanAnimation["style"]["display"]="block"}if(scanWave){scanWave["classList"]["add"]("active");setTimeout(()=>{scanWave["classList"]["remove"]("active");setTimeout(()=>{return scanWave["classList"]["add"]("active")},100)},2000);setTimeout(()=>{scanWave["classList"]["remove"]("active");setTimeout(()=>{return scanWave["classList"]["add"]("active")},100)},4000)}}["stopScanAnimation"](){const scanAnimation=document["getElementById"]("scan-animation");const scanWave=document["getElementById"]("scan-wave");if(scanAnimation){scanAnimation["style"]["display"]="none"}if(scanWave){scanWave["classList"]["remove"]("active")}}async["executeTrade"](type,amount){try{const action=type==="buy"?"buy_tsx":"sell_tsx";const paramName=type==="buy"?"credit_amount":"tsx_amount";const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action="+action+"&"+paramName+"="+amount});const data=await response["json"]();if(data["success"]){if(typeof showFloatingText==="function"){const message=type==="buy"?window["langManager"]["t"]("game.crypto.buy_success",{["tsx"]:amount["toFixed"](4),["credits"]:Math["floor"](data["credit_amount"])}):window["langManager"]["t"]("game.crypto.sell_success",{["tsx"]:amount["toFixed"](4),["credits"]:Math["floor"](data["credit_amount"])});showFloatingText(message,"success")}else{alert(data["message"])}const exchangeTabContent=document["querySelector"](".mining-panel-window .tab-content");if(exchangeTabContent){this["loadExchangeTab"](exchangeTabContent)}}else{if(typeof showFloatingText==="function"){const errorMessage=type==="buy"?window["langManager"]["t"]("game.crypto.buy_error"):window["langManager"]["t"]("game.crypto.sell_error");showFloatingText(errorMessage,"error")}else{alert(data["message"]||"Trade failed")}}}catch(error){alert(window["langManager"]["t"]("game.crypto.error_trade"))}}["drawPriceChart"](priceHistory){const canvas=document["getElementById"]("tsx-price-chart");if(!canvas||!priceHistory||priceHistory["length"]===0){return}const ctx=canvas["getContext"]("2d");const width=canvas["width"];const height=canvas["height"];ctx["clearRect"](0,0,width,height);const prices=priceHistory["map"](p=>{return parseFloat(p["price"])});const minPrice=Math["min"](...prices);const maxPrice=Math["max"](...prices);const priceRange=maxPrice-minPrice||1;ctx["fillStyle"]="rgba(0, 20, 40, 0.3)";ctx["fillRect"](0,0,width,height);ctx["strokeStyle"]="#00ff96";ctx["lineWidth"]=2;ctx["beginPath"]();priceHistory["forEach"]((point,index)=>{const x=index/(priceHistory["length"]-1)*width;const y=height-(parseFloat(point["price"])-minPrice)/priceRange*height;if(index===0){ctx["moveTo"](x,y)}else{ctx["lineTo"](x,y)}});ctx["stroke"]();ctx["fillStyle"]="#00ff96";ctx["font"]="12px monospace";ctx["fillText"](""+maxPrice["toFixed"](2),5,15);ctx["fillText"](""+minPrice["toFixed"](2),5,height-5)}["initTaskbar"](){this["setupTaskbarEventListeners"]();this["startTaskbarClock"]();this["updateTaskbarState"]();this["setupWindowStateMonitoring"]()}["setupTaskbarEventListeners"](){const taskbarApps=document["querySelectorAll"](".taskbar-app");taskbarApps["forEach"](app=>{app["addEventListener"]("click",e=>{e["preventDefault"]();e["stopPropagation"]();const command=app["getAttribute"]("data-command");if(command){const existingWindow=this["isWindowOpen"](command);if(existingWindow){if(this["isWindowFocused"](existingWindow)){this["closeWindow"](existingWindow)}else{this["bringWindowToFront"](existingWindow)}}else{this["executeCommandSilently"](command)}setTimeout(()=>{this["updateTaskbarState"]()},100)}});app["addEventListener"]("click",()=>{if(window["soundManager"]){window["soundManager"]["playClick"]()}})})}["closeWindow"](windowElement){if(!windowElement){return}const closeBtn=windowElement["querySelector"](".close-btn, .window-close, [data-action=\"close\"]");if(closeBtn){closeBtn["click"]()}else{windowElement["classList"]["add"]("hidden")}setTimeout(()=>{this["updateTaskbarState"]()},100)}["showFileSystem"](){const existingWindow=document["querySelector"](".file-system-window");if(existingWindow){if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](existingWindow,()=>{return existingWindow["remove"]()})}else{existingWindow["remove"]()}return}const fileWindow=document["createElement"]("div");fileWindow["className"]="window file-system-window";fileWindow["style"]["top"]="10%";fileWindow["style"]["left"]="20%";fileWindow["style"]["width"]="700px";fileWindow["style"]["height"]="550px";fileWindow["style"]["zIndex"]=getNextZIndex();const titleBar=document["createElement"]("div");titleBar["className"]="window-title";const brand=document["createElement"]("div");brand["className"]="window-brand";brand["innerHTML"]="\n            <div class=\"window-brand-icon\">\uD83D\uDCC1</div>\n            <div class=\"window-brand-text\">"+window["langManager"]["t"]("game.files.title","File System")+"</div>\n        ";titleBar["appendChild"](brand);fileWindow["appendChild"](titleBar);const closeButton=document["createElement"]("div");closeButton["className"]="window-close";closeButton["textContent"]="\xD7";closeButton["addEventListener"]("click",()=>{if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](fileWindow,()=>{return fileWindow["remove"]()})}else{fileWindow["remove"]()}});titleBar["appendChild"](closeButton);const contentContainer=document["createElement"]("div");contentContainer["className"]="window-content file-system-content";fileWindow["appendChild"](contentContainer);const header=document["createElement"]("div");header["className"]="file-system-header";header["innerHTML"]="\n            <div class=\"file-stats\">\n                <span class=\"file-count\">0 "+window["langManager"]["t"]("game.files.files","files")+"</span>\n            </div>\n            <button id=\"refresh-files-btn\" class=\"btn-refresh\">\u21BB</button>\n        ";contentContainer["appendChild"](header);const mainArea=document["createElement"]("div");mainArea["className"]="file-system-main";mainArea["style"]["display"]="flex";mainArea["style"]["gap"]="12px";mainArea["style"]["height"]="calc(100% - 56px)";mainArea["style"]["marginTop"]="8px";const fileList=document["createElement"]("div");fileList["className"]="file-list";fileList["innerHTML"]="<div class=\"loading\">Loading files...</div>";fileList["style"]["flex"]="1 1 45%";fileList["style"]["overflow"]="auto";fileList["style"]["maxHeight"]="100%";fileList["style"]["paddingRight"]="6px";const fileViewer=document["createElement"]("div");fileViewer["className"]="file-viewer";fileViewer["style"]["display"]="none";fileViewer["style"]["flex"]="1 1 55%";fileViewer["style"]["flexDirection"]="column";fileViewer["innerHTML"]="\n            <div class=\"file-viewer-header\">\n                <h4 class=\"file-viewer-title\">"+window["langManager"]["t"]("game.files.file_content","File Content")+"</h4>\n                <button class=\"close-viewer\">\xD7</button>\n            </div>\n            <div class=\"file-viewer-info\"></div>\n            <div class=\"file-viewer-content\"></div>\n        ";mainArea["appendChild"](fileList);mainArea["appendChild"](fileViewer);contentContainer["appendChild"](mainArea);const fvContent=fileViewer["querySelector"](".file-viewer-content");if(fvContent){fvContent["style"]["overflow"]="auto";fvContent["style"]["flex"]="1 1 auto";fvContent["style"]["maxHeight"]="100%";fvContent["style"]["padding"]="10px";fvContent["style"]["whiteSpace"]="pre-wrap";fvContent["style"]["wordBreak"]="break-word"}document["body"]["appendChild"](fileWindow);makeDraggable(fileWindow);makeResizable(fileWindow);if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](fileWindow)}if(typeof WindowSizeManager!=="undefined"){WindowSizeManager["applyStoredSize"](fileWindow,"file-system-window")}this["loadPlayerFiles"](fileList,header);const refreshBtn=header["querySelector"]("#refresh-files-btn");refreshBtn["addEventListener"]("click",()=>{this["loadPlayerFiles"](fileList,header)});const closeViewerBtn=fileViewer["querySelector"](".close-viewer");closeViewerBtn["addEventListener"]("click",()=>{fileViewer["style"]["display"]="none"})}async["loadPlayerFiles"](fileList,header){fileList["innerHTML"]="<div class=\"loading\">Loading files...</div>";try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_player_files"});const data=await response["json"]();if(!data["success"]){fileList["innerHTML"]="<div class=\"error\">"+(data["message"]||"Error loading files")+"</div>";return}const fileStats=header["querySelector"](".file-stats");let totalSizeMB="0.00";if(Array["isArray"](data["files"])&&data["files"]["length"]>0){const totalKB=data["files"]["reduce"]((sum,f)=>{return sum+(Number(f["size"])||0)},0);totalSizeMB=(totalKB/1024)["toFixed"](2)}else{if(data["total_size"]){totalSizeMB=data["total_size"]}}fileStats["innerHTML"]="\n                <span class=\"file-count\">"+data["file_count"]+" "+window["langManager"]["t"]("game.files.files","files")+"</span>\n            ";if(data["files"]["length"]===0){fileList["innerHTML"]="\n                    <div class=\"no-files\">\n                        <p>"+window["langManager"]["t"]("game.files.no_files","No files copied yet.")+"</p>\n                        <p class=\"help-text\">"+window["langManager"]["t"]("game.files.help_text","Use the \"cp\" command in VDS missions to copy files here.")+"</p>\n                    </div>\n                ";return}fileList["innerHTML"]="";data["files"]["forEach"](file=>{const fileItem=document["createElement"]("div");fileItem["className"]="file-item";const sizeKB=(file["size"]/1024)["toFixed"](2);const date=new Date(file["copied_at"]);const dateStr=date["toLocaleDateString"]()+" "+date["toLocaleTimeString"]();fileItem["innerHTML"]="\n                    <div class=\"file-icon\">\uD83D\uDCC4</div>\n                    <div class=\"file-info\">\n                        <div class=\"file-name\">"+file["filename"]+"</div>\n                        <div class=\"file-meta\">\n                            <span class=\"file-source\">"+(file["source_ip"]||"Unknown")+"</span>\n                            <span class=\"file-size-small\">"+sizeKB+" KB</span>\n                            <span class=\"file-date\">"+dateStr+"</span>\n                        </div>\n                    </div>\n                    <div class=\"file-actions\">\n                        <button class=\"btn-delete\" data-file-id=\""+file["id"]+"\">\uD83D\uDDD1\uFE0F</button>\n                    </div>\n                ";fileList["appendChild"](fileItem);fileItem["addEventListener"]("click",()=>{this["viewFileContent"](file["id"])});const deleteBtn=fileItem["querySelector"](".btn-delete");if(deleteBtn){deleteBtn["addEventListener"]("click",e=>{e["stopPropagation"]();this["deletePlayerFile"](file["id"],fileList,header)})}})}catch(error){console["error"]("Error loading files:",error);fileList["innerHTML"]="<div class=\"error\">Network error</div>"}}["showNotepad"](){const existing=document["querySelector"](".notepad-window");if(existing){if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](existing,()=>{return existing["remove"]()})}else{existing["remove"]()}return}const win=document["createElement"]("div");win["className"]="window notepad-window";win["style"]["top"]="12%";win["style"]["left"]="18%";win["style"]["width"]="720px";win["style"]["height"]="520px";win["style"]["zIndex"]=getNextZIndex();const titleBar=document["createElement"]("div");titleBar["className"]="window-title";const brand=document["createElement"]("div");brand["className"]="window-brand";brand["innerHTML"]="\n            <div class=\"window-brand-icon\">\uD83D\uDCDD</div>\n            <div class=\"window-brand-text\">"+(window["langManager"]?window["langManager"]["t"]("game.notepad.title","Notepad"):"Notepad")+"</div>\n        ";titleBar["appendChild"](brand);const closeButton=document["createElement"]("div");closeButton["className"]="window-close";closeButton["textContent"]="\xD7";closeButton["addEventListener"]("click",()=>{if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](win,()=>{return win["remove"]()})}else{win["remove"]()}});titleBar["appendChild"](closeButton);const content=document["createElement"]("div");content["className"]="window-content notepad-content";content["innerHTML"]="\n            <div class=\"notepad-main\">\n                <div class=\"notepad-list\"></div>\n                <div class=\"notepad-editor\">\n                    <div class=\"gutter\"></div>\n                    <textarea class=\"notepad-textarea\" spellcheck=\"false\"></textarea>\n                    <div class=\"notepad-controls\">\n                        <button class=\"btn-new\">\uD83D\uDCDD</button>\n                        <button class=\"btn-save\">\uD83D\uDCBE</button>\n                        <button class=\"btn-delete\">\uD83D\uDDD1\uFE0F</button>\n                    </div>\n                </div>\n            </div>\n        ";win["appendChild"](titleBar);win["appendChild"](content);document["body"]["appendChild"](win);makeDraggable(win);makeResizable(win);if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](win)}const winId="notepad-"+Date["now"]();win["dataset"]["windowId"]=winId;const listEl=win["querySelector"](".notepad-list");const txt=win["querySelector"](".notepad-textarea");const gutter=win["querySelector"](".gutter");const btnNew=win["querySelector"](".notepad-controls .btn-new");const btnSave=win["querySelector"](".notepad-controls .btn-save");const btnDelete=win["querySelector"](".notepad-controls .btn-delete");const refreshList=async()=>{listEl["innerHTML"]="<div class=\"loading\">Loading...</div>";try{const res=await fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=notes",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"task=list"});const data=await res["json"]();if(!data["success"]){listEl["innerHTML"]="<div class=\"error\">Error</div>";return}if(!Array["isArray"](data["notes"])||data["notes"]["length"]===0){listEl["innerHTML"]="<div class=\"empty\">"+(window["langManager"]?window["langManager"]["t"]("game.notepad.no_notes","No notes yet"):"No notes yet")+"</div>";if(txt){txt["value"]="";txt["dataset"]["noteId"]="";updateGutter()}return}listEl["innerHTML"]="";data["notes"]["forEach"](n=>{const item=document["createElement"]("div");item["className"]="note-item";item["dataset"]["noteId"]=n["id"];item["innerHTML"]="<div class=\"note-title\">"+(n["title"]||"Untitled")+"</div><div class=\"note-meta\">"+new Date(n["updated_at"])["toLocaleDateString"]()+"</div>";item["addEventListener"]("click",async()=>{await loadNote(n["id"])});listEl["appendChild"](item)});if((!txt["dataset"]["noteId"]||txt["dataset"]["noteId"]==="")&&Array["isArray"](data["notes"])){const firstNote=data["notes"]["find"](x=>{return x["title"]==="first_notes.txt"});if(firstNote){if(!firstNote["content"]||!firstNote["content"]["startsWith"]("first_notes.txt")){try{const newContent="first_notes.txt\n"+(firstNote["content"]||"");await fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=notes",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:new URLSearchParams({["task"]:"save",["id"]:firstNote["id"],["title"]:"first_notes.txt",["content"]:newContent})["toString"]()});firstNote["content"]=newContent}catch(err){}}await loadNote(firstNote["id"])}}}catch(e){listEl["innerHTML"]="<div class=\"error\">Network error</div>"}};const loadNote=async id=>{try{const res=await fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=notes",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"task=list"});const data=await res["json"]();if(!data["success"]){return}const note=data["notes"]["find"](x=>{return x["id"]==id});if(note){txt["value"]=note["content"]||"";txt["dataset"]["noteId"]=note["id"];updateGutter()}}catch(e){}};const saveNote=async()=>{const content=txt["value"]||"";const rawId=txt["dataset"]["noteId"]||"";const isTemp=rawId&&rawId["toString"]()["startsWith"]("tmp_");const title=(content["split"]("\n")[0]||"")["trim"]()["slice"](0,60);const body=new URLSearchParams;body["append"]("task","save");body["append"]("content",content);body["append"]("title",title);if(!isTemp&&rawId){body["append"]("id",rawId)}try{const res=await fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=notes",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:body["toString"]()});const data=await res["json"]();if(data["success"]){txt["dataset"]["noteId"]=data["id"];refreshList();this["displayEvent"]({["type"]:"success",["message"]:window["langManager"]?window["langManager"]["t"]("game.notepad.saved","Saved"):"Saved"})}else{this["displayEvent"]({["type"]:"danger",["message"]:data["message"]||"Save failed"})}}catch(e){this["displayEvent"]({["type"]:"danger",["message"]:"Network error"})}};const deleteNote=async()=>{const id=txt["dataset"]["noteId"];if(!id){txt["value"]="";txt["dataset"]["noteId"]="";return}try{const res=await fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=notes",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"task=delete&id="+id});const data=await res["json"]();if(data["success"]){txt["value"]="";txt["dataset"]["noteId"]="";await refreshList();const first=listEl["querySelector"](".note-item");if(first&&first["dataset"]&&first["dataset"]["noteId"]){await loadNote(first["dataset"]["noteId"]);listEl["querySelectorAll"](".note-item")["forEach"](it=>{return it["classList"]["remove"]("active")});first["classList"]["add"]("active")}}}catch(e){}};const updateGutter=()=>{const lines=txt["value"]["split"]("\n")["length"];gutter["innerHTML"]="";for(let i=1;i<=lines;i++){const ln=document["createElement"]("div");ln["className"]="gutter-line";ln["textContent"]=i;gutter["appendChild"](ln)}};txt["addEventListener"]("input",updateGutter);btnSave["addEventListener"]("click",saveNote);const generateTempId=()=>{const chars="abcdefghijklmnopqrstuvwxyz0123456789";let out="";for(let i=0;i<6;i++){out+=chars[Math["floor"](Math["random"]()*chars["length"])]}return"tmp_"+out};btnNew["addEventListener"]("click",()=>{const existingTemps=listEl["querySelectorAll"](".note-item.temp-note");existingTemps["forEach"](t=>{return t["remove"]()});const tempId=generateTempId();txt["value"]="";txt["dataset"]["noteId"]=tempId;updateGutter();const tempItem=document["createElement"]("div");tempItem["className"]="note-item temp-note";tempItem["dataset"]["noteId"]=tempId;tempItem["innerHTML"]="<div class=\"note-title\">"+tempId["replace"]("tmp_","")+"</div><div class=\"note-meta\">"+new Date()["toLocaleDateString"]()+"</div>";tempItem["addEventListener"]("click",()=>{const others=listEl["querySelectorAll"](".note-item.temp-note");others["forEach"](o=>{if(o!==tempItem){o["remove"]()}});txt["value"]="";txt["dataset"]["noteId"]=tempId;updateGutter()});listEl["prepend"](tempItem)});btnDelete["addEventListener"]("click",deleteNote);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](winId,btnSave,"click",saveNote);window["eventListenerManager"]["register"](winId,btnNew,"click",()=>{const existingTemps=listEl["querySelectorAll"](".note-item.temp-note");existingTemps["forEach"](t=>{return t["remove"]()});const tempId=function(){const chars="abcdefghijklmnopqrstuvwxyz0123456789";let o="";for(let i=0;i<6;i++){o+=chars[Math["floor"](Math["random"]()*chars["length"])]}return"tmp_"+o}();txt["value"]="";txt["dataset"]["noteId"]=tempId;updateGutter();const tempItem=document["createElement"]("div");tempItem["className"]="note-item temp-note";tempItem["dataset"]["noteId"]=tempId;tempItem["innerHTML"]="<div class=\"note-title\">"+tempId["replace"]("tmp_","")+"</div><div class=\"note-meta\">"+new Date()["toLocaleDateString"]()+"</div>";tempItem["addEventListener"]("click",()=>{const others=listEl["querySelectorAll"](".note-item.temp-note");others["forEach"](o=>{if(o!==tempItem){o["remove"]()}});txt["value"]="";txt["dataset"]["noteId"]=tempId;updateGutter()});listEl["prepend"](tempItem)});window["eventListenerManager"]["register"](winId,btnDelete,"click",deleteNote);window["eventListenerManager"]["register"](winId,txt,"input",updateGutter)}updateGutter();refreshList()}async["viewFileContent"](fileId){const fileViewer=document["querySelector"](".file-viewer");if(!fileViewer){return}fileViewer["style"]["display"]="flex";const viewerContent=fileViewer["querySelector"](".file-viewer-content");const viewerInfo=fileViewer["querySelector"](".file-viewer-info");viewerContent["innerHTML"]="<div class=\"loading\">Loading...</div>";viewerInfo["innerHTML"]="";try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_file_content&file_id="+fileId});const data=await response["json"]();if(!data["success"]){viewerContent["innerHTML"]="<div class=\"error\">"+data["message"]+"</div>";return}const file=data["file"];viewerInfo["innerHTML"]="\n                <div class=\"info-row\">\n                    <span class=\"info-label\">"+window["langManager"]["t"]("game.files.filename","Filename")+":</span>\n                    <span class=\"info-value\">"+file["filename"]+"</span>\n                </div>\n                <div class=\"info-row\">\n                    <span class=\"info-label\">"+window["langManager"]["t"]("game.files.source","Source")+":</span>\n                    <span class=\"info-value\">"+file["source_ip"]+" - "+file["source_path"]+"</span>\n                </div>\n                <div class=\"info-row\">\n                    <span class=\"info-label\">"+window["langManager"]["t"]("game.files.size","Size")+":</span>\n                    <span class=\"info-value\">"+(file["size"]/1024)["toFixed"](2)+" KB</span>\n                </div>\n            ";viewerContent["innerHTML"]="<pre>"+this["escapeHtml"](file["content"])+"</pre>"}catch(error){console["error"]("Error viewing file:",error);viewerContent["innerHTML"]="<div class=\"error\">Network error</div>"}}async["deletePlayerFile"](fileId,fileList,header){const confirmed=await this["showFileDeleteConfirmation"]();if(!confirmed){return}try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=delete_file&file_id="+fileId});const data=await response["json"]();if(data["success"]){this["displayEvent"]({["type"]:"success",["message"]:window["langManager"]["t"]("game.files.file_deleted","File deleted successfully")});this["loadPlayerFiles"](fileList,header);const fileViewer=document["querySelector"](".file-viewer");if(fileViewer){fileViewer["style"]["display"]="none"}}else{this["displayEvent"]({["type"]:"danger",["message"]:data["message"]||"Error deleting file"})}}catch(error){console["error"]("Error deleting file:",error);this["displayEvent"]({["type"]:"danger",["message"]:"Network error"})}}["escapeHtml"](text){const map={"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#039;"};return text["replace"](new RegExp("[&<>\"']","g"),m=>{return map[m]})}["showFileDeleteConfirmation"](targetContainer=null){return new Promise(resolve=>{let fileWindow=null;if(targetContainer){fileWindow=typeof targetContainer==="string"?document["querySelector"](targetContainer):targetContainer}else{fileWindow=document["querySelector"](".file-system-window")}if(!fileWindow){resolve(false);return}const overlay=document["createElement"]("div");overlay["className"]="file-delete-overlay";overlay["style"]["cssText"]="\n                position: absolute;\n                top: 0;\n                left: 0;\n                right: 0;\n                bottom: 0;\n                background: rgba(0, 0, 0, 0.8);\n                display: flex;\n                align-items: center;\n                justify-content: center;\n                z-index: 1000;\n                animation: fadeIn 0.2s ease;\n            ";const dialog=document["createElement"]("div");dialog["className"]="file-delete-dialog";dialog["style"]["cssText"]="\n                background: rgba(0, 15, 10, 0.95);\n                border: 2px solid var(--border-color);\n                border-radius: 8px;\n                padding: 25px;\n                min-width: 350px;\n                box-shadow: 0 0 30px rgba(0, 255, 150, 0.3);\n                animation: scaleIn 0.3s ease;\n            ";dialog["innerHTML"]="\n                <div style=\"margin-bottom: 20px; text-align: center;\">\n                    <div style=\"font-size: 48px; margin-bottom: 10px;\">\uD83D\uDDD1\uFE0F</div>\n                    <h3 style=\"color: var(--primary-color); margin: 0 0 10px 0; font-size: 18px;\">\n                        "+window["langManager"]["t"]("game.files.confirm_delete_title","Delete File?")+"\n                    </h3>\n                    <p style=\"color: rgba(0, 255, 150, 0.7); margin: 0; font-size: 14px;\">\n                        "+window["langManager"]["t"]("game.files.confirm_delete_message","This action cannot be undone.")+"\n                    </p>\n                </div>\n                <div style=\"display: flex; gap: 10px; justify-content: center;\">\n                    <button class=\"btn-cancel\" style=\"\n                        background: rgba(100, 100, 100, 0.3);\n                        border: 1px solid rgba(150, 150, 150, 0.5);\n                        color: #ccc;\n                        padding: 10px 25px;\n                        border-radius: 4px;\n                        cursor: pointer;\n                        font-family: var(--game-font);\n                        font-size: 14px;\n                        transition: all 0.3s ease;\n                    \">\u274C "+window["langManager"]["t"]("game.files.cancel","Cancel")+"</button>\n                    <button class=\"btn-confirm-delete\" style=\"\n                        background: rgba(255, 0, 0, 0.2);\n                        border: 1px solid rgba(255, 0, 0, 0.5);\n                        color: #ff4444;\n                        padding: 10px 25px;\n                        border-radius: 4px;\n                        cursor: pointer;\n                        font-family: var(--game-font);\n                        font-size: 14px;\n                        transition: all 0.3s ease;\n                    \">\u2713 "+window["langManager"]["t"]("game.files.delete","Delete")+"</button>\n                </div>\n            ";overlay["appendChild"](dialog);fileWindow["appendChild"](overlay);const style=document["createElement"]("style");style["textContent"]="\n                @keyframes fadeIn {\n                    from { opacity: 0; }\n                    to { opacity: 1; }\n                }\n                @keyframes scaleIn {\n                    from { transform: scale(0.8); opacity: 0; }\n                    to { transform: scale(1); opacity: 1; }\n                }\n                .btn-cancel:hover {\n                    background: rgba(100, 100, 100, 0.5) !important;\n                    box-shadow: 0 0 10px rgba(150, 150, 150, 0.3);\n                }\n                .btn-confirm-delete:hover {\n                    background: rgba(255, 0, 0, 0.3) !important;\n                    box-shadow: 0 0 15px rgba(255, 0, 0, 0.5);\n                }\n            ";document["head"]["appendChild"](style);const cancelBtn=dialog["querySelector"](".btn-cancel");const confirmBtn=dialog["querySelector"](".btn-confirm-delete");const cleanup=()=>{overlay["style"]["animation"]="fadeOut 0.2s ease";setTimeout(()=>{overlay["remove"]();style["remove"]()},200)};cancelBtn["addEventListener"]("click",()=>{cleanup();resolve(false)});confirmBtn["addEventListener"]("click",()=>{cleanup();resolve(true)});const escHandler=e=>{if(e["key"]==="Escape"){cleanup();resolve(false);document["removeEventListener"]("keydown",escHandler)}};document["addEventListener"]("keydown",escHandler);overlay["addEventListener"]("click",e=>{if(e["target"]===overlay){cleanup();resolve(false)}})})}["executeCommandSilently"](command){const commandLower=command["toLowerCase"]()["trim"]();switch(commandLower){case"marketplace":showMarketplace();break;case"upload":case"uploadcenter":showUploadCenter();break;case"upgrades":case"upgrade":showUpgrades();break;case"crack":case"crackingtools":showCrackingTools();break;case"ads":showAdsPanel();break;case"anonchat":this["showAnonchat"]();break;case"mining":this["showMiningPanel"]();break;case"files":this["showFileSystem"]();break;case"notepad":case"notes":this["showNotepad"]();break;case"panel":case"server":this["showServerPanel"]();break;case"website":showWebsiteSimulation();break;case"music":this["showMusicPlayer"]();break;default:this["handleCommand"](command)}}["startTaskbarClock"](){const updateClock=()=>{const now=new Date;const timeString=now["toLocaleTimeString"]("en-US",{["hour12"]:false,["hour"]:"2-digit",["minute"]:"2-digit"});const taskbarTime=document["getElementById"]("taskbar-time");if(taskbarTime){taskbarTime["textContent"]=timeString}};updateClock();setInterval(updateClock,1000)}["updateTaskbarState"](){const taskbarApps=document["querySelectorAll"](".taskbar-app");taskbarApps["forEach"](app=>{const command=app["getAttribute"]("data-command");const isOpen=this["isWindowOpen"](command);app["classList"]["remove"]("active");if(isOpen){app["classList"]["add"]("active")}})}["isWindowOpen"](command){const windowSelectors={"marketplace":".marketplace-window","upload":".upload-center-window","upgrades":".upgrades-window","crack":".cracking-tools-window","ads":".ads-panel-window","panel":".server-panel-window","website":".website-simulation-window","anonchat":".anonchat-window","music":".window-music","files":".file-system-window","notepad":".notepad-window","mining":".mining-panel-window"};const selector=windowSelectors[command];if(!selector){return null}const window=document["querySelector"](selector);return window&&!window["classList"]["contains"]("hidden")?window:null}["isWindowFocused"](windowElement){if(!windowElement){return false}const allWindows=document["querySelectorAll"](".window:not(.hidden)");let highestZIndex=0;let topWindow=null;allWindows["forEach"](win=>{const zIndex=parseInt(window["getComputedStyle"](win)["zIndex"])||0;if(zIndex>highestZIndex){highestZIndex=zIndex;topWindow=win}});return topWindow===windowElement}["bringWindowToFront"](windowElement){if(!windowElement){return}const nextZIndex=getNextZIndex();windowElement["style"]["zIndex"]=nextZIndex;setTimeout(()=>{this["updateTaskbarState"]()},100)}["onWindowStateChange"](){this["updateTaskbarState"]()}["setupWindowStateMonitoring"](){const observer=new MutationObserver(mutations=>{let shouldUpdate=false;mutations["forEach"](mutation=>{if(mutation["type"]==="attributes"&&mutation["attributeName"]==="class"){const target=mutation["target"];if(target["classList"]["contains"]("window")){shouldUpdate=true}}if(mutation["type"]==="childList"){mutation["removedNodes"]["forEach"](node=>{if(node["nodeType"]===1&&node["classList"]&&node["classList"]["contains"]("window")){shouldUpdate=true}});mutation["addedNodes"]["forEach"](node=>{if(node["nodeType"]===1&&node["classList"]&&node["classList"]["contains"]("window")){shouldUpdate=true}})}});if(shouldUpdate){setTimeout(()=>{this["updateTaskbarState"]()},50)}});observer["observe"](document["body"],{["childList"]:true,["subtree"]:true,["attributes"]:true,["attributeFilter"]:["class","style"]});document["addEventListener"]("click",e=>{if(e["target"]["classList"]["contains"]("window-close")||e["target"]["closest"](".window-close")){setTimeout(()=>{this["updateTaskbarState"]()},100)}})}["initMusicPlayer"](){this["musicPlayer"]=document["createElement"]("audio");this["musicPlayer"]["id"]="game-music";document["body"]["appendChild"](this["musicPlayer"]);this["loadTrack"](this["currentTrackIndex"]);let savedVolume=localStorage["getItem"]("music_volume");if(savedVolume===null){savedVolume=localStorage["getItem"]("game_music_volume")||localStorage["getItem"]("menu_music_volume")}if(savedVolume!==null){this["musicVolume"]=parseFloat(savedVolume);if(isNaN(this["musicVolume"])){this["musicVolume"]=0.5}localStorage["setItem"]("music_volume",this["musicVolume"]["toString"]())}this["musicPlayer"]["volume"]=this["musicVolume"];let savedEffects=localStorage["getItem"]("effects_volume");if(savedEffects!==null){this["effectsVolume"]=parseFloat(savedEffects);if(isNaN(this["effectsVolume"])){this["effectsVolume"]=0.5}localStorage["setItem"]("effects_volume",this["effectsVolume"]["toString"]())}if(window["soundManager"]){window["soundManager"]["setVolume"](this["effectsVolume"])}this["musicPlayer"]["addEventListener"]("ended",()=>{if(this["isMusicLooping"]){this["musicPlayer"]["currentTime"]=0;this["musicPlayer"]["play"]()}else{this["playNextTrack"]()}});this["musicPlayer"]["play"]()["catch"](error=>{});this["setupUserInteractionFallback"]()}["setupUserInteractionFallback"](){const userInteractionHandler=()=>{if(this["musicPlayer"]["paused"]){this["musicPlayer"]["muted"]=false;this["playMusic"]();document["removeEventListener"]("click",userInteractionHandler);document["removeEventListener"]("keydown",userInteractionHandler)}};document["addEventListener"]("click",userInteractionHandler);document["addEventListener"]("keydown",userInteractionHandler)}["loadTrack"](index){if(index>=0&&index<this["musicFiles"]["length"]){this["currentTrackIndex"]=index;const trackPath=window["ASSETS_URL"]+"/sounds/"+this["musicFiles"][index];this["musicPlayer"]["src"]=trackPath}}["playMusic"](){this["musicPlayer"]["play"]()["catch"](error=>{})}["pauseMusic"](){this["musicPlayer"]["pause"]()}["playNextTrack"](){let nextIndex=(this["currentTrackIndex"]+1)%this["musicFiles"]["length"];this["loadTrack"](nextIndex);this["playMusic"]()}["playPreviousTrack"](){let prevIndex=(this["currentTrackIndex"]-1+this["musicFiles"]["length"])%this["musicFiles"]["length"];this["loadTrack"](prevIndex);this["playMusic"]()}["setMusicVolume"](volume){if(volume>=0&&volume<=1){this["musicVolume"]=volume;this["musicPlayer"]["volume"]=volume;localStorage["setItem"]("music_volume",volume["toString"]());localStorage["setItem"]("game_music_volume",volume["toString"]());localStorage["setItem"]("menu_music_volume",volume["toString"]());return true}return false}["setEffectsVolume"](volume){if(volume>=0&&volume<=1){this["effectsVolume"]=volume;if(window["soundManager"]){window["soundManager"]["setVolume"](volume)}try{if(window["catAnimationInstance"]&&typeof window["catAnimationInstance"]["updateVolume"]==="function"){window["catAnimationInstance"]["updateVolume"](volume)}}catch(e){}localStorage["setItem"]("effects_volume",volume["toString"]());return true}return false}["toggleLooping"](){this["isMusicLooping"]=!this["isMusicLooping"];return this["isMusicLooping"]}["getCurrentTrackInfo"](){return{["name"]:this["musicFiles"][this["currentTrackIndex"]],["index"]:this["currentTrackIndex"],["isPlaying"]:!this["musicPlayer"]["paused"],["volume"]:this["musicVolume"],["isLooping"]:this["isMusicLooping"],["duration"]:this["musicPlayer"]["duration"],["currentTime"]:this["musicPlayer"]["currentTime"]}}["showMusicPlayer"](){const existingWindow=document["querySelector"](".window-music");if(existingWindow){if(this["isWindowFocused"](existingWindow)){this["closeWindow"](existingWindow)}else{this["bringWindowToFront"](existingWindow)}return}const t=(key,defaultText)=>{return window["langManager"]?window["langManager"]["t"](key,defaultText):defaultText};const musicWindow=document["createElement"]("div");musicWindow["className"]="window window-music";musicWindow["innerHTML"]="\n            <div class=\"window-header\">\n                <div class=\"window-title\">\n                    <div class=\"window-brand\">\n                        <div class=\"window-brand-icon\">MU</div>\n                        <div class=\"window-brand-text\">"+t("game.music.title","Music Player")+"</div>\n                    </div>\n                </div>\n                <div class=\"window-buttons\">\n                    <button class=\"minimize-btn\">_</button>\n                    <button class=\"close-btn\">\xD7</button>\n                </div>\n            </div>\n            <div class=\"window-content\">\n                <div class=\"music-info\">\n                    <div class=\"now-playing\">"+t("game.music.now_playing","Now Playing")+": <span class=\"track-name\">"+this["musicFiles"][this["currentTrackIndex"]]+"</span></div>\n                </div>\n                <div class=\"progress-bar-container\">\n                    <div class=\"progress-bar\">\n                        <div class=\"progress-fill\"></div>\n                    </div>\n                    <div class=\"time-display\">\n                        <span class=\"current-time\">0:00</span> /\n                        <span class=\"total-time\">0:00</span>\n                    </div>\n                </div>\n                <div class=\"controls\">\n                    <button class=\"prev-btn\" title=\""+t("game.music.previous","Previous")+"\"><span>\u25C0\u25C0</span></button>\n                    <button class=\"play-pause-btn\" title=\""+t("game.music.play_pause","Play/Pause")+"\"><span>"+(this["musicPlayer"]["paused"]?"\u25B6":"\u275A\u275A")+"</span></button>\n                    <button class=\"next-btn\" title=\""+t("game.music.next","Next")+"\"><span>\u25B6\u25B6</span></button>\n                    <button class=\"loop-btn\" title=\""+t("game.music.loop","Loop")+"\"><span>\uD83D\uDD01</span></button>\n                </div>\n                <div class=\"volume-control\">\n                    <span>"+t("game.music.volume","Volume")+":</span>\n                    <input type=\"range\" min=\"0\" max=\"1\" step=\"0.01\" value=\""+this["musicVolume"]+"\" class=\"volume-slider\">\n                    <span class=\"volume-value\">"+Math["round"](this["musicVolume"]*100)+"%</span>\n                </div>\n                <div class=\"playlist\">\n                    <div class=\"playlist-header\">"+t("game.music.playlist","Playlist")+"</div>\n                    <ul class=\"track-list\">\n                        "+this["musicFiles"]["map"]((track,index)=>{return"\n                            <li class=\"track "+(index===this["currentTrackIndex"]?"active":"")+"\" data-index=\""+index+"\">\n                                "+track+"\n                            </li>\n                        "})["join"]("")+"\n                    </ul>\n                </div>\n            </div>\n        ";document["body"]["appendChild"](musicWindow);makeDraggable(musicWindow);musicWindow["style"]["zIndex"]=getNextZIndex();musicWindow["style"]["left"]="calc(50% - 200px)";musicWindow["style"]["top"]="calc(50% - 200px)";if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](musicWindow)}const closeBtn=musicWindow["querySelector"](".close-btn");const minimizeBtn=musicWindow["querySelector"](".minimize-btn");const playPauseBtn=musicWindow["querySelector"](".play-pause-btn");const prevBtn=musicWindow["querySelector"](".prev-btn");const nextBtn=musicWindow["querySelector"](".next-btn");const loopBtn=musicWindow["querySelector"](".loop-btn");const volumeSlider=musicWindow["querySelector"](".volume-slider");const volumeValue=musicWindow["querySelector"](".volume-value");const trackList=musicWindow["querySelectorAll"](".track");const progressBar=musicWindow["querySelector"](".progress-fill");const currentTimeDisplay=musicWindow["querySelector"](".current-time");const totalTimeDisplay=musicWindow["querySelector"](".total-time");const musicWindowId="music-player-"+Date["now"]();musicWindow["dataset"]["windowId"]=musicWindowId;if(this["isMusicLooping"]){loopBtn["classList"]["add"]("active")}const closeHandler=()=>{if(window["eventListenerManager"]){window["eventListenerManager"]["cleanup"](musicWindowId)}if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](musicWindow,()=>{musicWindow["remove"]()})}else{musicWindow["remove"]()}};closeBtn["addEventListener"]("click",closeHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](musicWindowId,closeBtn,"click",closeHandler)}const minimizeHandler=()=>{musicWindow["classList"]["toggle"]("minimized");if(musicWindow["classList"]["contains"]("minimized")){musicWindow["style"]["height"]="55px";musicWindow["style"]["minHeight"]="55px";musicWindow["style"]["overflow"]="hidden";const content=musicWindow["querySelector"](".window-content");if(content){content["style"]["display"]="none"}}else{musicWindow["style"]["height"]="";musicWindow["style"]["minHeight"]="";musicWindow["style"]["overflow"]="";const content=musicWindow["querySelector"](".window-content");if(content){content["style"]["display"]=""}}};minimizeBtn["addEventListener"]("click",minimizeHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](musicWindowId,minimizeBtn,"click",minimizeHandler)}const playPauseHandler=()=>{if(this["musicPlayer"]["paused"]){this["playMusic"]();playPauseBtn["innerHTML"]="<span>\u275A\u275A</span>"}else{this["pauseMusic"]();playPauseBtn["innerHTML"]="<span>\u25B6</span>"}};playPauseBtn["addEventListener"]("click",playPauseHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](musicWindowId,playPauseBtn,"click",playPauseHandler)}const prevHandler=()=>{this["playPreviousTrack"]();updatePlayerInfo()};prevBtn["addEventListener"]("click",prevHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](musicWindowId,prevBtn,"click",prevHandler)}const nextHandler=()=>{this["playNextTrack"]();updatePlayerInfo()};nextBtn["addEventListener"]("click",nextHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](musicWindowId,nextBtn,"click",nextHandler)}const loopHandler=()=>{const isLooping=this["toggleLooping"]();if(isLooping){loopBtn["classList"]["add"]("active")}else{loopBtn["classList"]["remove"]("active")}};loopBtn["addEventListener"]("click",loopHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](musicWindowId,loopBtn,"click",loopHandler)}const volumeHandler=()=>{const volume=parseFloat(volumeSlider["value"]);this["setMusicVolume"](volume);volumeValue["textContent"]=Math["round"](volume*100)+"%"};volumeSlider["addEventListener"]("input",volumeHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](musicWindowId,volumeSlider,"input",volumeHandler)}trackList["forEach"](track=>{const trackHandler=()=>{const index=parseInt(track["dataset"]["index"]);this["loadTrack"](index);this["playMusic"]();updatePlayerInfo();trackList["forEach"](t=>{return t["classList"]["remove"]("active")});track["classList"]["add"]("active")};track["addEventListener"]("click",trackHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](musicWindowId,track,"click",trackHandler)}});const updateProgress=()=>{if(!this["musicPlayer"]["paused"]&&!isNaN(this["musicPlayer"]["duration"])){const percent=this["musicPlayer"]["currentTime"]/this["musicPlayer"]["duration"]*100;progressBar["style"]["width"]=""+percent+"%";currentTimeDisplay["textContent"]=formatTime(this["musicPlayer"]["currentTime"]);totalTimeDisplay["textContent"]=formatTime(this["musicPlayer"]["duration"])}if(document["contains"](musicWindow)){requestAnimationFrame(updateProgress)}};const updatePlayerInfo=()=>{const trackNameElement=musicWindow["querySelector"](".track-name");trackNameElement["textContent"]=this["musicFiles"][this["currentTrackIndex"]];trackList["forEach"](t=>{return t["classList"]["remove"]("active")});const activeTrack=musicWindow["querySelector"](".track[data-index=\""+this["currentTrackIndex"]+"\"]");if(activeTrack){activeTrack["classList"]["add"]("active")}playPauseBtn["innerHTML"]=this["musicPlayer"]["paused"]?"<span>\u25B6</span>":"<span>\u275A\u275A</span>"};function formatTime(seconds){if(isNaN(seconds)){return"0:00"}seconds=Math["floor"](seconds);const minutes=Math["floor"](seconds/60);const remainingSeconds=seconds%60;return""+minutes+":"+remainingSeconds["toString"]()["padStart"](2,"0")}musicWindow["querySelector"](".progress-bar")["addEventListener"]("click",e=>{const progressBar=musicWindow["querySelector"](".progress-bar");const rect=progressBar["getBoundingClientRect"]();const pos=(e["clientX"]-rect["left"])/rect["width"];if(this["musicPlayer"]["duration"]){this["musicPlayer"]["currentTime"]=this["musicPlayer"]["duration"]*pos}});updateProgress();setTimeout(()=>{if(!isNaN(this["musicPlayer"]["duration"])){totalTimeDisplay["textContent"]=formatTime(this["musicPlayer"]["duration"])}},500);if(!document["getElementById"]("music-player-style")){const style=document["createElement"]("style");style["id"]="music-player-style";style["textContent"]="\n                .window-music {\n                    width: 400px;\n                    background-color: var(--terminal-bg);\n                    border: 1px solid var(--secondary-color);\n                    border-radius: 8px;\n                    overflow: hidden;\n                    box-shadow: 0 0 15px rgba(0, 0, 0, 0.5);\n                }\n\n                .window.window-music.minimized {\n                    height: 55px !important;\n                    overflow: hidden !important;\n                }\n\n                .window-music.minimized .window-content {\n                    display: none !important;\n                }\n\n                .window-music .window-header {\n                    display: flex;\n                    justify-content: space-between;\n                    padding: 5px 10px;\n                    background-color: rgba(0, 0, 0, 0.3);\n                    border-bottom: 1px solid var(--border-color);\n                }\n\n                .window-music .window-title {\n                    color: var(--secondary-color);\n                    font-weight: bold;\n                }\n\n                .window-music .window-buttons button {\n                    background: none;\n                    border: none;\n                    color: var(--primary-color);\n                    margin-left: 5px;\n                    cursor: pointer;\n                }\n\n                .window-music .window-content {\n                    padding: 15px;\n                    color: var(--primary-color);\n                }\n\n                .window-music .music-info {\n                    margin-bottom: 15px;\n                    text-align: center;\n                }\n\n                .window-music .now-playing {\n                    font-size: 14px;\n                }\n\n                .window-music .track-name {\n                    color: var(--secondary-color);\n                    font-weight: bold;\n                }\n\n                .window-music .progress-bar-container {\n                    margin-bottom: 15px;\n                }\n\n                .window-music .progress-bar {\n                    height: 8px;\n                    background-color: rgba(0, 0, 0, 0.4);\n                    border-radius: 4px;\n                    cursor: pointer;\n                    margin-bottom: 5px;\n                }\n\n                .window-music .progress-fill {\n                    height: 100%;\n                    width: 0%;\n                    background-color: var(--secondary-color);\n                    border-radius: 4px;\n                }\n\n                .window-music .time-display {\n                    display: flex;\n                    justify-content: space-between;\n                    font-size: 12px;\n                    color: var(--primary-color);\n                }\n\n                .window-music .controls {\n                    display: flex;\n                    justify-content: center;\n                    margin-bottom: 15px;\n                }\n\n                .window-music .controls button {\n                    background-color: rgba(0, 0, 0, 0.3);\n                    border: 1px solid var(--border-color);\n                    color: var(--primary-color);\n                    border-radius: 4px;\n                    margin: 0 5px;\n                    padding: 5px 10px;\n                    cursor: pointer;\n                    transition: background-color 0.2s;\n                }\n\n                .window-music .controls button:hover {\n                    background-color: rgba(0, 0, 0, 0.5);\n                }\n\n                .window-music .controls button.active {\n                    background-color: var(--secondary-color);\n                    color: black;\n                }\n\n                .window-music .volume-control {\n                    display: flex;\n                    align-items: center;\n                    margin-bottom: 15px;\n                }\n\n                .window-music .volume-slider {\n                    margin: 0 10px;\n                    flex: 1;\n                    -webkit-appearance: none;\n                    height: 5px;\n                    background: rgba(0, 0, 0, 0.4);\n                    border-radius: 2px;\n                }\n\n                .window-music .volume-slider::-webkit-slider-thumb {\n                    -webkit-appearance: none;\n                    width: 12px;\n                    height: 12px;\n                    border-radius: 50%;\n                    background: var(--secondary-color);\n                    cursor: pointer;\n                }\n\n                .window-music .volume-slider::-moz-range-thumb {\n                    width: 12px;\n                    height: 12px;\n                    border-radius: 50%;\n                    background: var(--secondary-color);\n                    cursor: pointer;\n                }\n\n                .window-music .playlist {\n                    background-color: rgba(0, 0, 0, 0.2);\n                    border-radius: 4px;\n                    padding: 10px;\n                    max-height: 150px;\n                    overflow-y: auto;\n                }\n\n                .window-music .playlist-header {\n                    color: var(--secondary-color);\n                    font-weight: bold;\n                    margin-bottom: 10px;\n                    padding-bottom: 5px;\n                    border-bottom: 1px solid var(--border-color);\n                }\n\n                .window-music .track-list {\n                    list-style: none;\n                    padding: 0;\n                    margin: 0;\n                }\n\n                .window-music .track {\n                    padding: 5px 10px;\n                    cursor: pointer;\n                    border-radius: 2px;\n                    transition: background-color 0.2s;\n                }\n\n                .window-music .track:hover {\n                    background-color: rgba(255, 255, 255, 0.1);\n                }\n\n                .window-music .track.active {\n                    background-color: rgba(0, 255, 0, 0.2);\n                    color: var(--secondary-color);\n                }\n            ";document["head"]["appendChild"](style)}return musicWindow}["showVDSWindow"](){const existingVDS=document["querySelector"](".vds-window");if(existingVDS){this["bringWindowToFront"](existingVDS);return}const vdsWindow=document["createElement"]("div");vdsWindow["className"]="window vds-window";vdsWindow["style"]["zIndex"]=getNextZIndex();const vdsWindowId="vds-window-"+Date["now"]();vdsWindow["dataset"]["windowId"]=vdsWindowId;vdsWindow["innerHTML"]="\n            <div class=\"window-header\">\n                <div class=\"window-title\">"+window["langManager"]["t"]("game.vds.title")+"</div>\n                <div class=\"window-controls\">\n                    <button class=\"window-maximize\">\u25A1</button>\n                    <button class=\"window-close\">\xD7</button>\n                </div>\n            </div>\n            <div class=\"vds-iframe-container\">\n                <iframe src=\""+window["BASE_URL"]+"/src/utils/Vds.php?iframe=1\" class=\"vds-iframe\" frameborder=\"0\"></iframe>\n                <div class=\"vds-drag-overlay\"></div>\n            </div>\n        ";this["addVDSWindowStyles"]();vdsWindow["style"]["width"]="1200px";vdsWindow["style"]["height"]="800px";vdsWindow["style"]["left"]="100px";vdsWindow["style"]["top"]="50px";document["body"]["appendChild"](vdsWindow);this["makeVDSWindowDraggable"](vdsWindow);makeResizable(vdsWindow);if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](vdsWindow)}const closeButton=vdsWindow["querySelector"](".window-close");const maximizeButton=vdsWindow["querySelector"](".window-maximize");const messageHandler=event=>{if(event["data"]&&event["data"]["action"]==="closeVDS"){if(window["eventListenerManager"]){window["eventListenerManager"]["cleanup"](vdsWindowId)}window["removeEventListener"]("message",messageHandler);if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](vdsWindow,()=>{vdsWindow["remove"]()})}else{vdsWindow["remove"]()}}};window["addEventListener"]("message",messageHandler);const closeHandler=()=>{if(window["eventListenerManager"]){window["eventListenerManager"]["cleanup"](vdsWindowId)}window["removeEventListener"]("message",messageHandler);if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](vdsWindow,()=>{vdsWindow["remove"]()})}else{vdsWindow["remove"]()}};closeButton["addEventListener"]("click",closeHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](vdsWindowId,closeButton,"click",closeHandler)}const maximizeHandler=()=>{const isMaximized=vdsWindow["style"]["width"]==="100vw";if(isMaximized){vdsWindow["style"]["width"]="1200px";vdsWindow["style"]["height"]="800px";vdsWindow["style"]["left"]="100px";vdsWindow["style"]["top"]="50px"}else{vdsWindow["style"]["width"]="100vw";vdsWindow["style"]["height"]="100vh";vdsWindow["style"]["left"]="0";vdsWindow["style"]["top"]="0"}};maximizeButton["addEventListener"]("click",maximizeHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](vdsWindowId,maximizeButton,"click",maximizeHandler)}if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](vdsWindow)}return vdsWindow}["addVDSWindowStyles"](){if(document["querySelector"]("#vds-window-styles")){return}const style=document["createElement"]("style");style["id"]="vds-window-styles";style["textContent"]="\n            .vds-window {\n                background: #000;\n                border: 2px solid var(--primary-color);\n                border-radius: 8px;\n                overflow: hidden;\n                position: absolute;\n            }\n\n            .vds-window .window-header {\n                background: linear-gradient(135deg, rgba(0, 255, 0, 0.1) 0%, rgba(0, 150, 50, 0.2) 100%);\n                padding: 8px 15px;\n                display: flex;\n                justify-content: space-between;\n                align-items: center;\n                border-bottom: 2px solid var(--primary-color);\n                cursor: move;\n                user-select: none;\n                height: 30px;\n                box-sizing: border-box;\n            }\n\n            .vds-window .window-title {\n                color: var(--primary-color);\n                font-weight: bold;\n                text-shadow: var(--text-shadow);\n                font-family: var(--game-font);\n                font-size: 14px;\n            }\n\n            .vds-window .window-controls {\n                display: flex;\n                gap: 5px;\n            }\n\n            .vds-window .window-maximize,\n            .vds-window .window-close {\n                background: transparent;\n                border: 1px solid var(--primary-color);\n                color: var(--primary-color);\n                width: 20px;\n                height: 20px;\n                border-radius: 3px;\n                cursor: pointer !important;\n                display: flex;\n                align-items: center;\n                justify-content: center;\n                font-family: monospace;\n                font-size: 12px;\n                transition: all 0.2s;\n            }\n\n            .vds-window .window-maximize:hover,\n            .vds-window .window-close:hover {\n                background: var(--primary-color);\n                color: #000;\n                box-shadow: 0 0 5px var(--primary-color);\n            }\n\n            .vds-iframe-container {\n                width: 100%;\n                height: calc(100% - 30px);\n                overflow: hidden;\n                position: relative;\n            }\n\n            .vds-iframe {\n                width: 100%;\n                height: 100%;\n                border: none;\n                display: block;\n            }\n\n            .vds-drag-overlay {\n                position: absolute;\n                top: 0;\n                left: 0;\n                width: 100%;\n                height: 100%;\n                background: transparent;\n                pointer-events: none;\n                z-index: 10;\n            }\n\n            .vds-drag-overlay.active {\n                pointer-events: all;\n            }\n        ";document["head"]["appendChild"](style)}["makeVDSWindowDraggable"](element){if(!element){return}const header=element["querySelector"](".window-header");const overlay=element["querySelector"](".vds-drag-overlay");if(!header){return}let pos1=0;let pos2=0;let pos3=0;let pos4=0;let isDragging=false;const gameContainer=document["getElementById"]("game-container");const constrainToBounds=(left,top)=>{const containerRect=gameContainer["getBoundingClientRect"]();const elementRect=element["getBoundingClientRect"]();const padding=2;const minLeft=containerRect["left"]+padding;const minTop=containerRect["top"]+padding;const maxLeft=containerRect["right"]-elementRect["width"]-padding;const maxTop=containerRect["bottom"]-elementRect["height"]-padding;const constrainedLeft=Math["max"](minLeft,Math["min"](left,maxLeft));const constrainedTop=Math["max"](minTop,Math["min"](top,maxTop));return{["left"]:constrainedLeft,["top"]:constrainedTop}};const dragStart=e=>{if(e["target"]["closest"](".window-controls")){return}e["preventDefault"]();pos3=e["clientX"];pos4=e["clientY"];isDragging=true;if(overlay){overlay["classList"]["add"]("active")}element["style"]["zIndex"]=getNextZIndex();document["addEventListener"]("mouseup",dragEnd);document["addEventListener"]("mousemove",drag)};const dragEnd=()=>{isDragging=false;if(overlay){overlay["classList"]["remove"]("active")}document["removeEventListener"]("mouseup",dragEnd);document["removeEventListener"]("mousemove",drag);const containerRect=gameContainer["getBoundingClientRect"]();const elementRect=element["getBoundingClientRect"]();if(elementRect["right"]>containerRect["right"]){element["style"]["left"]=containerRect["right"]-elementRect["width"]-2+"px"}if(elementRect["bottom"]>containerRect["bottom"]){element["style"]["top"]=containerRect["bottom"]-elementRect["height"]-2+"px"}if(elementRect["left"]<containerRect["left"]){element["style"]["left"]=containerRect["left"]+2+"px"}if(elementRect["top"]<containerRect["top"]){element["style"]["top"]=containerRect["top"]+2+"px"}};const drag=e=>{if(!isDragging){return}e["preventDefault"]();pos1=pos3-e["clientX"];pos2=pos4-e["clientY"];pos3=e["clientX"];pos4=e["clientY"];const elementRect=element["getBoundingClientRect"]();const newLeft=elementRect["left"]-pos1;const newTop=elementRect["top"]-pos2;const constrained=constrainToBounds(newLeft,newTop);element["style"]["left"]=constrained["left"]+"px";element["style"]["top"]=constrained["top"]+"px"};header["addEventListener"]("mousedown",dragStart);header["style"]["cursor"]="move";element["addEventListener"]("click",e=>{element["style"]["zIndex"]=getNextZIndex();if(window["game"]&&typeof window["game"]["onWindowStateChange"]==="function"){setTimeout(()=>{window["game"]["onWindowStateChange"]()},100)}})}}document["addEventListener"]("DOMContentLoaded",()=>{window["game"]=new Game});let currentMaxZIndex=1000;let uploadTimeout=null;function getNextZIndex(){const popups=document["querySelectorAll"](".mini-game, .window");let highestZIndex=currentMaxZIndex;popups["forEach"](popup=>{const zIndex=parseInt(window["getComputedStyle"](popup)["zIndex"],10);if(!isNaN(zIndex)&&zIndex>highestZIndex){highestZIndex=zIndex}});currentMaxZIndex=highestZIndex+1;return currentMaxZIndex}function makeDraggable(element){if(!element){return}const titleBar=element["querySelector"](".window-title")||element["querySelector"](".mini-game-header");if(!titleBar){return}let pos1=0;let pos2=0;let pos3=0;let pos4=0;let isDragging=false;const gameContainer=document["getElementById"]("game-container");const gameContainerRect=gameContainer["getBoundingClientRect"]();const elementRect=element["getBoundingClientRect"]();if(elementRect["width"]>gameContainerRect["width"]*0.9){element["style"]["width"]=Math["floor"](gameContainerRect["width"]*0.8)+"px"}if(elementRect["height"]>gameContainerRect["height"]*0.9){element["style"]["height"]=Math["floor"](gameContainerRect["height"]*0.8)+"px"}const updatedRect=element["getBoundingClientRect"]();if(updatedRect["right"]>gameContainerRect["right"]){element["style"]["left"]=gameContainerRect["right"]-updatedRect["width"]-5+"px"}if(updatedRect["bottom"]>gameContainerRect["bottom"]){element["style"]["top"]=gameContainerRect["bottom"]-updatedRect["height"]-5+"px"}if(updatedRect["left"]<gameContainerRect["left"]){element["style"]["left"]=gameContainerRect["left"]+5+"px"}if(updatedRect["top"]<gameContainerRect["top"]){element["style"]["top"]=gameContainerRect["top"]+5+"px"}const computedStyle=window["getComputedStyle"](element);const positionType=computedStyle["position"];function constrainToBounds(left,top){const containerRect=gameContainer["getBoundingClientRect"]();const elementRect=element["getBoundingClientRect"]();const padding=2;const minLeft=containerRect["left"]+padding;const minTop=containerRect["top"]+padding;const maxLeft=containerRect["right"]-elementRect["width"]-padding;const maxTop=containerRect["bottom"]-elementRect["height"]-padding;const constrainedLeft=Math["max"](minLeft,Math["min"](left,maxLeft));const constrainedTop=Math["max"](minTop,Math["min"](top,maxTop));return{["left"]:constrainedLeft,["top"]:constrainedTop}}if(!element["style"]["top"]||!element["style"]["left"]){const containerRect=gameContainer["getBoundingClientRect"]();const elementRect=element["getBoundingClientRect"]();const centerX=containerRect["left"]+(containerRect["width"]-elementRect["width"])/2;const centerY=containerRect["top"]+(containerRect["height"]-elementRect["height"])/2;element["style"]["left"]=centerX+"px";element["style"]["top"]=centerY+"px"}const dragStart=e=>{e["preventDefault"]();pos3=e["clientX"];pos4=e["clientY"];isDragging=true;element["style"]["zIndex"]=getNextZIndex();document["addEventListener"]("mouseup",dragEnd);document["addEventListener"]("mousemove",drag)};const dragEnd=()=>{isDragging=false;document["removeEventListener"]("mouseup",dragEnd);document["removeEventListener"]("mousemove",drag);const elementRect=element["getBoundingClientRect"]();const containerRect=gameContainer["getBoundingClientRect"]();if(elementRect["right"]>containerRect["right"]){element["style"]["left"]=containerRect["right"]-elementRect["width"]-2+"px"}if(elementRect["bottom"]>containerRect["bottom"]){element["style"]["top"]=containerRect["bottom"]-elementRect["height"]-2+"px"}if(elementRect["left"]<containerRect["left"]){element["style"]["left"]=containerRect["left"]+2+"px"}if(elementRect["top"]<containerRect["top"]){element["style"]["top"]=containerRect["top"]+2+"px"}try{const windowType=element["className"]["split"](" ")["find"](cls=>{return cls["endsWith"]("-window")});if(windowType&&typeof WindowPositionManager!=="undefined"){const rect=element["getBoundingClientRect"]();WindowPositionManager["saveWindowPosition"](windowType,Math["round"](rect["left"]),Math["round"](rect["top"]))}}catch(e){}};const drag=e=>{if(!isDragging){return}e["preventDefault"]();pos1=pos3-e["clientX"];pos2=pos4-e["clientY"];pos3=e["clientX"];pos4=e["clientY"];const elementRect=element["getBoundingClientRect"]();const newLeft=elementRect["left"]-pos1;const newTop=elementRect["top"]-pos2;const constrained=constrainToBounds(newLeft,newTop);element["style"]["left"]=constrained["left"]+"px";element["style"]["top"]=constrained["top"]+"px"};titleBar["addEventListener"]("mousedown",dragStart);element["addEventListener"]("click",e=>{element["style"]["zIndex"]=getNextZIndex();if(window["game"]&&typeof window["game"]["onWindowStateChange"]==="function"){setTimeout(()=>{window["game"]["onWindowStateChange"]()},100)}})}const WindowSizeManager={["getWindowSize"](windowType){const stored=localStorage["getItem"]("windowSize_"+windowType);return stored?JSON["parse"](stored):null},["saveWindowSize"](windowType,width,height){localStorage["setItem"]("windowSize_"+windowType,JSON["stringify"]({["width"]:width,["height"]:height}))},["applyStoredSize"](element,windowType){const stored=this["getWindowSize"](windowType);if(stored){element["style"]["width"]=stored["width"]+"px";element["style"]["height"]=stored["height"]+"px"}}};const WindowPositionManager={["getWindowPosition"](windowType){const stored=localStorage["getItem"]("windowPos_"+windowType);return stored?JSON["parse"](stored):null},["saveWindowPosition"](windowType,left,top){localStorage["setItem"]("windowPos_"+windowType,JSON["stringify"]({["left"]:left,["top"]:top}))},["applyStoredPosition"](element,windowType){const stored=this["getWindowPosition"](windowType);if(stored){try{element["style"]["left"]=Math["round"](stored["left"])+"px";element["style"]["top"]=Math["round"](stored["top"])+"px"}catch(e){}}}};function makeResizable(element){if(!element){return}const windowType=element["className"]["split"](" ")["find"](cls=>{return cls["endsWith"]("-window")});const resizeHandles=["nw-resize","n-resize","ne-resize","w-resize","e-resize","sw-resize","s-resize","se-resize"];resizeHandles["forEach"](handle=>{const resizer=document["createElement"]("div");resizer["className"]="window-resizer "+handle;element["appendChild"](resizer);let isResizing=false;let startX;let startY;let startWidth;let startHeight;let startLeft;let startTop;resizer["addEventListener"]("mousedown",e=>{e["preventDefault"]();e["stopPropagation"]();isResizing=true;startX=e["clientX"];startY=e["clientY"];const rect=element["getBoundingClientRect"]();startWidth=rect["width"];startHeight=rect["height"];startLeft=rect["left"];startTop=rect["top"];element["style"]["zIndex"]=getNextZIndex();const vdsOverlay=element["querySelector"](".vds-drag-overlay");if(vdsOverlay){vdsOverlay["classList"]["add"]("active")}document["addEventListener"]("mousemove",resize);document["addEventListener"]("mouseup",stopResize)});const resize=e=>{if(!isResizing){return}const deltaX=e["clientX"]-startX;const deltaY=e["clientY"]-startY;let newWidth=startWidth;let newHeight=startHeight;let newLeft=startLeft;let newTop=startTop;const gameContainer=document["getElementById"]("game-container");const containerRect=gameContainer["getBoundingClientRect"]();const minWidth=350;const minHeight=250;const maxWidth=containerRect["width"]-20;const maxHeight=containerRect["height"]-20;const dir=handle["split"]("-")[0];if(dir["includes"]("e")){newWidth=Math["min"](maxWidth,Math["max"](minWidth,startWidth+deltaX))}if(dir["includes"]("w")){const potentialWidth=startWidth-deltaX;if(potentialWidth>=minWidth){newWidth=potentialWidth;newLeft=startLeft+deltaX}}if(dir["includes"]("s")){newHeight=Math["min"](maxHeight,Math["max"](minHeight,startHeight+deltaY))}if(dir["includes"]("n")){const potentialHeight=startHeight-deltaY;if(potentialHeight>=minHeight){newHeight=potentialHeight;newTop=startTop+deltaY}}if(newLeft<containerRect["left"]){newWidth+=newLeft-containerRect["left"];newLeft=containerRect["left"]}if(newTop<containerRect["top"]){newHeight+=newTop-containerRect["top"];newTop=containerRect["top"]}if(newLeft+newWidth>containerRect["right"]){newWidth=containerRect["right"]-newLeft}if(newTop+newHeight>containerRect["bottom"]){newHeight=containerRect["bottom"]-newTop}element["style"]["width"]=newWidth+"px";element["style"]["height"]=newHeight+"px";element["style"]["left"]=newLeft+"px";element["style"]["top"]=newTop+"px"};const stopResize=()=>{isResizing=false;const vdsOverlay=element["querySelector"](".vds-drag-overlay");if(vdsOverlay){vdsOverlay["classList"]["remove"]("active")}document["removeEventListener"]("mousemove",resize);document["removeEventListener"]("mouseup",stopResize);if(windowType){const rect=element["getBoundingClientRect"]();WindowSizeManager["saveWindowSize"](windowType,Math["round"](rect["width"]),Math["round"](rect["height"]))}}})}function showMarketplace(){const existingPanel=document["querySelector"](".marketplace-window");if(existingPanel){if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](existingPanel,()=>{existingPanel["remove"]()})}else{existingPanel["remove"]()}return}const marketplaceWindow=document["createElement"]("div");marketplaceWindow["className"]="window marketplace-window";marketplaceWindow["style"]["top"]="10%";marketplaceWindow["style"]["left"]="10%";marketplaceWindow["style"]["width"]="1050px";marketplaceWindow["style"]["height"]="680px";marketplaceWindow["style"]["zIndex"]=getNextZIndex();const titleBar=document["createElement"]("div");titleBar["className"]="window-title";const brand=document["createElement"]("div");brand["className"]="window-brand";brand["innerHTML"]="\n        <div class=\"window-brand-icon\">DM</div>\n        <div class=\"window-brand-text\">DigiMarket</div>\n    ";titleBar["appendChild"](brand);marketplaceWindow["appendChild"](titleBar);const marketplaceWindowId="marketplace-window-"+Date["now"]();marketplaceWindow["dataset"]["windowId"]=marketplaceWindowId;const closeButton=document["createElement"]("button");closeButton["className"]="window-close";closeButton["textContent"]="\xD7";const closeHandler=()=>{if(window["eventListenerManager"]){window["eventListenerManager"]["cleanup"](marketplaceWindowId)}if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](marketplaceWindow,()=>{marketplaceWindow["remove"]()})}else{marketplaceWindow["remove"]()}};closeButton["addEventListener"]("click",closeHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](marketplaceWindowId,closeButton,"click",closeHandler)}titleBar["appendChild"](closeButton);const contentContainer=document["createElement"]("div");contentContainer["className"]="window-content marketplace-content";marketplaceWindow["appendChild"](contentContainer);const marketplaceUI="\n        <div class=\"marketplace-browser\">\n            <div class=\"marketplace-topbar\">\n                <div class=\"mp-window-controls\">\n                    <span class=\"mp-dot red\"></span>\n                    <span class=\"mp-dot yellow\"></span>\n                    <span class=\"mp-dot green\"></span>\n                </div>\n                <div class=\"marketplace-urlbar\">\n                    <span class=\"mp-lock\" title=\"Secure\">\uD83D\uDD12</span>\n                    <input class=\"mp-url\" type=\"text\" readonly value=\"https://store.digimarket/\" />\n                    <button class=\"mp-refresh\" title=\"Reload\">\u21BB</button>\n                </div>\n            </div>\n\n            <div class=\"marketplace-hero\" id=\"marketplace-hero\">\n                <div class=\"marketplace-hero-skeleton\"></div>\n            </div>\n\n            <div class=\"marketplace-container\">\n                <aside class=\"marketplace-sidebar\">\n                    <div class=\"marketplace-categories\">\n                        <div class=\"marketplace-category active\" data-category=\"all\">"+window["langManager"]["t"]("game.marketplace.all_software")+"</div>\n                        <div class=\"marketplace-category\" data-category=\"game\">"+window["langManager"]["t"]("game.marketplace.games")+"</div>\n                        <div class=\"marketplace-category\" data-category=\"application\">"+window["langManager"]["t"]("game.marketplace.applications")+"</div>\n                        <div class=\"marketplace-category\" data-category=\"utility\">"+window["langManager"]["t"]("game.marketplace.utilities")+"</div>\n                        <div class=\"marketplace-category\" data-category=\"os\">"+window["langManager"]["t"]("game.marketplace.operating_systems")+"</div>\n                    </div>\n                </aside>\n                <div class=\"marketplace-content-area\">\n                    <div class=\"marketplace-featured\">\n                        <h2>"+window["langManager"]["t"]("game.marketplace.featured_software")+"</h2>\n                        <div class=\"marketplace-featured-items\" id=\"featured-items\">\n                            <div class=\"marketplace-loading\">"+window["langManager"]["t"]("game.marketplace.loading_featured")+"</div>\n                        </div>\n                    </div>\n                    <div class=\"marketplace-list\">\n                        <div class=\"marketplace-list-header\">\n                            <h2>"+window["langManager"]["t"]("game.marketplace.available_software")+"</h2>\n                            <div class=\"marketplace-sort\">\n                                <select id=\"sort-options\">\n                                    <option value=\"name\">"+window["langManager"]["t"]("game.marketplace.sort_by_name")+"</option>\n                                    <option value=\"price\">"+window["langManager"]["t"]("game.marketplace.sort_by_price")+"</option>\n                                    <option value=\"date\" selected>"+window["langManager"]["t"]("game.marketplace.sort_by_date")+"</option>\n                                    <option value=\"size\">"+window["langManager"]["t"]("game.marketplace.sort_by_size")+"</option>\n                                </select>\n                            </div>\n                        </div>\n                        <div id=\"software-list\" class=\"marketplace-items\">\n                            <div class=\"marketplace-loading\">"+window["langManager"]["t"]("game.marketplace.loading_software")+"</div>\n                        </div>\n                        <div class=\"marketplace-pagination\" id=\"pagination-container\"></div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    ";contentContainer["innerHTML"]=marketplaceUI;document["body"]["appendChild"](marketplaceWindow);makeDraggable(marketplaceWindow);makeResizable(marketplaceWindow);if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](marketplaceWindow)}WindowSizeManager["applyStoredSize"](marketplaceWindow,"marketplace-window");WindowPositionManager["applyStoredPosition"](marketplaceWindow,"marketplace-window");function refreshMarketplaceWindow(){const hero=marketplaceWindow["querySelector"]("#marketplace-hero");const featured=marketplaceWindow["querySelector"]("#featured-items");const list=marketplaceWindow["querySelector"]("#software-list");const pagination=marketplaceWindow["querySelector"]("#pagination-container");if(hero){hero["innerHTML"]="<div class=\"marketplace-hero-skeleton\"></div>"}if(featured){featured["innerHTML"]="<div class=\"marketplace-loading\">"+window["langManager"]["t"]("game.marketplace.loading_featured")+"</div>"}if(list){list["innerHTML"]="<div class=\"marketplace-loading\">"+window["langManager"]["t"]("game.marketplace.loading_software")+"</div>"}if(pagination){pagination["innerHTML"]=""}loadMarketplaceData(true)}const refreshBtn=marketplaceWindow["querySelector"](".mp-refresh");if(refreshBtn){const refreshHandler=()=>{return refreshMarketplaceWindow()};refreshBtn["addEventListener"]("click",refreshHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](marketplaceWindowId,refreshBtn,"click",refreshHandler)}}const categoryElements=marketplaceWindow["querySelectorAll"](".marketplace-category");categoryElements["forEach"](category=>{const categoryHandler=function(){categoryElements["forEach"](c=>{return c["classList"]["remove"]("active")});this["classList"]["add"]("active");const selectedCategory=this["getAttribute"]("data-category");filterSoftwareByCategory(selectedCategory)};category["addEventListener"]("click",categoryHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](marketplaceWindowId,category,"click",categoryHandler)}});const searchInput=marketplaceWindow["querySelector"](".marketplace-search");if(searchInput){const searchHandler=function(){filterSoftwareBySearch(this["value"])};searchInput["addEventListener"]("input",searchHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](marketplaceWindowId,searchInput,"input",searchHandler)}}const sortOptions=document["getElementById"]("sort-options");const sortHandler=function(){sortSoftware(this["value"])};sortOptions["addEventListener"]("change",sortHandler);if(window["eventListenerManager"]){window["eventListenerManager"]["register"](marketplaceWindowId,sortOptions,"change",sortHandler)}const itemsPerPage=6;let currentPage=1;let allSoftware=[];let filteredSoftware=[];let featuredSoftware=[];function filterSoftwareByCategory(category){if(category==="all"){filteredSoftware=allSoftware["filter"](software=>{return software["name"]!=="VPN"})}else{let searchTerm=category["toLowerCase"]();if(searchTerm==="application"){filteredSoftware=allSoftware["filter"](software=>{return software["type"]["toLowerCase"]()==="application"||software["type"]["toLowerCase"]()==="app"})}else{filteredSoftware=allSoftware["filter"](software=>{return software["type"]["toLowerCase"]()["includes"](searchTerm)})}}currentPage=1;displaySoftware(currentPage)}function filterSoftwareBySearch(query){if(!query["trim"]()){const activeCategory=marketplaceWindow["querySelector"](".marketplace-category.active");const category=activeCategory["getAttribute"]("data-category");filterSoftwareByCategory(category);return}const searchTerm=query["trim"]()["toLowerCase"]();filteredSoftware=allSoftware["filter"](software=>{return software["name"]["toLowerCase"]()["includes"](searchTerm)||software["type"]["toLowerCase"]()["includes"](searchTerm)});currentPage=1;displaySoftware(currentPage)}function sortSoftware(sortBy){switch(sortBy){case"name":filteredSoftware["sort"]((a,b)=>{return a["name"]["localeCompare"](b["name"])});break;case"price":filteredSoftware["sort"]((a,b)=>{return a["cost"]-b["cost"]});break;case"date":filteredSoftware["sort"]((a,b)=>{return b["release_year"]-a["release_year"]});break;case"size":filteredSoftware["sort"]((a,b)=>{return b["size_gb"]-a["size_gb"]});break}displaySoftware(currentPage)}function displaySoftware(page){const startIndex=(page-1)*itemsPerPage;const endIndex=startIndex+itemsPerPage;const softwareToShow=filteredSoftware["slice"](startIndex,endIndex);const softwareList=document["getElementById"]("software-list");softwareList["innerHTML"]="";if(softwareToShow["length"]===0){softwareList["innerHTML"]="<div class=\"marketplace-no-results\">"+window["langManager"]["t"]("game.marketplace.no_results")+"</div>";document["getElementById"]("pagination-container")["innerHTML"]="";return}softwareToShow["forEach"](software=>{const item=document["createElement"]("div");item["className"]="marketplace-item";item["setAttribute"]("data-type",software["type"]["toLowerCase"]());const isVPN=software["name"]==="VPN";const isVPNOwned=isVPN&&software["is_vpn_owned"]==1;let typeIcon;switch(software["type"]["toLowerCase"]()){case"game":typeIcon="<i class=\"marketplace-item-icon game\">\uD83C\uDFAE</i>";break;case"application":typeIcon="<i class=\"marketplace-item-icon app\">\uD83D\uDCCA</i>";break;case"utility":typeIcon="<i class=\"marketplace-item-icon utility\">\uD83D\uDEE0\uFE0F</i>";break;case"os":typeIcon="<i class=\"marketplace-item-icon os\">\uD83D\uDCBB</i>";break;default:typeIcon="<i class=\"marketplace-item-icon\">\uD83D\uDCE6</i>"}item["innerHTML"]="\n                <div class=\"marketplace-item-header\">\n                    "+typeIcon+"\n                    <div class=\"marketplace-item-name\">"+(software["display_name"]||software["name"])+"</div>\n                    <div class=\"marketplace-item-year\">"+software["release_year"]+"</div>\n                    </div>\n                <div class=\"marketplace-item-details\">\n                    <div class=\"marketplace-item-type\">"+software["type"]+"</div>\n                    <div class=\"marketplace-item-size\">"+software["size_gb"]+" GB</div>\n                </div>\n                <div class=\"marketplace-item-footer\">\n                    <div class=\"marketplace-item-price\">"+software["cost"]+" "+window["langManager"]["t"]("game.marketplace.credits")+"</div>\n                    <button class=\"marketplace-item-button "+(isVPNOwned?"disabled":"")+"\" \n                            onclick=\""+(isVPNOwned?"":"purchaseSoftware("+software["id"]+")")+"\"\n                            "+(isVPNOwned?"disabled":"")+">\n                        "+(isVPNOwned?window["langManager"]["t"]("game.marketplace.vpn.owned"):window["langManager"]["t"]("game.marketplace.purchase"))+"\n                        "+(isVPNOwned?"<span onclick=\"event.stopPropagation(); showVPNRefillPopup()\" style=\"margin-left: 8px; cursor: pointer; font-size: 16px;\" title=\"Refill VPN\">\uD83D\uDD04</span>":"")+"\n                    </button>\n                </div>\n            ";softwareList["appendChild"](item)});setupPagination(filteredSoftware["length"],page);if(page===1&&featuredSoftware["length"]>0){displayFeaturedSoftware()}}function setupPagination(totalItems,currentPage){const totalPages=Math["ceil"](totalItems/itemsPerPage);const paginationContainer=document["getElementById"]("pagination-container");if(totalPages<=1){paginationContainer["innerHTML"]="";return}let paginationHTML="\n            <button class=\"pagination-button prev\" "+(currentPage===1?"disabled":"")+">\u2190</button>\n        ";const maxVisiblePages=5;let startPage=Math["max"](1,currentPage-Math["floor"](maxVisiblePages/2));let endPage=Math["min"](totalPages,startPage+maxVisiblePages-1);if(endPage-startPage+1<maxVisiblePages){startPage=Math["max"](1,endPage-maxVisiblePages+1)}if(startPage>1){paginationHTML+="<button class=\"pagination-button\" data-page=\"1\">1</button>";if(startPage>2){paginationHTML+="<span class=\"pagination-ellipsis\">...</span>"}}for(let i=startPage;i<=endPage;i++){paginationHTML+="<button class=\"pagination-button "+(i===currentPage?"active":"")+"\" data-page=\""+i+"\">"+i+"</button>"}if(endPage<totalPages){if(endPage<totalPages-1){paginationHTML+="<span class=\"pagination-ellipsis\">...</span>"}paginationHTML+="<button class=\"pagination-button\" data-page=\""+totalPages+"\">"+totalPages+"</button>"}paginationHTML+="\n            <button class=\"pagination-button next\" "+(currentPage===totalPages?"disabled":"")+">\u2192</button>\n            <span class=\"pagination-info\">"+window["langManager"]["t"]("game.marketplace.page_info",{["current"]:currentPage,["total"]:totalPages})+"</span>\n        ";paginationContainer["innerHTML"]=paginationHTML;const pageButtons=paginationContainer["querySelectorAll"](".pagination-button");pageButtons["forEach"](button=>{if(button["classList"]["contains"]("prev")){button["addEventListener"]("click",()=>{if(currentPage>1){changePage(currentPage-1)}})}else{if(button["classList"]["contains"]("next")){button["addEventListener"]("click",()=>{if(currentPage<totalPages){changePage(currentPage+1)}})}else{const pageNum=parseInt(button["getAttribute"]("data-page"));button["addEventListener"]("click",()=>{return changePage(pageNum)})}}})}function displayFeaturedSoftware(){const featuredContainer=document["getElementById"]("featured-items");featuredContainer["innerHTML"]="";const hero=document["getElementById"]("marketplace-hero");if(hero){if(featuredSoftware&&featuredSoftware["length"]>0){const top=featuredSoftware[0];const typeBadge="<span class=\"mp-hero-badge\">"+top["type"]+"</span>";hero["innerHTML"]="\n                    <div class=\"marketplace-hero-content\">\n                        <div class=\"marketplace-hero-text\">\n                            "+typeBadge+"\n                            <h1 class=\"marketplace-hero-title\">"+top["name"]+"</h1>\n                            <div class=\"marketplace-hero-meta\">\n                                <span>"+top["release_year"]+"</span>\n                                <span>\u2022</span>\n                                <span>"+top["size_gb"]+" GB</span>\n                            </div>\n                        </div>\n                        <div class=\"marketplace-hero-actions\">\n                            <div class=\"marketplace-hero-price\">"+top["cost"]+" "+window["langManager"]["t"]("game.marketplace.credits")+"</div>\n                            <button class=\"marketplace-hero-button\" onclick=\"purchaseSoftware("+top["id"]+")\">"+window["langManager"]["t"]("game.marketplace.purchase")+"</button>\n                        </div>\n                    </div>\n                "}else{hero["innerHTML"]="<div class=\"marketplace-hero-empty\">"+window["langManager"]["t"]("game.marketplace.no_featured")+"</div>"}}featuredSoftware["forEach"](software=>{const featuredItem=document["createElement"]("div");featuredItem["className"]="marketplace-featured-item";featuredItem["setAttribute"]("data-type",software["type"]["toLowerCase"]());let typeIcon;switch(software["type"]["toLowerCase"]()){case"game":typeIcon="<i class=\"marketplace-item-icon game\">\uD83C\uDFAE</i>";break;case"application":typeIcon="<i class=\"marketplace-item-icon app\">\uD83D\uDCCA</i>";break;case"utility":typeIcon="<i class=\"marketplace-item-icon utility\">\uD83D\uDEE0\uFE0F</i>";break;case"os":typeIcon="<i class=\"marketplace-item-icon os\">\uD83D\uDCBB</i>";break;default:typeIcon="<i class=\"marketplace-item-icon\">\uD83D\uDCE6</i>"}featuredItem["innerHTML"]="\n                <div class=\"marketplace-featured-item-header\">\n                    "+typeIcon+"\n                    <div class=\"marketplace-featured-item-name\">"+software["name"]+"</div>\n                </div>\n                <div class=\"marketplace-featured-item-info\">\n                    <div class=\"marketplace-featured-item-details\">\n                        <div class=\"marketplace-featured-item-type\">"+software["type"]+"</div>\n                        <div class=\"marketplace-featured-item-year\">"+software["release_year"]+"</div>\n                        <div class=\"marketplace-featured-item-size\">"+software["size_gb"]+" GB</div>\n                    </div>\n                    <div class=\"marketplace-featured-item-footer\">\n                        <div class=\"marketplace-featured-item-price\">"+software["cost"]+" "+window["langManager"]["t"]("game.marketplace.credits")+"</div>\n                        <button class=\"marketplace-featured-item-button\" onclick=\"purchaseSoftware("+software["id"]+")\">"+window["langManager"]["t"]("game.marketplace.purchase")+"</button>\n                    </div>\n                </div>\n            ";featuredContainer["appendChild"](featuredItem)})}window["changePage"]=function(page){currentPage=page;displaySoftware(currentPage)};function loadMarketplaceData(isRefresh=false){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_available_software"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]&&Array["isArray"](data["software"])){allSoftware=data["software"];filteredSoftware=[...allSoftware]["filter"](software=>{return software["name"]!=="VPN"});featuredSoftware=[...allSoftware]["filter"](software=>{return software["name"]!=="VPN"})["sort"]((a,b)=>{return b["cost"]+b["release_year"]-(a["cost"]+a["release_year"])})["slice"](0,3);currentPage=1;allSoftware=allSoftware["map"](s=>{return{...s,["display_name"]:s["name"]}});displaySoftware(currentPage)}else{const softwareList=document["getElementById"]("software-list");if(softwareList){softwareList["innerHTML"]="<div class=\"marketplace-error\">"+window["langManager"]["t"]("game.marketplace.no_software")+"</div>"}const featuredContainer=document["getElementById"]("featured-items");if(featuredContainer){featuredContainer["innerHTML"]="<div class=\"marketplace-error\">"+window["langManager"]["t"]("game.marketplace.no_featured")+"</div>"}}})["catch"](error=>{const softwareList=document["getElementById"]("software-list");if(softwareList){softwareList["innerHTML"]="<div class=\"marketplace-error\">"+window["langManager"]["t"]("game.marketplace.error_loading_software")+"</div>"}const featuredContainer=document["getElementById"]("featured-items");if(featuredContainer){featuredContainer["innerHTML"]="<div class=\"marketplace-error\">"+window["langManager"]["t"]("game.marketplace.error_loading_featured")+"</div>"}})}loadMarketplaceData();window["refreshMarketplaceWindow"]=refreshMarketplaceWindow}function showCrackingTools(){const existingPanel=document["querySelector"](".cracking-tools-window");if(existingPanel){if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](existingPanel,()=>{return existingPanel["remove"]()})}else{existingPanel["remove"]()}return}const tools=document["createElement"]("div");tools["className"]="window cracking-tools-window";tools["style"]["top"]="40%";tools["style"]["left"]="58%";tools["style"]["width"]="800px";tools["style"]["height"]="600px";tools["style"]["zIndex"]=getNextZIndex();tools["innerHTML"]="\n        <div class=\"window-title\">\n            <div class=\"window-brand\">\n                <div class=\"window-brand-icon\">CT</div>\n                <div class=\"window-brand-text\">CrackTools</div>\n            </div>\n            <button class=\"window-close\">\xD7</button>\n        </div>\n        <div class=\"window-content cracking-tools-content\">\n            <div class=\"cracking-tools-matrix\" id=\"matrix-effect\"></div>\n            <div class=\"cracking-tools-container\">\n                <div class=\"cracking-tools-sidebar\">\n                    <div class=\"cracking-tools-header\">\n                        <div class=\"cracking-tools-subtitle\">"+window["langManager"]["t"]("game.cracking.subtitle")+"</div>\n                    </div>\n                    <div class=\"cracking-tools-stats\">\n                        <div class=\"cracking-tools-stat\">\n                            <div class=\"cracking-tools-stat-label\">"+window["langManager"]["t"]("game.cracking.system_status")+"</div>\n                            <div class=\"cracking-tools-stat-value success\">"+window["langManager"]["t"]("game.cracking.online")+"</div>\n                        </div>\n                        <div class=\"cracking-tools-stat\">\n                            <div class=\"cracking-tools-stat-label\">"+window["langManager"]["t"]("game.cracking.last_login")+"</div>\n                            <div class=\"cracking-tools-stat-value\">"+new Date()["toLocaleTimeString"]()+"</div>\n                        </div>\n                        <div class=\"cracking-tools-stat\">\n                            <div class=\"cracking-tools-stat-label\">"+window["langManager"]["t"]("game.cracking.security_level")+"</div>\n                            <div class=\"cracking-tools-stat-value\">"+window["langManager"]["t"]("game.cracking.maximum")+"</div>\n                        </div>\n                        <div class=\"cracking-tools-stat\">\n                            <div class=\"cracking-tools-stat-label\">"+window["langManager"]["t"]("game.cracking.available_tools")+"</div>\n                            <div class=\"cracking-tools-stat-value\">3</div>\n                        </div>\n                    </div>\n                </div>\n                <div class=\"cracking-tools-main\">\n                    <h2 class=\"cracking-tools-title\">"+window["langManager"]["t"]("game.cracking.decryption_panel")+"</h2>\n                <div id=\"software-to-crack\"></div>\n                    <div class=\"cracking-tools-pagination\"></div>\n            </div>\n        </div>\n        </div>\n    ";document["body"]["appendChild"](tools);makeDraggable(tools);makeResizable(tools);if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](tools)}WindowSizeManager["applyStoredSize"](tools,"cracking-tools-window");const crackingToolsWindowId="cracking-tools-"+Date["now"]();tools["dataset"]["windowId"]=crackingToolsWindowId;const closeButtonHandler=()=>{if(window["eventListenerManager"]){window["eventListenerManager"]["cleanup"](crackingToolsWindowId)}if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](tools,()=>{return tools["remove"]()})}else{tools["remove"]()}};if(window["eventListenerManager"]){window["eventListenerManager"]["add"](crackingToolsWindowId,tools["querySelector"](".window-close"),"click",closeButtonHandler)}else{tools["querySelector"](".window-close")["addEventListener"]("click",closeButtonHandler)}initMatrixEffect();const itemsPerPage=5;let currentPage=1;let allSoftware=[];window["changeCrackingPage"]=function(page){currentPage=page;displaySoftware(page)};function initMatrixEffect(){const matrix=document["getElementById"]("matrix-effect");const columns=Math["floor"](matrix["offsetWidth"]/20);for(let i=0;i<columns;i++){const column=document["createElement"]("div");column["className"]="matrix-column";column["style"]["left"]=i*20+"px";const chars="01"["split"]("");const height=Math["floor"](Math["random"]()*15)+5;for(let j=0;j<height;j++){const char=chars[Math["floor"](Math["random"]()*chars["length"])];column["innerHTML"]+=char+"<br>"}const speed=Math["random"]()*3+2;column["style"]["animation"]="matrix-fall "+speed+"s linear infinite";column["style"]["animationDelay"]=Math["random"]()*5+"s";matrix["appendChild"](column)}}function displaySoftware(page){const startIndex=(page-1)*itemsPerPage;const endIndex=startIndex+itemsPerPage;const softwareToShow=allSoftware["slice"](startIndex,endIndex);const softwareList=document["getElementById"]("software-to-crack");softwareList["innerHTML"]="";if(softwareToShow["length"]===0){softwareList["innerHTML"]="<div class=\"cracking-error\">"+window["langManager"]["t"]("game.cracking.no_software")+"</div>";return}softwareToShow["forEach"](software=>{let softwareType=software["type"]["toLowerCase"]();let typeIcon="\uD83D\uDCC4";if(softwareType["includes"]("game")){typeIcon="\uD83C\uDFAE"}else{if(softwareType["includes"]("app")||softwareType["includes"]("application")){typeIcon="\uD83D\uDCF1"}else{if(softwareType["includes"]("os")){typeIcon="\uD83D\uDCBB"}else{if(softwareType["includes"]("utility")){typeIcon="\uD83D\uDD27"}}}}let difficultyText=window["langManager"]["t"]("game.cracking.difficulty_easy");if(software["difficulty"]>3){difficultyText=window["langManager"]["t"]("game.cracking.difficulty_medium")}if(software["difficulty"]>7){difficultyText=window["langManager"]["t"]("game.cracking.difficulty_hard")}const item=document["createElement"]("div");item["className"]="software-to-crack";item["innerHTML"]="\n                <div class=\"crack-info\">\n                    <div class=\"crack-name\">"+typeIcon+" "+software["name"]+"</div>\n                    <div class=\"crack-details\">\n                        <span>"+window["langManager"]["t"]("game.cracking.type")+": "+software["type"]+"</span>\n                        <span>"+window["langManager"]["t"]("game.cracking.difficulty")+": "+difficultyText+"</span>\n                        <span>"+window["langManager"]["t"]("game.cracking.size")+": "+software["size_gb"]+"GB</span>\n                    </div>\n                </div>\n                <button class=\"crack-button\" data-id=\""+software["id"]+"\" onclick=\"startCracking("+software["id"]+", "+software["difficulty"]+")\">"+window["langManager"]["t"]("game.cracking.start_button")+"</button>\n            ";softwareList["appendChild"](item)});const totalPages=Math["ceil"](allSoftware["length"]/itemsPerPage);const paginationContainer=tools["querySelector"](".cracking-tools-pagination");if(totalPages<=1){paginationContainer["style"]["display"]="none";return}let paginationHTML="\n            <button class=\"pagination-button\" onclick=\"changeCrackingPage("+Math["max"](1,currentPage-1)+")\" "+(currentPage===1?"disabled":"")+">\u2190</button>\n        ";for(let i=1;i<=totalPages;i++){paginationHTML+="\n                <button class=\"pagination-button "+(i===currentPage?"active":"")+"\" onclick=\"changeCrackingPage("+i+")\">"+i+"</button>\n            "}paginationHTML+="\n            <button class=\"pagination-button\" onclick=\"changeCrackingPage("+Math["min"](totalPages,currentPage+1)+")\" "+(currentPage===totalPages?"disabled":"")+">\u2192</button>\n            <span class=\"pagination-info\">"+window["langManager"]["t"]("game.cracking.page_info",{["current"]:currentPage,["total"]:totalPages})+"</span>\n        ";paginationContainer["innerHTML"]=paginationHTML;updateCrackButtons()}fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_crackable_software"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]&&Array["isArray"](data["software"])){allSoftware=data["software"];displaySoftware(currentPage)}else{const softwareList=document["getElementById"]("software-to-crack");softwareList["innerHTML"]="<div class=\"cracking-error\">"+window["langManager"]["t"]("game.cracking.no_software")+"</div>"}})["catch"](error=>{const softwareList=document["getElementById"]("software-to-crack");softwareList["innerHTML"]="<div class=\"cracking-error\">"+window["langManager"]["t"]("game.cracking.error_loading")+"</div>"})}function showUploadCenter(){const existingPanel=document["querySelector"](".upload-center-window");if(existingPanel){if(window["game"]){if(window["game"]["isWindowFocused"](existingPanel)){window["game"]["closeWindow"](existingPanel)}else{window["game"]["bringWindowToFront"](existingPanel)}}else{if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](existingPanel,()=>{return existingPanel["remove"]()})}else{existingPanel["remove"]()}}return}const uploadCenterWindow=document["createElement"]("div");uploadCenterWindow["className"]="window upload-center-window";uploadCenterWindow["style"]["top"]="10%";uploadCenterWindow["style"]["left"]="55%";uploadCenterWindow["style"]["width"]="850px";uploadCenterWindow["style"]["height"]="600px";uploadCenterWindow["style"]["zIndex"]=getNextZIndex();const titleBar=document["createElement"]("div");titleBar["className"]="window-title";const upBrand=document["createElement"]("div");upBrand["className"]="window-brand";upBrand["innerHTML"]="\n        <div class=\"window-brand-icon\">UL</div>\n        <div class=\"window-brand-text\">"+window["langManager"]["t"]("game.upload.center_title")+"</div>\n    ";titleBar["appendChild"](upBrand);uploadCenterWindow["appendChild"](titleBar);const uploadCenterWindowId="upload-center-"+Date["now"]();uploadCenterWindow["dataset"]["windowId"]=uploadCenterWindowId;const closeButton=document["createElement"]("button");closeButton["className"]="window-close";closeButton["textContent"]="\xD7";const closeButtonHandler=()=>{if(window["eventListenerManager"]){window["eventListenerManager"]["cleanup"](uploadCenterWindowId)}if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](uploadCenterWindow,()=>{uploadCenterWindow["remove"]()})}else{uploadCenterWindow["remove"]()}};if(window["eventListenerManager"]){window["eventListenerManager"]["add"](uploadCenterWindowId,closeButton,"click",closeButtonHandler)}else{closeButton["addEventListener"]("click",closeButtonHandler)}titleBar["appendChild"](closeButton);const contentContainer=document["createElement"]("div");contentContainer["className"]="window-content upload-center-content";uploadCenterWindow["appendChild"](contentContainer);const uploadCenterUI="\n        <div class=\"upload-center-container\">\n            <div class=\"upload-center-header\">\n                <div class=\"upload-center-info\">\n                    <div class=\"upload-center-title\">"+window["langManager"]["t"]("game.upload.center_title")+"</div>\n                    <div class=\"upload-center-subtitle\">"+window["langManager"]["t"]("game.upload.subtitle")+"</div>\n        </div>\n                <div class=\"upload-center-stats\">\n                    <div class=\"upload-center-stat\">\n                        <div class=\"upload-center-stat-label\">"+window["langManager"]["t"]("game.upload.status")+"</div>\n                        <div class=\"upload-center-stat-value online\">"+window["langManager"]["t"]("game.upload.online")+"</div>\n            </div>\n                    <div class=\"upload-center-stat\">\n                        <div class=\"upload-center-stat-label\">"+window["langManager"]["t"]("game.upload.connection")+"</div>\n                        <div class=\"upload-center-stat-value\">"+window["langManager"]["t"]("game.upload.p2p_network")+"</div>\n        </div>\n                </div>\n            </div>\n            <div class=\"upload-center-main\">\n                <div class=\"upload-center-files\">\n                    <div class=\"upload-center-section-header\">\n                        <h2>"+window["langManager"]["t"]("game.upload.available_files")+"</h2>\n                        <div class=\"upload-center-filters\">\n                            <select class=\"upload-center-filter\">\n                                <option value=\"all\" selected>"+window["langManager"]["t"]("game.upload.all_types")+"</option>\n                                <option value=\"game\">"+window["langManager"]["t"]("game.upload.games")+"</option>\n                                <option value=\"app\">"+window["langManager"]["t"]("game.upload.applications")+"</option>\n                                <option value=\"os\">"+window["langManager"]["t"]("game.upload.operating_systems")+"</option>\n                                <option value=\"utility\">"+window["langManager"]["t"]("game.upload.utilities")+"</option>\n                            </select>\n                            <select class=\"upload-center-sort\">\n                                <option value=\"name\">"+window["langManager"]["t"]("game.upload.sort_by_name")+"</option>\n                                <option value=\"size\" selected>"+window["langManager"]["t"]("game.upload.sort_by_size")+"</option>\n                                <option value=\"type\">"+window["langManager"]["t"]("game.upload.sort_by_type")+"</option>\n                            </select>\n                        </div>\n                    </div>\n                    <div class=\"upload-center-files-list\" id=\"software-to-upload\">\n                        <div class=\"upload-center-loading\">"+window["langManager"]["t"]("game.upload.loading_files")+"</div>\n                    </div>\n                    <div class=\"upload-center-pagination\" id=\"upload-pagination\"></div>\n                </div>\n                <div class=\"upload-center-sidebar\">\n                    <div class=\"upload-center-info-box\">\n                        <h3>"+window["langManager"]["t"]("game.upload.guidelines")+"</h3>\n                        <ul class=\"upload-center-guidelines\">\n                            <li>"+window["langManager"]["t"]("game.upload.guideline_1")+"</li>\n                            <li>"+window["langManager"]["t"]("game.upload.guideline_2")+"</li>\n                            <li>"+window["langManager"]["t"]("game.upload.guideline_3")+"</li>\n                        </ul>\n                    </div>\n                    <div class=\"upload-center-tracker\">\n                        <h3>"+window["langManager"]["t"]("game.upload.network_activity")+"</h3>\n                        <div class=\"upload-center-activity-graph\">\n                            <div class=\"upload-center-activity-bar\"></div>\n                            <div class=\"upload-center-activity-bar\"></div>\n                            <div class=\"upload-center-activity-bar\"></div>\n                            <div class=\"upload-center-activity-bar\"></div>\n                            <div class=\"upload-center-activity-bar\"></div>\n                            <div class=\"upload-center-activity-bar\"></div>\n                            <div class=\"upload-center-activity-bar\"></div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    ";contentContainer["innerHTML"]=uploadCenterUI;document["body"]["appendChild"](uploadCenterWindow);makeDraggable(uploadCenterWindow);makeResizable(uploadCenterWindow);if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](uploadCenterWindow)}WindowSizeManager["applyStoredSize"](uploadCenterWindow,"upload-center-window");WindowPositionManager["applyStoredPosition"](uploadCenterWindow,"upload-center-window");const filterSelect=uploadCenterWindow["querySelector"](".upload-center-filter");const sortSelect=uploadCenterWindow["querySelector"](".upload-center-sort");let filteredSoftware=[];let allSoftware=[];const filterChangeHandler=()=>{filterSoftware()};const sortChangeHandler=()=>{sortSoftware()};if(window["eventListenerManager"]){window["eventListenerManager"]["add"](uploadCenterWindowId,filterSelect,"change",filterChangeHandler);window["eventListenerManager"]["add"](uploadCenterWindowId,sortSelect,"change",sortChangeHandler)}else{filterSelect["addEventListener"]("change",filterChangeHandler);sortSelect["addEventListener"]("change",sortChangeHandler)}function filterSoftware(){const filterValue=filterSelect["value"];if(filterValue==="all"){filteredSoftware=[...allSoftware]}else{filteredSoftware=allSoftware["filter"](software=>{const softwareType=software["type"]["toLowerCase"]();return softwareType===filterValue||filterValue==="app"&&softwareType==="application"||softwareType["includes"](filterValue)})}sortSoftware()}function sortSoftware(){const sortValue=sortSelect["value"];switch(sortValue){case"name":filteredSoftware["sort"]((a,b)=>{return a["name"]["localeCompare"](b["name"])});break;case"size":filteredSoftware["sort"]((a,b)=>{return b["size_gb"]-a["size_gb"]});break;case"type":filteredSoftware["sort"]((a,b)=>{return a["type"]["localeCompare"](b["type"])});break}displaySoftware(currentPage)}function initActivityAnimation(){const bars=uploadCenterWindow["querySelectorAll"](".upload-center-activity-bar");bars["forEach"](bar=>{const randomHeight=Math["floor"](Math["random"]()*60)+20;bar["style"]["height"]=""+randomHeight+"%";setInterval(()=>{const newHeight=Math["floor"](Math["random"]()*60)+20;bar["style"]["height"]=""+newHeight+"%"},Math["floor"](Math["random"]()*3000)+1000)})}initActivityAnimation();const itemsPerPage=5;let currentPage=1;function displaySoftware(page){const startIndex=(page-1)*itemsPerPage;const endIndex=startIndex+itemsPerPage;const softwareToShow=filteredSoftware["slice"](startIndex,endIndex);const softwareList=document["getElementById"]("software-to-upload");softwareList["innerHTML"]="";if(softwareToShow["length"]===0){softwareList["innerHTML"]="<div class=\"upload-center-empty\">"+window["langManager"]["t"]("game.upload.no_software")+"</div>";document["getElementById"]("upload-pagination")["innerHTML"]="";return}softwareToShow["forEach"](software=>{let typeIcon;switch(software["type"]["toLowerCase"]()){case"game":typeIcon="<i class=\"upload-center-item-icon game\">\uD83C\uDFAE</i>";break;case"application":case"app":typeIcon="<i class=\"upload-center-item-icon app\">\uD83D\uDCCA</i>";break;case"utility":typeIcon="<i class=\"upload-center-item-icon utility\">\uD83D\uDEE0\uFE0F</i>";break;case"os":typeIcon="<i class=\"upload-center-item-icon os\">\uD83D\uDCBB</i>";break;default:typeIcon="<i class=\"upload-center-item-icon\">\uD83D\uDCE6</i>"}const item=document["createElement"]("div");item["className"]="upload-center-item";item["setAttribute"]("data-type",software["type"]["toLowerCase"]());item["innerHTML"]="\n                <div class=\"upload-center-item-header\">\n                    "+typeIcon+"\n                    <div class=\"upload-center-item-name\">"+software["name"]+"</div>\n                    <div class=\"upload-center-item-size\">"+software["size_gb"]+" GB</div>\n                    </div>\n                <div class=\"upload-center-item-details\">\n                    <div class=\"upload-center-item-type\">"+software["type"]+"</div>\n                    <div class=\"upload-center-item-info\">\n                        <span class=\"upload-center-item-peers\">"+window["langManager"]["t"]("game.upload.status")+": "+window["langManager"]["t"]("game.upload.ready")+"</span>\n                    </div>\n                </div>\n                <div class=\"upload-center-item-progress\">\n                    <div class=\"upload-center-progress-bar\"></div>\n                </div>\n                <div class=\"upload-center-item-controls\">\n                    <button class=\"upload-center-button\" onclick=\"startUpload("+software["id"]+")\">\n                        <span class=\"upload-center-button-icon\">\u25B2</span>\n                        "+window["langManager"]["t"]("game.upload.start_button")+"\n                    </button>\n                </div>\n            ";softwareList["appendChild"](item)});setupPagination(filteredSoftware["length"],page)}function setupPagination(totalItems,currentPage){const totalPages=Math["ceil"](totalItems/itemsPerPage);const paginationContainer=document["getElementById"]("upload-pagination");if(totalPages<=1){paginationContainer["innerHTML"]="";return}let paginationHTML="\n            <button class=\"pagination-button prev\" "+(currentPage===1?"disabled":"")+">\u2190</button>\n        ";for(let i=1;i<=totalPages;i++){paginationHTML+="\n                <button class=\"pagination-button "+(i===currentPage?"active":"")+"\" data-page=\""+i+"\">"+i+"</button>\n            "}paginationHTML+="\n            <button class=\"pagination-button next\" "+(currentPage===totalPages?"disabled":"")+">\u2192</button>\n            <span class=\"pagination-info\">"+window["langManager"]["t"]("game.upload.page_info",{["current"]:currentPage,["total"]:totalPages})+"</span>\n        ";paginationContainer["innerHTML"]=paginationHTML;const pageButtons=paginationContainer["querySelectorAll"](".pagination-button");pageButtons["forEach"](button=>{if(button["classList"]["contains"]("prev")){const prevHandler=()=>{if(currentPage>1){changeUploadPage(currentPage-1)}};if(window["eventListenerManager"]){window["eventListenerManager"]["add"](uploadCenterWindowId,button,"click",prevHandler)}else{button["addEventListener"]("click",prevHandler)}}else{if(button["classList"]["contains"]("next")){const nextHandler=()=>{if(currentPage<totalPages){changeUploadPage(currentPage+1)}};if(window["eventListenerManager"]){window["eventListenerManager"]["add"](uploadCenterWindowId,button,"click",nextHandler)}else{button["addEventListener"]("click",nextHandler)}}else{const pageNum=parseInt(button["getAttribute"]("data-page"));const pageHandler=()=>{return changeUploadPage(pageNum)};if(window["eventListenerManager"]){window["eventListenerManager"]["add"](uploadCenterWindowId,button,"click",pageHandler)}else{button["addEventListener"]("click",pageHandler)}}}})}fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_cracked_software"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]&&Array["isArray"](data["software"])){allSoftware=data["software"];filteredSoftware=[...allSoftware];displaySoftware(currentPage)}else{const softwareList=document["getElementById"]("software-to-upload");softwareList["innerHTML"]="<div class=\"upload-center-empty\">"+window["langManager"]["t"]("game.upload.no_software")+"</div>"}})["catch"](error=>{const softwareList=document["getElementById"]("software-to-upload");softwareList["innerHTML"]="<div class=\"upload-center-error\">"+window["langManager"]["t"]("game.upload.error_loading")+"</div>"});window["changeUploadPage"]=function(page){currentPage=page;displaySoftware(currentPage)}}function startUpload(id){const softwareItem=document["querySelector"](".upload-center-item button[onclick*=\"startUpload("+id+")\"]")["closest"](".upload-center-item");if(!softwareItem){return}const softwareName=softwareItem["querySelector"](".upload-center-item-name")["textContent"];const softwareType=softwareItem["querySelector"](".upload-center-item-type")["textContent"];const softwareSize=softwareItem["querySelector"](".upload-center-item-size")["textContent"];const typeIcon=softwareItem["querySelector"](".upload-center-item-icon")["outerHTML"];const uploadWindow=document["querySelector"](".upload-center-window");if(!uploadWindow){return}const uploadTrackerContent=document["createElement"]("div");uploadTrackerContent["className"]="upload-tracker-content";uploadTrackerContent["innerHTML"]="\n        <div class=\"upload-tracker-header\">\n            <div class=\"upload-tracker-title\">"+window["langManager"]["t"]("game.upload.active_upload")+"</div>\n            <div class=\"upload-tracker-subtitle\">"+window["langManager"]["t"]("game.upload.uploading_file")+"</div>\n        </div>\n        <div class=\"upload-tracker-main\">\n            <div class=\"upload-tracker-software\">\n                <div class=\"upload-tracker-software-header\">\n                    "+typeIcon+"\n                    <div class=\"upload-tracker-software-name\">"+softwareName+"</div>\n                </div>\n                <div class=\"upload-tracker-software-info\">\n                    <div class=\"upload-tracker-software-type\">"+softwareType+"</div>\n                    <div class=\"upload-tracker-software-size\">"+softwareSize+"</div>\n                </div>\n            </div>\n            <div class=\"upload-tracker-status\">\n                <div class=\"upload-tracker-status-text\">"+window["langManager"]["t"]("game.upload.starting")+"</div>\n                <div class=\"upload-tracker-peers\">"+window["langManager"]["t"]("game.upload.connecting_peers")+"</div>\n                <div class=\"upload-tracker-time\">"+window["langManager"]["t"]("game.upload.estimating_time")+"</div>\n            </div>\n            <div class=\"upload-tracker-progress-container\">\n                <div class=\"upload-tracker-progress\">\n                    <div class=\"upload-tracker-progress-bar\"></div>\n                </div>\n                <div class=\"upload-tracker-progress-percent\">0%</div>\n            </div>\n            <div class=\"upload-tracker-peers-graph\">\n                <div class=\"upload-tracker-peers-title\">"+window["langManager"]["t"]("game.upload.network_activity")+"</div>\n                <div class=\"upload-tracker-activity-graph\">\n                    <div class=\"upload-tracker-activity-bar\"></div>\n                    <div class=\"upload-tracker-activity-bar\"></div>\n                    <div class=\"upload-tracker-activity-bar\"></div>\n                    <div class=\"upload-tracker-activity-bar\"></div>\n                    <div class=\"upload-tracker-activity-bar\"></div>\n                    <div class=\"upload-tracker-activity-bar\"></div>\n                    <div class=\"upload-tracker-activity-bar\"></div>\n                </div>\n            </div>\n            <div class=\"upload-tracker-cancel\">\n                <button class=\"upload-tracker-cancel-button\">"+window["langManager"]["t"]("game.upload.cancel_button")+"</button>\n            </div>\n        </div>\n    ";const originalContent=uploadWindow["querySelector"](".upload-center-content");originalContent["style"]["display"]="none";uploadWindow["appendChild"](uploadTrackerContent);const titleBarCloseButton=uploadWindow["querySelector"](".window-close");const originalCloseHandler=()=>{return uploadWindow["remove"]()};const uploadCancelHandler=()=>{if(uploadTimeout){clearTimeout(uploadTimeout);uploadTimeout=null;window["game"]["displayEvent"]({["type"]:"danger",["message"]:window["langManager"]["t"]("game.upload.cancelled")});uploadTrackerContent["remove"]();originalContent["style"]["display"]="";document["querySelectorAll"](".upload-center-button")["forEach"](button=>{button["disabled"]=false;button["innerHTML"]="<span class=\"upload-center-button-icon\">\u25B2</span> "+window["langManager"]["t"]("game.upload.start_button")});titleBarCloseButton["removeEventListener"]("click",uploadCancelHandler);titleBarCloseButton["addEventListener"]("click",originalCloseHandler)}};titleBarCloseButton["removeEventListener"]("click",originalCloseHandler);titleBarCloseButton["addEventListener"]("click",uploadCancelHandler);const bars=uploadTrackerContent["querySelectorAll"](".upload-tracker-activity-bar");bars["forEach"](bar=>{const randomHeight=Math["floor"](Math["random"]()*60)+20;bar["style"]["height"]=""+randomHeight+"%";setInterval(()=>{const newHeight=Math["floor"](Math["random"]()*60)+20;bar["style"]["height"]=""+newHeight+"%"},Math["floor"](Math["random"]()*3000)+1000)});const cancelButton=uploadTrackerContent["querySelector"](".upload-tracker-cancel-button");cancelButton["addEventListener"]("click",()=>{if(uploadTimeout){clearTimeout(uploadTimeout);uploadTimeout=null;window["game"]["displayEvent"]({["type"]:"danger",["message"]:window["langManager"]["t"]("game.upload.cancelled")});uploadTrackerContent["remove"]();originalContent["style"]["display"]="";document["querySelectorAll"](".upload-center-button")["forEach"](button=>{button["disabled"]=false;button["innerHTML"]="<span class=\"upload-center-button-icon\">\u25B2</span> "+window["langManager"]["t"]("game.upload.start_button")})}});fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=upload_software&id="+id})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){const statusText=uploadTrackerContent["querySelector"](".upload-tracker-status-text");statusText["textContent"]=window["langManager"]["t"]("game.upload.in_progress");document["querySelectorAll"](".upload-center-button")["forEach"](button=>{button["disabled"]=true});const uploadTime=data["upload_time"]*1000;const startTime=Date["now"]();const endTime=startTime+uploadTime;window["game"]["writeToTerminal"](window["langManager"]["t"]("game.upload.terminal_starting",{["name"]:data["software"]["name"],["seconds"]:Math["round"](uploadTime/1000)}));const progressBar=uploadTrackerContent["querySelector"](".upload-tracker-progress-bar");const progressPercent=uploadTrackerContent["querySelector"](".upload-tracker-progress-percent");const timeRemaining=uploadTrackerContent["querySelector"](".upload-tracker-time");const peersText=uploadTrackerContent["querySelector"](".upload-tracker-peers");function updateProgress(){const currentTime=Date["now"]();const elapsedTime=currentTime-startTime;const progress=Math["min"](elapsedTime/uploadTime*100,100);const remainingTime=Math["max"](Math["round"]((uploadTime-elapsedTime)/1000),0);progressBar["style"]["width"]=""+progress+"%";progressPercent["textContent"]=""+Math["round"](progress)+"%";if(progress>0){const peers=Math["floor"](progress/10)+1;peersText["textContent"]=window["langManager"]["t"]("game.upload.connected_peers",{["peers"]:peers});const minutes=Math["floor"](remainingTime/60);const seconds=remainingTime%60;timeRemaining["textContent"]=window["langManager"]["t"]("game.upload.time_remaining",{["minutes"]:minutes,["seconds"]:seconds["toString"]()["padStart"](2,"0")})}if(currentTime<endTime){requestAnimationFrame(updateProgress)}}requestAnimationFrame(updateProgress);uploadTimeout=setTimeout(()=>{completeUpload(id,softwareItem,uploadTrackerContent,originalContent)},uploadTime)}else{window["game"]["writeToTerminal"](window["langManager"]["t"]("game.upload.fail_start",{["message"]:data["message"]}));uploadTrackerContent["remove"]();originalContent["style"]["display"]="";const titleBarCloseButton=uploadWindow["querySelector"](".window-close");if(titleBarCloseButton){const newCloseButton=titleBarCloseButton["cloneNode"](true);titleBarCloseButton["parentNode"]["replaceChild"](newCloseButton,titleBarCloseButton);newCloseButton["addEventListener"]("click",()=>{return uploadWindow["remove"]()})}}})["catch"](error=>{window["game"]["writeToTerminal"](window["langManager"]["t"]("game.upload.error_starting"));uploadTrackerContent["remove"]();originalContent["style"]["display"]="";const titleBarCloseButton=uploadWindow["querySelector"](".window-close");if(titleBarCloseButton){const newCloseButton=titleBarCloseButton["cloneNode"](true);titleBarCloseButton["parentNode"]["replaceChild"](newCloseButton,titleBarCloseButton);newCloseButton["addEventListener"]("click",()=>{return uploadWindow["remove"]()})}})}function completeUpload(id,softwareItem,uploadTrackerContent,originalContent){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=complete_upload&id="+id})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){if(window["soundManager"]){window["soundManager"]["playUpload"]()}window["game"]["displayEvent"]({["type"]:"success",["message"]:window["langManager"]["t"]("game.upload.success",{["name"]:data["message"]})});if(uploadTrackerContent){const statusText=uploadTrackerContent["querySelector"](".upload-tracker-status-text");statusText["textContent"]=window["langManager"]["t"]("game.upload.completed");statusText["className"]="upload-tracker-status-text success";const progressBar=uploadTrackerContent["querySelector"](".upload-tracker-progress-bar");progressBar["style"]["width"]="100%";progressBar["className"]="upload-tracker-progress-bar success";const progressPercent=uploadTrackerContent["querySelector"](".upload-tracker-progress-percent");progressPercent["textContent"]="100%";const timeRemaining=uploadTrackerContent["querySelector"](".upload-tracker-time");timeRemaining["textContent"]=window["langManager"]["t"]("game.upload.upload_completed");const cancelButton=uploadTrackerContent["querySelector"](".upload-tracker-cancel-button");cancelButton["textContent"]=window["langManager"]["t"]("game.upload.return_button");cancelButton["className"]="upload-tracker-return-button";const newButton=cancelButton["cloneNode"](true);cancelButton["parentNode"]["replaceChild"](newButton,cancelButton);newButton["addEventListener"]("click",()=>{const uploadWindow=document["querySelector"](".upload-center-window");if(uploadWindow){uploadWindow["remove"]()}showUploadCenter()})}const visitorsGained=parseInt(data["visitors_gained"])||0;const displayableVisitors=parseInt(data["displayable_visitors"])||0;if(visitorsGained>displayableVisitors){const capacityLimitText=displayableVisitors===0?window["langManager"]["t"]("game.upload.none"):displayableVisitors;window["game"]["writeToTerminal"](window["langManager"]["t"]("game.upload.visitors_gained_limited",{["gained"]:visitorsGained,["displayable"]:capacityLimitText}));window["game"]["displayEvent"]({["type"]:"warning",["message"]:window["langManager"]["t"]("game.events.server_at_capacity",{["overflow"]:visitorsGained-displayableVisitors})})}else{window["game"]["writeToTerminal"](window["langManager"]["t"]("game.upload.visitors_gained",{["gained"]:visitorsGained}))}window["game"]["displayEvent"]({["type"]:"info",["message"]:window["langManager"]["t"]("game.upload.storage_used",{["size"]:data["size_gb"]["toFixed"](1)})});if(uploadTimeout){clearTimeout(uploadTimeout);uploadTimeout=null}}else{window["game"]["displayEvent"]({["type"]:"danger",["message"]:window["langManager"]["t"]("game.upload.failed",{["message"]:data["message"]})});if(uploadTrackerContent){const statusText=uploadTrackerContent["querySelector"](".upload-tracker-status-text");statusText["textContent"]=window["langManager"]["t"]("game.upload.upload_failed");statusText["className"]="upload-tracker-status-text error";const timeRemaining=uploadTrackerContent["querySelector"](".upload-tracker-time");timeRemaining["textContent"]=data["message"]||window["langManager"]["t"]("game.upload.error_occurred");const progressBar=uploadTrackerContent["querySelector"](".upload-tracker-progress-bar");progressBar["className"]="upload-tracker-progress-bar error";const cancelButton=uploadTrackerContent["querySelector"](".upload-tracker-cancel-button");cancelButton["textContent"]=window["langManager"]["t"]("game.upload.return_button");cancelButton["className"]="upload-tracker-return-button";const newButton=cancelButton["cloneNode"](true);cancelButton["parentNode"]["replaceChild"](newButton,cancelButton);newButton["addEventListener"]("click",()=>{const uploadWindow=document["querySelector"](".upload-center-window");if(uploadWindow){uploadWindow["remove"]()}showUploadCenter()})}document["querySelectorAll"](".upload-center-button")["forEach"](button=>{button["disabled"]=false;button["innerHTML"]="<span class=\"upload-center-button-icon\">\u25B2</span> "+window["langManager"]["t"]("game.upload.start_button")})}})["catch"](error=>{window["game"]["displayEvent"]({["type"]:"danger",["message"]:window["langManager"]["t"]("game.upload.error_completing")});if(uploadTrackerContent){const statusText=uploadTrackerContent["querySelector"](".upload-tracker-status-text");statusText["textContent"]=window["langManager"]["t"]("game.upload.upload_failed");statusText["className"]="upload-tracker-status-text error";const timeRemaining=uploadTrackerContent["querySelector"](".upload-tracker-time");timeRemaining["textContent"]=window["langManager"]["t"]("game.upload.network_error");const progressBar=uploadTrackerContent["querySelector"](".upload-tracker-progress-bar");progressBar["className"]="upload-tracker-progress-bar error";const cancelButton=uploadTrackerContent["querySelector"](".upload-tracker-cancel-button");cancelButton["textContent"]=window["langManager"]["t"]("game.upload.return_button");cancelButton["className"]="upload-tracker-return-button";const newButton=cancelButton["cloneNode"](true);cancelButton["parentNode"]["replaceChild"](newButton,cancelButton);newButton["addEventListener"]("click",()=>{const uploadWindow=document["querySelector"](".upload-center-window");if(uploadWindow){uploadWindow["remove"]()}showUploadCenter()})}document["querySelectorAll"](".upload-center-button")["forEach"](button=>{button["disabled"]=false;button["innerHTML"]="<span class=\"upload-center-button-icon\">\u25B2</span> "+window["langManager"]["t"]("game.upload.start_button")})})}function addSoundEffectsToButtons(){document["addEventListener"]("click",e=>{const isButton=e["target"]["tagName"]==="BUTTON"||e["target"]["closest"]("button")||e["target"]["getAttribute"]("role")==="button"||e["target"]["classList"]["contains"]("btn")||e["target"]["classList"]["contains"]("button");if(isButton&&window["soundManager"]){window["soundManager"]["playClick"]()}})}document["addEventListener"]("DOMContentLoaded",()=>{addSoundEffectsToButtons()});function showUpgrades(){const existingPanel=document["querySelector"](".upgrades-window");if(existingPanel){if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](existingPanel,()=>{return existingPanel["remove"]()})}else{existingPanel["remove"]()}return}const upgrades=document["createElement"]("div");upgrades["className"]="window upgrades-window";upgrades["style"]["top"]="40%";upgrades["style"]["left"]="15%";upgrades["style"]["width"]="800px";upgrades["style"]["height"]="550px";upgrades["style"]["zIndex"]=getNextZIndex();upgrades["innerHTML"]="\n        <div class=\"window-title\">\n            <div class=\"window-brand\">\n                <div class=\"window-brand-icon\">UP</div>\n                <div class=\"window-brand-text\">"+window["langManager"]["t"]("game.upgrades.logo_text")+"</div>\n            </div>\n            <button class=\"window-close\">\xD7</button>\n        </div>\n        <div class=\"window-content upgrades-content\">\n            <div class=\"upgrades-container\">\n                <div class=\"upgrades-sidebar\">\n                <div id=\"upgrades-categories\"></div>\n                </div>\n                <div class=\"upgrades-main\">\n                <div id=\"upgrades-list\"></div>\n                    <div class=\"upgrades-pagination\"></div>\n            </div>\n        </div>\n        </div>\n    ";document["body"]["appendChild"](upgrades);makeDraggable(upgrades);makeResizable(upgrades);if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](upgrades)}WindowSizeManager["applyStoredSize"](upgrades,"upgrades-window");WindowPositionManager["applyStoredPosition"](upgrades,"upgrades-window");upgrades["querySelector"](".window-close")["addEventListener"]("click",()=>{if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](upgrades,()=>{return upgrades["remove"]()})}else{upgrades["remove"]()}});const itemsPerPage=5;let currentPage=1;let currentCategory="all";let allUpgrades={};let displayableUpgrades=[];function setupCategoryButtons(categories){const container=document["getElementById"]("upgrades-categories");container["innerHTML"]="<button class=\"category-button active\" data-category=\"all\">"+window["langManager"]["t"]("game.upgrades.all")+"</button>";for(const category in categories){if(categories[category]["length"]>0){const displayName=formatCategoryName(category);container["innerHTML"]+="<button class=\"category-button\" data-category=\""+category+"\">"+displayName+"</button>"}}container["querySelectorAll"](".category-button")["forEach"](button=>{button["addEventListener"]("click",()=>{container["querySelectorAll"](".category-button")["forEach"](btn=>{return btn["classList"]["remove"]("active")});button["classList"]["add"]("active");currentCategory=button["dataset"]["category"];currentPage=1;filterUpgradesByCategory();displayUpgrades(currentPage)})})}function formatCategoryName(category){const translationKey="game.upgrades.categories."+category;const translated=window["langManager"]["t"](translationKey);if(translated&&translated!==translationKey){return translated}return category["split"]("_")["map"](word=>{return word["charAt"](0)["toUpperCase"]()+word["slice"](1)})["join"](" ")}function filterUpgradesByCategory(){if(currentCategory==="all"){displayableUpgrades=[];for(const category in allUpgrades){displayableUpgrades=displayableUpgrades["concat"](allUpgrades[category]["map"](upgrade=>{return{...upgrade,["category"]:formatCategoryName(category)}}))}}else{displayableUpgrades=allUpgrades[currentCategory]["map"](upgrade=>{return{...upgrade,["category"]:formatCategoryName(currentCategory)}})}}function displayUpgrades(page){const upgradesList=document["getElementById"]("upgrades-list");upgradesList["innerHTML"]="";if(displayableUpgrades["length"]===0){upgradesList["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.upgrades.no_upgrades_category")+"</div>";document["querySelector"](".upgrades-pagination")["style"]["display"]="none";return}const startIndex=(page-1)*itemsPerPage;const endIndex=startIndex+itemsPerPage;const upgradesToShow=displayableUpgrades["slice"](startIndex,endIndex);let currentCategory="";upgradesToShow["forEach"](upgrade=>{if(currentCategory!==upgrade["category"]){currentCategory=upgrade["category"];const categoryHeader=document["createElement"]("div");categoryHeader["className"]="upgrade-category";categoryHeader["innerHTML"]="<h3>"+currentCategory+"</h3>";upgradesList["appendChild"](categoryHeader)}if(upgrade["type"]==="hosting"||upgrade["type"]==="dedicated_server"){const item=document["createElement"]("div");item["className"]="upgrade-item server-upgrade";if(upgrade["future"]){item["classList"]["add"]("future-upgrade")}const serviceName=upgrade["type"]==="hosting"?window["langManager"]["t"]("game.upgrades.shared_hosting"):window["langManager"]["t"]("game.upgrades.dedicated_server");const currentLevel=upgrade["level"];const nextLevel=currentLevel+1;const maxLevel=upgrade["max_level"];const baseCapacity=upgrade["type"]==="hosting"?100:1000;const baseSpeed=upgrade["type"]==="hosting"?10:100;const nextCapacity=baseCapacity*nextLevel;const nextSpeed=baseSpeed*nextLevel;const levelInfo=window["langManager"]["t"]("game.upgrades.level_info",{["current"]:currentLevel,["max"]:maxLevel});const description=window["langManager"]["t"]("game.upgrades.upgrade_description",{["level"]:nextLevel,["capacity"]:nextCapacity,["speed"]:nextSpeed});item["innerHTML"]="\n                    <div class=\"upgrade-service-info\">\n                        <div class=\"upgrade-name\">"+serviceName+"</div>\n                        <div class=\"upgrade-description\">"+description+"</div>\n                    </div>\n                    <div class=\"upgrade-level-info\">\n                        <div class=\"current-level\">"+levelInfo+"</div>\n                        <div class=\"upgrade-cost\">"+upgrade["cost"]+" "+window["langManager"]["t"]("game.upgrades.credits")+"</div>\n                        <button onclick=\"purchaseUpgrade("+upgrade["id"]+")\" "+(upgrade["available"]?"":"disabled")+">\n                            "+(upgrade["available"]?window["langManager"]["t"]("game.upgrades.upgrade_button"):window["langManager"]["t"]("game.upgrades.not_available"))+"\n                        </button>\n                    </div>\n                    "+(upgrade["future"]?"<div class=\"future-overlay\">"+window["langManager"]["t"]("game.upgrades.available_in",{["year"]:upgrade["release_year"]})+"</div>":"")+"\n                ";upgradesList["appendChild"](item)}else{const item=document["createElement"]("div");item["className"]="upgrade-item";if(upgrade["future"]){item["classList"]["add"]("future-upgrade")}let levelInfo="";if(upgrade["max_level"]>1){levelInfo=window["langManager"]["t"]("game.upgrades.level_suffix",{["level"]:upgrade["level"]+1,["max"]:upgrade["max_level"]})}item["innerHTML"]="\n                    <div class=\"upgrade-info\">\n                        <div class=\"upgrade-name\">"+upgrade["name"]+levelInfo+"</div>\n                        <div class=\"upgrade-description\">"+upgrade["description"]+"</div>\n                    </div>\n                    <div class=\"upgrade-cost\">"+upgrade["cost"]+" "+window["langManager"]["t"]("game.upgrades.credits")+"</div>\n                    <button onclick=\"purchaseUpgrade("+upgrade["id"]+")\" "+(upgrade["available"]?"":"disabled")+">\n                        "+(upgrade["available"]?window["langManager"]["t"]("game.upgrades.purchase_button"):window["langManager"]["t"]("game.upgrades.not_available"))+"\n                    </button>\n                    "+(upgrade["future"]?"<div class=\"future-overlay\">"+window["langManager"]["t"]("game.upgrades.available_in",{["year"]:upgrade["release_year"]})+"</div>":"")+"\n                ";upgradesList["appendChild"](item)}});const totalPages=Math["ceil"](displayableUpgrades["length"]/itemsPerPage);const paginationContainer=upgrades["querySelector"](".upgrades-pagination");if(totalPages<=1){paginationContainer["style"]["display"]="none";return}paginationContainer["style"]["display"]="flex";let paginationHTML="\n            <button class=\"pagination-button\" onclick=\"changeUpgradesPage("+Math["max"](1,currentPage-1)+")\" "+(currentPage===1?"disabled":"")+">\u2190</button>\n        ";for(let i=1;i<=totalPages;i++){paginationHTML+="\n                <button class=\"pagination-button "+(i===currentPage?"active":"")+"\" onclick=\"changeUpgradesPage("+i+")\">"+i+"</button>\n            "}paginationHTML+="\n            <button class=\"pagination-button\" onclick=\"changeUpgradesPage("+Math["min"](totalPages,currentPage+1)+")\" "+(currentPage===totalPages?"disabled":"")+">\u2192</button>\n            <span class=\"pagination-info\">"+window["langManager"]["t"]("game.upgrades.page_info",{["current"]:currentPage,["total"]:totalPages})+"</span>\n        ";paginationContainer["innerHTML"]=paginationHTML}fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_available_upgrades"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){allUpgrades=data["upgrades"];setupCategoryButtons(allUpgrades);filterUpgradesByCategory();displayUpgrades(currentPage)}else{const upgradesList=document["getElementById"]("upgrades-list");upgradesList["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.upgrades.no_upgrades")+"</div>"}})["catch"](error=>{const upgradesList=document["getElementById"]("upgrades-list");upgradesList["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.upgrades.error_loading")+"</div>"});window["changeUpgradesPage"]=function(page){currentPage=page;displayUpgrades(currentPage)}}function purchaseSoftware(id){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=purchase_software&id="+id})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){if(typeof window["game"]!=="undefined"&&window["game"]["displayEvent"]){window["game"]["displayEvent"]({["type"]:"success",["message"]:window["langManager"]["t"]("game.software.purchase_success",{["name"]:data["software"]["name"]})})}else{if(typeof writeToTerminal==="function"){writeToTerminal(window["langManager"]["t"]("game.software.purchase_success",{["name"]:data["software"]["name"]}))}}const currentMarketplace=document["querySelector"](".marketplace-window");if(currentMarketplace&&typeof window["refreshMarketplaceWindow"]==="function"){window["refreshMarketplaceWindow"]()}}else{if(typeof window["game"]!=="undefined"&&window["game"]["displayEvent"]){window["game"]["displayEvent"]({["type"]:"warning",["message"]:data["message"]==="Insufficient credits"?window["langManager"]["t"]("game.software.insufficient_credits"):data["message"]||"Purchase failed"})}else{const warningMsg=data["message"]==="Insufficient credits"?window["langManager"]["t"]("game.software.insufficient_credits"):data["message"]||"Purchase failed";if(typeof writeToTerminal==="function"){writeToTerminal(warningMsg)}}}})}let crackingInProgress=false;let softwareCooldowns={};window["completeCracking"]=async function(id){try{const response=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=crack_software&id="+id});const data=await response["json"]();if(data["success"]){window["game"]["displayEvent"]({["type"]:"success",["message"]:window["langManager"]["t"]("game.minigame.success_cracked",{["name"]:data["software"]["name"]})});crackingInProgress=false;updateCrackButtons();showCrackingTools();if(window["soundManager"]){window["soundManager"]["playUpload"]()}}else{window["game"]["displayEvent"]({["type"]:"warning",["message"]:window["langManager"]["t"]("game.minigame.failed_crack",{["message"]:data["message"]})});crackingInProgress=false;updateCrackButtons()}}catch(error){window["game"]["writeToTerminal"](window["langManager"]["t"]("game.minigame.error_occurred"));crackingInProgress=false;updateCrackButtons()}};function startCracking(id,difficulty){if(crackingInProgress){window["game"]["writeToTerminal"](window["langManager"]["t"]("game.cracking.operation_in_progress"));return}if(softwareCooldowns[id]){const remainingTime=Math["ceil"]((softwareCooldowns[id]-Date["now"]())/1000);if(remainingTime>0){window["game"]["writeToTerminal"](window["langManager"]["t"]("game.cracking.cooldown_message",{["seconds"]:remainingTime}));return}else{delete softwareCooldowns[id];updateCrackButtons()}}crackingInProgress=true;updateCrackButtons();fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_cracking_game&id="+id})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){const hasAutoCrack=data["hasAutoCrack"]||false;if(difficulty===1&&hasAutoCrack){window["game"]["writeToTerminal"]("\uD83E\uDD16 Auto-Crack Tool: Stage 1 otomatik olarak tamamland\u0131!");setTimeout(()=>{if(typeof completeCracking==="function"){completeCracking(id)}else{crackingInProgress=false;updateCrackButtons()}},1500);return}const softwareName=data["software"]?data["software"]["name"]:"Unknown Software";const crackSystem=new CrackingSystemV2(id,difficulty,softwareName,hasAutoCrack);crackSystem["show"]()}else{crackingInProgress=false;updateCrackButtons();window["game"]["writeToTerminal"](window["langManager"]["t"]("game.cracking.failed_start",{["message"]:data["message"]||window["langManager"]["t"]("game.cracking.not_available")}))}})["catch"](error=>{crackingInProgress=false;updateCrackButtons();window["game"]["writeToTerminal"](window["langManager"]["t"]("game.cracking.error_starting"))})}function updateCrackButtons(){document["querySelectorAll"](".crack-button")["forEach"](button=>{const softwareId=button["getAttribute"]("data-id");if(crackingInProgress){button["disabled"]=true;button["innerHTML"]=window["langManager"]["t"]("game.cracking.locked")}else{if(softwareCooldowns[softwareId]){const remainingTime=Math["ceil"]((softwareCooldowns[softwareId]-Date["now"]())/1000);if(remainingTime>0){button["disabled"]=true;button["innerHTML"]=window["langManager"]["t"]("game.cracking.seconds_remaining",{["seconds"]:remainingTime})}else{delete softwareCooldowns[softwareId];button["disabled"]=false;button["innerHTML"]=window["langManager"]["t"]("game.cracking.start_button")}}else{button["disabled"]=false;button["innerHTML"]=window["langManager"]["t"]("game.cracking.start_button")}}})}function updateCooldowns(){if(Object["keys"](softwareCooldowns)["length"]>0){updateCrackButtons();setTimeout(updateCooldowns,1000)}}function purchaseUpgrade(id){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=purchase_upgrade&id="+id})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){window["game"]["displayEvent"]({["type"]:"success",["message"]:window["langManager"]["t"]("game.upgrades.purchase_success",{["name"]:data["upgrade"]["name"]})});if(window["miningStatus"]){delete window["miningStatus"]}const existingPanel=document["querySelector"](".upgrades-window");if(existingPanel){const rect=existingPanel["getBoundingClientRect"]();const windowState={["left"]:existingPanel["style"]["left"]||"15%",["top"]:existingPanel["style"]["top"]||"40%",["width"]:Math["round"](rect["width"]),["height"]:Math["round"](rect["height"])};WindowSizeManager["saveWindowSize"]("upgrades-window",windowState["width"],windowState["height"]);existingPanel["remove"]();setTimeout(()=>{showUpgrades();const newPanel=document["querySelector"](".upgrades-window");if(newPanel){newPanel["style"]["left"]=windowState["left"];newPanel["style"]["top"]=windowState["top"]}},10)}}else{window["game"]["displayEvent"]({["type"]:"warning",["message"]:window["langManager"]["t"]("game.upgrades.purchase_failed",{["message"]:data["message"]})})}})["catch"](error=>{window["game"]["displayEvent"]({["type"]:"danger",["message"]:window["langManager"]["t"]("game.upgrades.error_purchasing")})})}function showStats(){game["showStats"]()}function gameCancelled(softwareId){crackingInProgress=false;const cooldownTime=30*1000;softwareCooldowns[softwareId]=Date["now"]()+cooldownTime;updateCrackButtons();updateCooldowns();window["game"]["writeToTerminal"](window["langManager"]["t"]("game.cracking.operation_cancelled",{["seconds"]:30}));const currentTools=document["querySelector"](".cracking-tools-window");if(currentTools){const rect=currentTools["getBoundingClientRect"]();const windowState={["left"]:currentTools["style"]["left"]||"58%",["top"]:currentTools["style"]["top"]||"40%",["width"]:Math["round"](rect["width"]),["height"]:Math["round"](rect["height"])};WindowSizeManager["saveWindowSize"]("cracking-tools-window",windowState["width"],windowState["height"]);currentTools["remove"]();setTimeout(()=>{showCrackingTools();const newTools=document["querySelector"](".cracking-tools-window");if(newTools){newTools["style"]["left"]=windowState["left"];newTools["style"]["top"]=windowState["top"]}},10)}}function gameFailedTryAgain(softwareId){crackingInProgress=false;const cooldownTime=10*1000;softwareCooldowns[softwareId]=Date["now"]()+cooldownTime;updateCrackButtons();updateCooldowns();window["game"]["writeToTerminal"](window["langManager"]["t"]("game.cracking.attempt_failed",{["seconds"]:10}));const currentTools=document["querySelector"](".cracking-tools-window");if(currentTools){const rect=currentTools["getBoundingClientRect"]();const windowState={["left"]:currentTools["style"]["left"]||"58%",["top"]:currentTools["style"]["top"]||"40%",["width"]:Math["round"](rect["width"]),["height"]:Math["round"](rect["height"])};WindowSizeManager["saveWindowSize"]("cracking-tools-window",windowState["width"],windowState["height"]);currentTools["remove"]();setTimeout(()=>{showCrackingTools();const newTools=document["querySelector"](".cracking-tools-window");if(newTools){newTools["style"]["left"]=windowState["left"];newTools["style"]["top"]=windowState["top"]}},10)}}function showAdsPanel(){const existingPanel=document["querySelector"](".ads-panel-window");if(existingPanel){if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](existingPanel,()=>{return existingPanel["remove"]()})}else{existingPanel["remove"]()}return}let currentActiveTab="pending";const panelWindow=document["createElement"]("div");panelWindow["className"]="window ads-panel-window";panelWindow["style"]["top"]="30%";panelWindow["style"]["left"]="13%";panelWindow["style"]["width"]="750px";panelWindow["style"]["height"]="500px";panelWindow["style"]["zIndex"]=getNextZIndex();panelWindow["id"]="ads-panel-window";const titleBar=document["createElement"]("div");titleBar["className"]="window-title";const adBrand=document["createElement"]("div");adBrand["className"]="window-brand";adBrand["innerHTML"]="\n        <div class=\"window-brand-icon\">AD</div>\n        <div class=\"window-brand-text\">"+window["langManager"]["t"]("game.ads.title")+"</div>\n    ";titleBar["appendChild"](adBrand);panelWindow["appendChild"](titleBar);const closeButton=document["createElement"]("button");closeButton["className"]="window-close";closeButton["textContent"]="\xD7";closeButton["addEventListener"]("click",()=>{if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](panelWindow,()=>{return panelWindow["remove"]()})}else{panelWindow["remove"]()}});titleBar["appendChild"](closeButton);const contentContainer=document["createElement"]("div");contentContainer["className"]="window-content ads-content";panelWindow["appendChild"](contentContainer);const tabMenu=document["createElement"]("div");tabMenu["className"]="tab-menu";contentContainer["appendChild"](tabMenu);const tabContent=document["createElement"]("div");tabContent["className"]="tab-content";contentContainer["appendChild"](tabContent);const tabs=[{["id"]:"pending",["label"]:window["langManager"]["t"]("game.ads.pending_offers")},{["id"]:"active",["label"]:window["langManager"]["t"]("game.ads.active_campaigns")},{["id"]:"completed",["label"]:window["langManager"]["t"]("game.ads.completed_campaigns")}];tabs["forEach"](tab=>{const tabButton=document["createElement"]("button");tabButton["className"]="tab-button";tabButton["dataset"]["tabId"]=tab["id"];tabButton["textContent"]=tab["label"];tabButton["addEventListener"]("click",()=>{return selectAdTab(tab["id"])});tabMenu["appendChild"](tabButton)});function selectAdTab(tabId){const allButtons=tabMenu["querySelectorAll"](".tab-button");allButtons["forEach"](button=>{return button["classList"]["remove"]("active")});const selectedButton=tabMenu["querySelector"](".tab-button[data-tab-id=\""+tabId+"\"]");if(selectedButton){selectedButton["classList"]["add"]("active")}currentActiveTab=tabId;loadTabContent(tabId)}function loadTabContent(tabId){tabContent["innerHTML"]="";const loadingDiv=document["createElement"]("div");loadingDiv["className"]="loading-message";loadingDiv["textContent"]=window["langManager"]["t"]("game.ads.loading");tabContent["appendChild"](loadingDiv);fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_ads&type="+tabId})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){renderAdContent(tabId,data["ads"])}else{tabContent["innerHTML"]="<div class=\"error-message\">"+(data["message"]||window["langManager"]["t"]("game.ads.error_loading"))+"</div>"}})["catch"](error=>{tabContent["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.ads.failed_to_load")+"</div>"})}function refreshAdsPanelContent(){if(!document["getElementById"]("ads-panel-window")){return}fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_ads&type="+currentActiveTab})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){renderAdContent(currentActiveTab,data["ads"])}})["catch"](error=>{})}if(window["game"]){const originalUpdateGameState=window["game"]["updateGameState"];window["game"]["updateGameState"]=async function(){await originalUpdateGameState["call"](window["game"]);if(document["getElementById"]("ads-panel-window")){refreshAdsPanelContent()}};closeButton["addEventListener"]("click",()=>{window["game"]["updateGameState"]=originalUpdateGameState})}function renderAdContent(tabId,ads){tabContent["innerHTML"]="";if(!ads||ads["length"]===0){const emptyMessage=document["createElement"]("div");emptyMessage["className"]="empty-message";if(tabId==="pending"){emptyMessage["textContent"]=window["langManager"]["t"]("game.ads.no_pending_offers");const nextOfferInfo=document["createElement"]("div");nextOfferInfo["className"]="next-offer-info";tabContent["appendChild"](nextOfferInfo);fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_ads&type=pending"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]&&data["next_offer_in_minutes"]){const minutes=parseInt(data["next_offer_in_minutes"]);if(minutes>0){nextOfferInfo["innerHTML"]="<p>"+window["langManager"]["t"]("game.ads.next_offer",{["minutes"]:minutes,["plural"]:""})+"</p>"}}})["catch"](error=>{})}else{if(tabId==="active"){emptyMessage["textContent"]=window["langManager"]["t"]("game.ads.no_active_campaigns")}else{emptyMessage["textContent"]=window["langManager"]["t"]("game.ads.no_completed_campaigns")}}tabContent["appendChild"](emptyMessage);return}const adList=document["createElement"]("div");adList["className"]="ad-list";tabContent["appendChild"](adList);ads["forEach"](ad=>{const adCard=document["createElement"]("div");adCard["className"]="ad-card";if(ad["type"]==="banner"){adCard["classList"]["add"]("ad-type-banner")}else{if(ad["type"]==="popup"){adCard["classList"]["add"]("ad-type-popup")}else{if(ad["type"]==="misleading"){adCard["classList"]["add"]("ad-type-misleading")}}}const adTitle=document["createElement"]("div");adTitle["className"]="ad-title";adTitle["textContent"]=ad["name"];adCard["appendChild"](adTitle);const adTypeBadge=document["createElement"]("span");adTypeBadge["className"]="ad-type-badge";if(ad["type"]==="banner"){adTypeBadge["textContent"]=window["langManager"]["t"]("game.ads.type_banner");adTypeBadge["classList"]["add"]("type-banner")}else{if(ad["type"]==="popup"){adTypeBadge["textContent"]=window["langManager"]["t"]("game.ads.type_popup");adTypeBadge["classList"]["add"]("type-popup")}else{if(ad["type"]==="misleading"){adTypeBadge["textContent"]=window["langManager"]["t"]("game.ads.type_misleading");adTypeBadge["classList"]["add"]("type-misleading")}}}adTitle["appendChild"](adTypeBadge);const adDescription=document["createElement"]("div");adDescription["className"]="ad-description";adDescription["textContent"]=ad["description"];adCard["appendChild"](adDescription);const adDetails=document["createElement"]("div");adDetails["className"]="ad-details";adCard["appendChild"](adDetails);const detailList=document["createElement"]("ul");adDetails["appendChild"](detailList);if(tabId==="pending"){const impressionsItem=document["createElement"]("li");impressionsItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.required_impressions")+":</strong> "+ad["impression_count"]["toLocaleString"]();detailList["appendChild"](impressionsItem);const cpiItem=document["createElement"]("li");cpiItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.credit_per_impression")+":</strong> "+ad["credit_per_impression"]["toFixed"](3);detailList["appendChild"](cpiItem);const totalItem=document["createElement"]("li");totalItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.total_credits")+":</strong> "+(ad["impression_count"]*ad["credit_per_impression"])["toFixed"](2);detailList["appendChild"](totalItem);const durationItem=document["createElement"]("li");durationItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.duration")+":</strong> "+window["langManager"]["t"]("game.ads.months",{["count"]:ad["completion_months"],["plural"]:""});detailList["appendChild"](durationItem);const expiresAtItem=document["createElement"]("li");try{let expiresText=window["langManager"]["t"]("game.ads.soon");if(ad["remaining_minutes"]!==undefined){const minutes=parseInt(ad["remaining_minutes"]);if(minutes<=0){expiresText=window["langManager"]["t"]("game.ads.any_moment")}else{if(minutes===1){expiresText=window["langManager"]["t"]("game.ads.one_minute")}else{expiresText=window["langManager"]["t"]("game.ads.minutes_left",{["minutes"]:minutes})}}}else{if(ad["expires_at"]&&ad["created_at"]){const createdDate=new Date(ad["created_at"]["replace"](" ","T"));const expiresDate=new Date(ad["expires_at"]["replace"](" ","T"));const now=new Date;if(!isNaN(createdDate["getTime"]())&&!isNaN(expiresDate["getTime"]())){const totalDuration=expiresDate["getTime"]()-createdDate["getTime"]();const elapsedTime=now["getTime"]()-createdDate["getTime"]();const remainingTime=totalDuration-elapsedTime;const remainingMinutes=Math["max"](0,Math["floor"](remainingTime/60000));if(remainingMinutes<=0){expiresText=window["langManager"]["t"]("game.ads.any_moment")}else{if(remainingMinutes===1){expiresText=window["langManager"]["t"]("game.ads.one_minute")}else{expiresText=window["langManager"]["t"]("game.ads.minutes_left",{["minutes"]:remainingMinutes})}}}}}expiresAtItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.expires")+":</strong> "+expiresText}catch(error){expiresAtItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.expires")+":</strong> "+window["langManager"]["t"]("game.ads.soon")}detailList["appendChild"](expiresAtItem);const satisfactionItem=document["createElement"]("li");if(ad["visitor_satisfaction_effect"]===0){satisfactionItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.visitor_satisfaction")+":</strong> "+window["langManager"]["t"]("game.ads.no_effect")}else{satisfactionItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.visitor_satisfaction")+":</strong> "+(ad["visitor_satisfaction_effect"]<0?"":"+")+(ad["visitor_satisfaction_effect"]*100)["toFixed"](1)+"%"}detailList["appendChild"](satisfactionItem);const buttonContainer=document["createElement"]("div");buttonContainer["className"]="ad-buttons";adCard["appendChild"](buttonContainer);const acceptButton=document["createElement"]("button");acceptButton["className"]="ad-action-button accept-ad";acceptButton["textContent"]=window["langManager"]["t"]("game.ads.accept_offer");acceptButton["addEventListener"]("click",()=>{return acceptAdOffer(ad["id"],tabContent)});buttonContainer["appendChild"](acceptButton);const rejectButton=document["createElement"]("button");rejectButton["className"]="ad-action-button reject-ad";rejectButton["textContent"]=window["langManager"]["t"]("game.ads.reject_offer");rejectButton["addEventListener"]("click",()=>{return rejectAdOffer(ad["id"],tabContent)});buttonContainer["appendChild"](rejectButton)}else{if(tabId==="active"){const progressContainer=document["createElement"]("div");progressContainer["className"]="ad-progress-container";adCard["appendChild"](progressContainer);const progressBar=document["createElement"]("div");progressBar["className"]="ad-progress-bar";const progressPercent=ad["current_impressions"]/ad["impression_count"]*100;progressBar["style"]["width"]=""+progressPercent+"%";progressContainer["appendChild"](progressBar);const progressText=document["createElement"]("div");progressText["className"]="ad-progress-text";progressText["textContent"]=""+ad["current_impressions"]["toLocaleString"]()+" / "+ad["impression_count"]["toLocaleString"]()+" "+window["langManager"]["t"]("game.ads.impressions")+" ("+progressPercent["toFixed"](1)+"%)";adCard["appendChild"](progressText);const impressionsItem=document["createElement"]("li");impressionsItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.remaining_impressions")+":</strong> "+(ad["impression_count"]-ad["current_impressions"])["toLocaleString"]();detailList["appendChild"](impressionsItem);const cpiItem=document["createElement"]("li");cpiItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.credit_per_impression")+":</strong> "+ad["credit_per_impression"]["toFixed"](3);detailList["appendChild"](cpiItem);const earnedItem=document["createElement"]("li");earnedItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.credits_earned")+":</strong> "+(ad["current_impressions"]*ad["credit_per_impression"])["toFixed"](2);detailList["appendChild"](earnedItem);const endDateItem=document["createElement"]("li");endDateItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.end_date")+":</strong> "+ad["end_month"]+"/"+ad["end_year"];detailList["appendChild"](endDateItem);const spacer=document["createElement"]("div");spacer["style"]["height"]="15px";adCard["appendChild"](spacer);const buttonContainer=document["createElement"]("div");buttonContainer["className"]="ad-buttons";adCard["appendChild"](buttonContainer);const cancelButton=document["createElement"]("button");cancelButton["className"]="ad-action-button cancel-ad";cancelButton["textContent"]=window["langManager"]["t"]("game.ads.cancel_campaign");cancelButton["addEventListener"]("click",()=>{return cancelAdCampaign(ad["id"],tabContent)});buttonContainer["appendChild"](cancelButton)}else{if(tabId==="completed"){const impressionsItem=document["createElement"]("li");impressionsItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.total_impressions")+":</strong> "+ad["impression_count"]["toLocaleString"]();detailList["appendChild"](impressionsItem);const cpiItem=document["createElement"]("li");cpiItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.credit_per_impression")+":</strong> "+ad["credit_per_impression"]["toFixed"](3);detailList["appendChild"](cpiItem);const totalItem=document["createElement"]("li");totalItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.total_credits_earned")+":</strong> "+ad["total_credit"]["toFixed"](2);detailList["appendChild"](totalItem);const completedItem=document["createElement"]("li");completedItem["innerHTML"]="<strong>"+window["langManager"]["t"]("game.ads.completed")+":</strong> "+new Date(ad["completed_at"]||ad["updated_at"]||ad["created_at"])["toLocaleDateString"]();detailList["appendChild"](completedItem)}}}adList["appendChild"](adCard)})}function acceptAdOffer(adId,container){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=accept_ad_offer&id="+adId})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){container["innerHTML"]="<div class=\"success-message\">"+data["message"]+"</div>";setTimeout(()=>{selectAdTab("active")},1500)}else{container["innerHTML"]="<div class=\"error-message\">"+(data["message"]||window["langManager"]["t"]("game.ads.accept_offer_failed"))+"</div>"}})["catch"](error=>{container["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("errors.internal_error")+"</div>"})}function rejectAdOffer(adId,container){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=reject_ad_offer&id="+adId})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){container["innerHTML"]="<div class=\"success-message\">"+data["message"]+"</div>";setTimeout(()=>{selectAdTab("pending")},1500)}else{container["innerHTML"]="<div class=\"error-message\">"+(data["message"]||window["langManager"]["t"]("game.ads.reject_offer_failed"))+"</div>"}})["catch"](error=>{container["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("errors.internal_error")+"</div>"})}function cancelAdCampaign(adId,container){let adName=window["langManager"]["t"]("game.ads.default_campaign_name");const adCard=container["closest"](".ad-card");if(adCard){const titleElement=adCard["querySelector"](".ad-title-text");if(titleElement){adName=titleElement["textContent"]}}fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=calculate_cancel_penalty&id="+adId})["then"](response=>{if(!response["ok"]){throw new Error("HTTP error! Status: "+response["status"])}return response["json"]()})["then"](data=>{if(data["success"]){const confirmationBox=document["createElement"]("div");confirmationBox["className"]="confirmation-popup";confirmationBox["innerHTML"]="\n                    <div class=\"confirmation-content\">\n                        <h3>"+window["langManager"]["t"]("game.ads.campaign_cancel_confirmation")+"</h3>\n                        <p>"+window["langManager"]["t"]("game.ads.campaign_cancel_confirm_message")["replace"]("{name}",adName)+"</p>\n                        <p class=\"warning-text\">"+window["langManager"]["t"]("game.ads.cancel_penalty")+": "+data["penalty"]["toFixed"](2)+" "+window["langManager"]["t"]("game.marketplace.credits")+"</p>\n                        <div class=\"confirmation-buttons\">\n                            <button class=\"confirm-yes\">"+window["langManager"]["t"]("game.ads.yes_cancel")+"</button>\n                            <button class=\"confirm-no\">"+window["langManager"]["t"]("game.ads.no_cancel")+"</button>\n                        </div>\n                    </div>\n                ";document["body"]["appendChild"](confirmationBox);confirmationBox["querySelector"](".confirm-yes")["addEventListener"]("click",function(){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=cancel_ad_campaign&id="+adId})["then"](response=>{if(!response["ok"]){throw new Error("HTTP error! Status: "+response["status"])}return response["json"]()})["then"](cancelData=>{if(cancelData["success"]){container["innerHTML"]="<div class=\"success-message\">"+window["langManager"]["t"]("game.ads.campaign_cancelled_success")+"</div>";setTimeout(()=>{selectAdTab("active")},1500);window["game"]["updateGameState"]()}else{container["innerHTML"]="<div class=\"error-message\">"+(cancelData["message"]||window["langManager"]["t"]("game.ads.campaign_cancel_failed"))+"</div>"}})["catch"](error=>{container["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("errors.internal_error")+"</div>"});document["body"]["removeChild"](confirmationBox)});confirmationBox["querySelector"](".confirm-no")["addEventListener"]("click",function(){document["body"]["removeChild"](confirmationBox)})}else{container["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.ads.penalty_calculation_error")+"</div>"}})["catch"](error=>{container["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("errors.internal_error")+"</div>"})}selectAdTab("pending");makeDraggable(panelWindow);makeResizable(panelWindow);WindowSizeManager["applyStoredSize"](panelWindow,"ads-panel-window");document["body"]["appendChild"](panelWindow);if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](panelWindow)}}function showWebsiteSimulation(){const existingPanel=document["querySelector"](".website-simulation-window");if(existingPanel){if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](existingPanel,()=>{return existingPanel["remove"]()})}else{existingPanel["remove"]()}return}const websiteWindow=document["createElement"]("div");websiteWindow["className"]="window website-simulation-window";websiteWindow["style"]["top"]="33%";websiteWindow["style"]["left"]="33%";websiteWindow["style"]["width"]="800px";websiteWindow["style"]["height"]="600px";websiteWindow["style"]["zIndex"]=getNextZIndex();const titleBar=document["createElement"]("div");titleBar["className"]="window-title";titleBar["innerHTML"]="\n        <div class=\"window-brand\">\n            <div class=\"window-brand-icon\">WB</div>\n            <div class=\"window-brand-text\">"+(window["langManager"]&&window["langManager"]["t"]("game.search.title")||"OdysseySearch")+"</div>\n        </div>\n    ";const closeButton=document["createElement"]("button");closeButton["className"]="window-close";closeButton["textContent"]="\xD7";closeButton["addEventListener"]("click",()=>{if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](websiteWindow,()=>{return websiteWindow["remove"]()})}else{websiteWindow["remove"]()}});titleBar["appendChild"](closeButton);websiteWindow["appendChild"](titleBar);const contentContainer=document["createElement"]("div");contentContainer["className"]="window-content website-content";websiteWindow["appendChild"](contentContainer);showSearchEngine(contentContainer,titleBar);document["body"]["appendChild"](websiteWindow);makeDraggable(websiteWindow);makeResizable(websiteWindow);if(window["windowAnimator"]){window["windowAnimator"]["animateOpen"](websiteWindow)}WindowSizeManager["applyStoredSize"](websiteWindow,"website-simulation-window")}function showSearchEngine(container,titleBar){const loadingDiv=document["createElement"]("div");loadingDiv["className"]="loading-message";loadingDiv["textContent"]=window["langManager"]["t"]("game.common.loading")||"Loading...";container["innerHTML"]="";container["appendChild"](loadingDiv);titleBar["innerHTML"]="\n        <div class=\"window-brand\">\n            <div class=\"window-brand-icon\">WB</div>\n            <div class=\"window-brand-text\">"+(window["langManager"]&&window["langManager"]["t"]("game.search.title")||"OdysseySearch")+"</div>\n        </div>\n    ";const closeButton=titleBar["querySelector"](".window-close");if(!closeButton){const newCloseButton=document["createElement"]("button");newCloseButton["className"]="window-close";newCloseButton["textContent"]="\xD7";newCloseButton["addEventListener"]("click",()=>{const websiteWindow=document["querySelector"](".website-simulation-window");if(websiteWindow){if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](websiteWindow,()=>{return websiteWindow["remove"]()})}else{websiteWindow["remove"]()}}});titleBar["appendChild"](newCloseButton)}fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_competitor_rankings"})["then"](response=>{return response["json"]()})["then"](data=>{container["innerHTML"]="";if(!data["success"]){container["innerHTML"]="<div class=\"error-message\">"+(window["langManager"]["t"]("game.common.error")||"Error loading data")+"</div>";return}const competitors=data["rankings"];const playerRank=data["player_rank"];const searchEngine=document["createElement"]("div");searchEngine["className"]="search-engine";const logo=document["createElement"]("div");logo["className"]="search-logo";logo["innerHTML"]="<span class=\"search-logo-text\">"+(window["langManager"]["t"]("game.search.title")||"OdysseySearch")+"</span>";searchEngine["appendChild"](logo);const searchBox=document["createElement"]("div");searchBox["className"]="search-box";searchBox["innerHTML"]="\n            <input type=\"text\" class=\"search-input\" value=\""+(window["langManager"]["t"]("game.search.default_query")||"torrent site")+"\" />\n            <button class=\"search-button\">"+(window["langManager"]["t"]("game.search.search_button")||"Ara")+"</button>\n        ";searchEngine["appendChild"](searchBox);const searchResults=document["createElement"]("div");searchResults["className"]="search-results";let isDevMode=false;try{fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_game_state"})["then"](r=>{return r["json"]()})["then"](d=>{if(d&&d["success"]&&d["state"]&&(d["state"]["devmode_active"]==1||d["state"]["devmode_active"]===true)){isDevMode=true}})["catch"](()=>{})}catch(e){}const resultStats=document["createElement"]("div");resultStats["className"]="result-stats";const randomResults=Math["floor"](Math["random"]()*10)+1+"."+Math["floor"](Math["random"]()*100)+"0.000";const searchTime=(Math["random"]()*0.5+0.1)["toFixed"](2);resultStats["textContent"]=window["langManager"]["t"]("game.search.result_stats",{["results"]:randomResults,["time"]:searchTime})||"Yakla\u015F\u0131k "+randomResults+" sonu\xE7 bulundu ("+searchTime+" saniye)";searchResults["appendChild"](resultStats);const resultsList=document["createElement"]("div");resultsList["className"]="results-list";searchResults["appendChild"](resultsList);const playerPage=Math["ceil"](playerRank/5);const startIndex=(playerPage-1)*5;const currentPage=playerPage;const siteDescriptions=[window["langManager"]["t"]("game.search.site_desc1")||"En yeni film, oyun, uygulama ve di\u011Fer i\xE7eriklere eri\u015Fim sa\u011Flayan torrent sitesi. H\u0131zl\u0131 indirme ba\u011Flant\u0131lar\u0131 ve geni\u015F i\xE7erik k\xFCt\xFCphanesi.",window["langManager"]["t"]("game.search.site_desc2")||"Y\xFCksek kalitede torrent i\xE7erikleri sunan g\xFCvenilir site. Film, dizi, oyun ve daha fazlas\u0131 i\xE7in tercih edilen adres.",window["langManager"]["t"]("game.search.site_desc3")||"H\u0131zl\u0131 indirme ba\u011Flant\u0131lar\u0131 ve kullan\u0131c\u0131 dostu aray\xFCz\xFCyle \xF6ne \xE7\u0131kan torrent sitesi. Geni\u015F i\xE7erik ar\u015Fivi ve g\xFCncel yay\u0131nlar.",window["langManager"]["t"]("game.search.site_desc4")||"Torrent indirme portal\u0131. HD film ve diziler, en yeni oyunlar ve yaz\u0131l\u0131mlar. Reklams\u0131z indirme deneyimi sunar.",window["langManager"]["t"]("game.search.site_desc5")||"P2P dosya payla\u015F\u0131m platformu. Y\xFCksek h\u0131zl\u0131 sunucular ve VPN deste\u011Fi ile en iyi torrent deneyimi."];const renderResults=(listEl,queryAllowed)=>{listEl["innerHTML"]="";if(!queryAllowed){const noRes=document["createElement"]("div");noRes["className"]="no-results";noRes["textContent"]=window["langManager"]&&window["langManager"]["t"]("game.search.no_results")||"Sonu\xE7 bulunamad\u0131.";listEl["appendChild"](noRes);return}competitors["forEach"](competitor=>{const resultItem=document["createElement"]("div");resultItem["className"]="result-item";const descriptionIndex=competitor["id"]%siteDescriptions["length"];const description=siteDescriptions[descriptionIndex];let siteName="";if(competitor["domain"]){const domainParts=competitor["domain"]["split"](".");siteName=domainParts[0];siteName=siteName["charAt"](0)["toUpperCase"]()+siteName["slice"](1)}resultItem["innerHTML"]="\n                    <h3 class=\"result-title"+(competitor["is_player"]==1?" user-site":"")+"\">"+siteName+"</h3>\n                    <a href=\"#\" class=\"result-url\">"+competitor["domain"]+"</a>\n                    <p class=\"result-description\">"+description+"</p>\n                ";if(competitor["is_player"]==1){resultItem["querySelector"](".result-title")["addEventListener"]("click",()=>{loadWebsiteContent(container,titleBar)});resultItem["querySelector"](".result-url")["addEventListener"]("click",e=>{e["preventDefault"]();loadWebsiteContent(container,titleBar)})}listEl["appendChild"](resultItem)})};renderResults(resultsList,true);searchEngine["appendChild"](searchResults);container["appendChild"](searchEngine);const pagination=document["createElement"]("div");pagination["className"]="search-pagination";const totalSites=50;const totalPages=Math["ceil"](totalSites/5);let paginationHTML="<div class=\"pagination-logo\">"+(window["langManager"]["t"]("game.search.title")||"OdysseySearch")+"</div><div class=\"pagination-links\">";if(currentPage>2){paginationHTML+="<span class=\"pagination-link disabled\">1</span>";if(currentPage>3){paginationHTML+="<span>...</span>"}}const startPage=Math["max"](1,currentPage-1);const endPage=Math["min"](totalPages,currentPage+1);for(let i=startPage;i<=endPage;i++){if(i===currentPage){paginationHTML+="<span class=\"pagination-current\">"+i+"</span>"}else{paginationHTML+="<span class=\"pagination-link disabled\">"+i+"</span>"}}if(currentPage<totalPages-1){if(currentPage<totalPages-2){paginationHTML+="<span>...</span>"}paginationHTML+="<span class=\"pagination-link disabled\">"+totalPages+"</span>"}paginationHTML+="<span class=\"pagination-next disabled\">"+(window["langManager"]["t"]("game.search.next")||"Sonraki")+"</span></div>";pagination["innerHTML"]=paginationHTML;searchEngine["appendChild"](pagination);const searchInput=searchEngine["querySelector"](".search-input");const searchButton=searchEngine["querySelector"](".search-button");const performSearch=async()=>{const query=(searchInput["value"]||"")["toString"]()["toLowerCase"]()["trim"]();let currentDevMode=false;try{const resp=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_game_state"});const d=await resp["json"]();if(d&&d["success"]&&d["state"]&&(d["state"]["devmode_active"]==1||d["state"]["devmode_active"]===true)){currentDevMode=true}}catch(e){currentDevMode=false}if((query==="cheat"||query==="cheats")&&currentDevMode){const cheatIntro=window["langManager"]["t"]("game.search.cheat_intro")||"Cheating is bad! You know that right? Okay, maybe sometimes it can be really helpful. Sorry, my bad!";const cheatList="- devmode on/off\n- credits <value>\n- attention <value>\n- threats on/off\n- autocrack\n- fastupload <software name>\n- date mm/dd/yyyy";const newRandomResults=1;const newSearchTime=(Math["random"]()*0.5+0.1)["toFixed"](2);resultStats["textContent"]=window["langManager"]["t"]("game.search.result_stats",{["results"]:newRandomResults,["time"]:newSearchTime})||"Yakla\u015F\u0131k "+newRandomResults+" sonu\xE7 bulundu ("+newSearchTime+" saniye)";resultsList["innerHTML"]="";const item=document["createElement"]("div");item["className"]="result-item cheat-result";item["innerHTML"]="\n                    <h3 class=\"result-title\">Cheat Codes</h3>\n                    <div class=\"result-description\">"+cheatIntro["replace"](new RegExp("\\n","g"),"<br/>")+"</div>\n                    <pre class=\"cheat-list\">"+cheatList+"</pre>\n                ";resultsList["appendChild"](item);return}const allowedQueries=["torrent site","torrent","full download","crack"];const isAllowed=allowedQueries["includes"](query);const newRandomResults=isAllowed?Math["floor"](Math["random"]()*10)+1+"."+Math["floor"](Math["random"]()*100)+"0.000":"0";const newSearchTime=(Math["random"]()*0.5+0.1)["toFixed"](2);resultStats["textContent"]=window["langManager"]["t"]("game.search.result_stats",{["results"]:newRandomResults,["time"]:newSearchTime})||"Yakla\u015F\u0131k "+newRandomResults+" sonu\xE7 bulundu ("+newSearchTime+" saniye)";renderResults(resultsList,isAllowed)};searchButton["addEventListener"]("click",performSearch);searchInput["addEventListener"]("keydown",e=>{if(e["key"]==="Enter"){performSearch()}})})["catch"](error=>{container["innerHTML"]="<div class=\"error-message\">"+(window["langManager"]["t"]("game.common.error")||"Error loading data")+"</div>"})}function loadWebsiteContent(container,titleBar){container["innerHTML"]="";const loadingDiv=document["createElement"]("div");loadingDiv["className"]="loading-message";loadingDiv["textContent"]=window["langManager"]["t"]("game.website.loading");container["appendChild"](loadingDiv);titleBar["innerHTML"]="\n        <div class=\"window-brand\">\n            <div class=\"window-brand-icon\">WB</div>\n            <div class=\"window-brand-text\">"+(window["langManager"]&&window["langManager"]["t"]("game.website.title")||"Website")+"</div>\n        </div>\n    ";fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_competitor_rankings"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]&&Array["isArray"](data["rankings"])){const playerSite=data["rankings"]["find"](site=>{return site["is_player"]==1});if(playerSite&&playerSite["domain"]){const titleEl=titleBar["querySelector"](".window-brand-text");if(titleEl){titleEl["textContent"]=playerSite["domain"]}}}})["catch"](()=>{});const closeButton=titleBar["querySelector"](".window-close");if(!closeButton){const newCloseButton=document["createElement"]("button");newCloseButton["className"]="window-close";newCloseButton["textContent"]="\xD7";newCloseButton["addEventListener"]("click",()=>{const websiteWindow=document["querySelector"](".website-simulation-window");if(websiteWindow){if(window["windowAnimator"]){window["windowAnimator"]["animateClose"](websiteWindow,()=>{return websiteWindow["remove"]()})}else{websiteWindow["remove"]()}}});titleBar["appendChild"](newCloseButton)}Promise["all"]([fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_ads&type=active"})["then"](response=>{return response["json"]()}),fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_uploaded_software&limit=4"})["then"](response=>{return response["json"]()})])["then"](([adsResponse,softwareResponse])=>{container["innerHTML"]="";renderWebsiteContent(container,adsResponse["success"]?adsResponse["ads"]:[],softwareResponse["success"]?softwareResponse["software"]:[])})["catch"](error=>{container["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.website.load_error")+"</div>"})}function renderWebsiteContent(container,ads,software){const header=document["createElement"]("div");header["className"]="website-header";const siteLogo=document["createElement"]("div");siteLogo["className"]="website-logo";fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_competitor_rankings"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]&&data["rankings"]){const playerSite=data["rankings"]["find"](site=>{return site["is_player"]==1});if(playerSite&&playerSite["domain"]){const domainParts=playerSite["domain"]["split"](".");let siteName=domainParts[0];siteName=siteName["charAt"](0)["toUpperCase"]()+siteName["slice"](1);siteLogo["textContent"]=siteName}else{siteLogo["textContent"]=window["langManager"]["t"]("game.website.logo_text")}}else{siteLogo["textContent"]=window["langManager"]["t"]("game.website.logo_text")}})["catch"](error=>{siteLogo["textContent"]=window["langManager"]["t"]("game.website.logo_text")});header["appendChild"](siteLogo);const nav=document["createElement"]("div");nav["className"]="website-nav";[window["langManager"]["t"]("game.website.nav.home"),window["langManager"]["t"]("game.website.nav.top_downloads"),window["langManager"]["t"]("game.website.nav.recent_uploads"),window["langManager"]["t"]("game.website.nav.categories"),window["langManager"]["t"]("game.website.nav.request"),window["langManager"]["t"]("game.website.nav.forum"),window["langManager"]["t"]("game.website.nav.faq")]["forEach"](item=>{const navItem=document["createElement"]("a");navItem["href"]="#";navItem["textContent"]=item;navItem["className"]="nav-item";if(item===window["langManager"]["t"]("game.website.nav.forum")){navItem["classList"]["add"]("forum-link");navItem["addEventListener"]("click",function(e){e["preventDefault"]();const centerContent=document["querySelector"](".website-center-content");if(centerContent){centerContent["innerHTML"]="";loadForumContent(centerContent)}})}else{if(item===window["langManager"]["t"]("game.website.nav.home")){navItem["addEventListener"]("click",function(e){e["preventDefault"]();const centerContent=document["querySelector"](".website-center-content");if(centerContent){centerContent["innerHTML"]="";const latestUploads=document["createElement"]("div");latestUploads["className"]="website-latest-uploads";latestUploads["innerHTML"]="<h2>"+window["langManager"]["t"]("game.website.latest_uploads")+"</h2>";if(software&&software["length"]>0){const uploadList=document["createElement"]("div");uploadList["className"]="upload-list";software["forEach"](item=>{const uploadItem=document["createElement"]("div");uploadItem["className"]="upload-item";uploadItem["innerHTML"]="\n                                <div class=\"upload-icon "+item["type"]["toLowerCase"]()+"\"></div>\n                                <div class=\"upload-details\">\n                                    <h3>"+item["name"]+"</h3>\n                                    <div class=\"upload-meta\">\n                                        <span>"+item["size_gb"]+" GB</span>\n                                        <span>"+item["type"]+"</span>\n                                        <span>"+window["langManager"]["t"]("game.website.seeders")+": "+(Math["floor"](Math["random"]()*100)+10)+"</span>\n                                        <span>"+window["langManager"]["t"]("game.website.leechers")+": "+(Math["floor"](Math["random"]()*20)+1)+"</span>\n                                    </div>\n                                </div>\n                        <div class=\"upload-actions\">\n                            <button class=\"download-button\">"+window["langManager"]["t"]("game.website.download")+"</button>\n                            <button class=\"magnet-button\">"+window["langManager"]["t"]("game.website.magnet")+"</button>\n                            <button class=\"upload-delete\" data-id=\""+item["id"]+"\" title=\""+window["langManager"]["t"]("game.files.delete","Delete")+"\">\u2716</button>\n                        </div>\n                            ";uploadList["appendChild"](uploadItem);const deleteBtn=uploadItem["querySelector"](".upload-delete");if(deleteBtn){deleteBtn["addEventListener"]("click",async e=>{e["preventDefault"]();const confirmed=await(window["game"]?window["game"]["showFileDeleteConfirmation"](container):false);if(!confirmed){return}const id=deleteBtn["getAttribute"]("data-id");try{const resp=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=delete_uploaded_software&id="+encodeURIComponent(id)});const data=await resp["json"]();if(data["success"]){uploadItem["remove"]();try{if(Array["isArray"](software)){const idx=software["findIndex"](s=>{return String(s["id"])===String(id)});if(idx!==-1){software["splice"](idx,1)}}}catch(err){}if(window["game"]&&typeof window["game"]["displayEvent"]==="function"){window["game"]["displayEvent"]({["type"]:"success",["message"]:window["langManager"]["t"]("game.website.delete_success","Software deleted")})}}else{if(window["game"]&&typeof window["game"]["displayEvent"]==="function"){window["game"]["displayEvent"]({["type"]:"danger",["message"]:data["message"]||window["langManager"]["t"]("game.website.delete_failed","Delete failed")})}}}catch(err){if(window["game"]&&typeof window["game"]["displayEvent"]==="function"){window["game"]["displayEvent"]({["type"]:"danger",["message"]:window["langManager"]["t"]("game.common.network_error","Network error")})}}})}});latestUploads["appendChild"](uploadList)}else{latestUploads["innerHTML"]+="<p>"+window["langManager"]["t"]("game.website.no_uploads")+"</p>"}centerContent["appendChild"](latestUploads)}})}}nav["appendChild"](navItem)});header["appendChild"](nav);container["appendChild"](header);const bannerAds=ads["filter"](ad=>{return ad["type"]==="banner"});if(bannerAds["length"]>0){const randomBanner=bannerAds[Math["floor"](Math["random"]()*bannerAds["length"])];const bannerArea=document["createElement"]("div");bannerArea["className"]="website-banner-ad";bannerArea["innerHTML"]="\n            <div class=\"ad-container banner\">\n                <span class=\"ad-label\">"+window["langManager"]["t"]("game.website.advertisement")+"</span>\n                <div class=\"ad-content\">"+randomBanner["name"]+"</div>\n            </div>\n        ";container["appendChild"](bannerArea)}const mainContent=document["createElement"]("div");mainContent["className"]="website-main-content";const leftSidebar=document["createElement"]("div");leftSidebar["className"]="website-sidebar";const categories=document["createElement"]("div");categories["className"]="website-categories";categories["innerHTML"]="\n        <h3>"+window["langManager"]["t"]("game.website.categories")+"</h3>\n        <ul>\n            <li><a href=\"#\">"+window["langManager"]["t"]("game.marketplace.games")+"</a></li>\n            <li><a href=\"#\">"+window["langManager"]["t"]("game.marketplace.applications")+"</a></li>\n            <li><a href=\"#\">"+window["langManager"]["t"]("game.website.movies")+"</a></li>\n            <li><a href=\"#\">"+window["langManager"]["t"]("game.website.music")+"</a></li>\n            <li><a href=\"#\">"+window["langManager"]["t"]("game.website.tv_shows")+"</a></li>\n            <li><a href=\"#\">"+window["langManager"]["t"]("game.website.books")+"</a></li>\n            <li><a href=\"#\">"+window["langManager"]["t"]("game.website.other")+"</a></li>\n        </ul>\n    ";leftSidebar["appendChild"](categories);mainContent["appendChild"](leftSidebar);const centerContent=document["createElement"]("div");centerContent["className"]="website-center-content";const latestUploads=document["createElement"]("div");latestUploads["className"]="website-latest-uploads";latestUploads["innerHTML"]="<h2>"+window["langManager"]["t"]("game.website.latest_uploads")+"</h2>";const popupAds=ads["filter"](ad=>{return ad["type"]==="popup"});if(popupAds["length"]>0&&Math["random"]()<0.7){const randomPopup=popupAds[Math["floor"](Math["random"]()*popupAds["length"])];setTimeout(()=>{const popupAd=document["createElement"]("div");popupAd["className"]="website-popup-ad";popupAd["innerHTML"]="\n                <div class=\"popup-ad-container\">\n                    <div class=\"popup-ad-header\">\n                        <span>"+randomPopup["name"]+"</span>\n                        <button class=\"popup-close\">\xD7</button>\n                    </div>\n                    <div class=\"popup-ad-content\">\n                        "+randomPopup["description"]+"\n                        <div class=\"popup-buttons\">\n                            <button class=\"popup-button yes\">"+window["langManager"]["t"]("menu.commands.yes")+"</button>\n                            <button class=\"popup-button no\">"+window["langManager"]["t"]("menu.commands.no")+"</button>\n                        </div>\n                    </div>\n                </div>\n            ";document["body"]["appendChild"](popupAd);popupAd["querySelector"](".popup-close")["addEventListener"]("click",()=>{return popupAd["remove"]()});popupAd["querySelectorAll"](".popup-button")["forEach"](btn=>{btn["addEventListener"]("click",()=>{return popupAd["remove"]()})});setTimeout(()=>{if(document["body"]["contains"](popupAd)){popupAd["remove"]()}},15000)},2000)}if(software&&software["length"]>0){const uploadList=document["createElement"]("div");uploadList["className"]="upload-list";software["forEach"](item=>{const uploadItem=document["createElement"]("div");uploadItem["className"]="upload-item";uploadItem["innerHTML"]="\n                <div class=\"upload-icon "+item["type"]["toLowerCase"]()+"\"></div>\n                <div class=\"upload-details\">\n                    <h3>"+item["name"]+"</h3>\n                    <div class=\"upload-meta\">\n                        <span>"+item["size_gb"]+" GB</span>\n                        <span>"+item["type"]+"</span>\n                        <span>"+window["langManager"]["t"]("game.website.seeders")+": "+(Math["floor"](Math["random"]()*100)+10)+"</span>\n                        <span>"+window["langManager"]["t"]("game.website.leechers")+": "+(Math["floor"](Math["random"]()*20)+1)+"</span>\n                    </div>\n                </div>\n                <div class=\"upload-actions\">\n                    <button class=\"download-button\">"+window["langManager"]["t"]("game.website.download")+"</button>\n                    <button class=\"magnet-button\">"+window["langManager"]["t"]("game.website.magnet")+"</button>\n                    <button class=\"upload-delete\" data-id=\""+item["id"]+"\" title=\""+window["langManager"]["t"]("game.files.delete","Delete")+"\">\u2716</button>\n                </div>\n            ";uploadList["appendChild"](uploadItem);const deleteBtn2=uploadItem["querySelector"](".upload-delete");if(deleteBtn2){deleteBtn2["addEventListener"]("click",async e=>{e["preventDefault"]();const confirmed=await(window["game"]?window["game"]["showFileDeleteConfirmation"](container):false);if(!confirmed){return}const id=deleteBtn2["getAttribute"]("data-id");try{const resp=await fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=delete_uploaded_software&id="+encodeURIComponent(id)});const data=await resp["json"]();if(data["success"]){uploadItem["remove"]();try{if(Array["isArray"](software)){const idx=software["findIndex"](s=>{return String(s["id"])===String(id)});if(idx!==-1){software["splice"](idx,1)}}}catch(err){}if(window["game"]&&typeof window["game"]["displayEvent"]==="function"){window["game"]["displayEvent"]({["type"]:"success",["message"]:window["langManager"]["t"]("game.files.file_deleted","Software deleted")})}}else{if(window["game"]&&typeof window["game"]["displayEvent"]==="function"){window["game"]["displayEvent"]({["type"]:"danger",["message"]:data["message"]||window["langManager"]["t"]("game.website.delete_failed","Delete failed")})}}}catch(err){if(window["game"]&&typeof window["game"]["displayEvent"]==="function"){window["game"]["displayEvent"]({["type"]:"danger",["message"]:window["langManager"]["t"]("game.common.network_error","Network error")})}}})}});latestUploads["appendChild"](uploadList)}else{latestUploads["innerHTML"]+="<p>"+window["langManager"]["t"]("game.website.no_uploads")+"</p>"}centerContent["appendChild"](latestUploads);mainContent["appendChild"](centerContent);const rightSidebar=document["createElement"]("div");rightSidebar["className"]="website-sidebar";const misleadingAds=ads["filter"](ad=>{return ad["type"]==="misleading"});if(misleadingAds["length"]>0){const randomMisleading=misleadingAds[Math["floor"](Math["random"]()*misleadingAds["length"])];const misleadingArea=document["createElement"]("div");misleadingArea["className"]="website-misleading-ad";misleadingArea["innerHTML"]="\n            <div class=\"ad-container misleading\">\n                <div class=\"fake-download-button\">\n                    <span class=\"download-icon\">\u2193</span>\n                    <span class=\"download-text\">"+randomMisleading["name"]+"</span>\n                </div>\n            </div>\n        ";rightSidebar["appendChild"](misleadingArea)}const stats=document["createElement"]("div");stats["className"]="website-stats";stats["innerHTML"]="\n        <h3>"+window["langManager"]["t"]("game.website.site_stats")+"</h3>\n        <ul>\n            <li>"+window["langManager"]["t"]("game.website.files")+": "+(Math["floor"](Math["random"]()*1000)+500)+"</li>\n            <li>"+window["langManager"]["t"]("game.website.registered_users")+": "+(Math["floor"](Math["random"]()*10000)+5000)+"</li>\n            <li>"+window["langManager"]["t"]("game.website.online_users")+": "+(Math["floor"](Math["random"]()*100)+50)+"</li>\n            <li>"+window["langManager"]["t"]("game.website.seeders")+": "+(Math["floor"](Math["random"]()*5000)+1000)+"</li>\n            <li>"+window["langManager"]["t"]("game.website.leechers")+": "+(Math["floor"](Math["random"]()*2000)+500)+"</li>\n        </ul>\n    ";rightSidebar["appendChild"](stats);mainContent["appendChild"](rightSidebar);container["appendChild"](mainContent);const footer=document["createElement"]("div");footer["className"]="website-footer";footer["innerHTML"]="\n        <div>"+window["langManager"]["t"]("game.website.privacy_policy")+" | "+window["langManager"]["t"]("game.website.dmca")+" | "+window["langManager"]["t"]("game.website.contact_us")+"</div>\n        <div>&copy; "+new Date()["getFullYear"]()+" "+window["langManager"]["t"]("game.website.logo_text")+" - "+window["langManager"]["t"]("game.website.simulation_notice")+"</div>\n    ";container["appendChild"](footer)}function loadForumContent(container){const loadingDiv=document["createElement"]("div");loadingDiv["className"]="loading-message";loadingDiv["textContent"]=window["langManager"]["t"]("game.forum.loading");container["appendChild"](loadingDiv);fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_forum_topics"})["then"](response=>{return response["json"]()})["then"](data=>{container["innerHTML"]="";const forumHeader=document["createElement"]("h2");forumHeader["textContent"]=window["langManager"]["t"]("game.forum.topic_list");container["appendChild"](forumHeader);const moderationReminder=document["createElement"]("div");moderationReminder["className"]="moderation-reminder";moderationReminder["textContent"]=window["langManager"]["t"]("game.forum.moderation_reminder");container["appendChild"](moderationReminder);if(data["success"]&&data["topics"]&&data["topics"]["length"]>0){const topicList=document["createElement"]("div");topicList["className"]="forum-topic-list";data["topics"]["forEach"](topic=>{const topicItem=document["createElement"]("div");topicItem["className"]="forum-topic-item";topicItem["setAttribute"]("data-id",topic["id"]);const topicHeader=document["createElement"]("div");topicHeader["className"]="forum-topic-header";const topicTitle=document["createElement"]("h3");topicTitle["className"]="forum-topic-title";topicTitle["textContent"]=topic["title"];topicHeader["appendChild"](topicTitle);const topicAuthor=document["createElement"]("div");topicAuthor["className"]="forum-topic-author";topicAuthor["textContent"]=topic["user_name"];topicHeader["appendChild"](topicAuthor);const topicContent=document["createElement"]("div");topicContent["className"]="forum-topic-content";topicContent["textContent"]=topic["content"];const moderationButtons=document["createElement"]("div");moderationButtons["className"]="forum-topic-moderation";const approveButton=document["createElement"]("button");approveButton["className"]="forum-approve-button";approveButton["textContent"]=window["langManager"]["t"]("game.forum.approve");approveButton["setAttribute"]("data-id",topic["id"]);approveButton["addEventListener"]("click",()=>{return moderateTopic(topic["id"],"approve")});const rejectButton=document["createElement"]("button");rejectButton["className"]="forum-reject-button";rejectButton["textContent"]=window["langManager"]["t"]("game.forum.reject");rejectButton["setAttribute"]("data-id",topic["id"]);rejectButton["addEventListener"]("click",()=>{return moderateTopic(topic["id"],"reject")});moderationButtons["appendChild"](approveButton);moderationButtons["appendChild"](rejectButton);topicItem["appendChild"](topicHeader);topicItem["appendChild"](topicContent);topicItem["appendChild"](moderationButtons);topicList["appendChild"](topicItem)});container["appendChild"](topicList)}else{const noTopicsMessage=document["createElement"]("div");noTopicsMessage["className"]="forum-no-topics";if(data["debug_info"]&&data["debug_info"]["wait_for_next_quarter"]==="true"){noTopicsMessage["textContent"]=window["langManager"]["t"]("game.forum.no_more_topics");container["appendChild"](noTopicsMessage);const waitMessage=document["createElement"]("div");waitMessage["className"]="forum-wait-message";waitMessage["textContent"]=window["langManager"]["t"]("game.forum.wait_for_next_quarter");container["appendChild"](waitMessage)}else{if(data["debug_info"]&&(data["debug_info"]["has_visitors"]==="false"||data["debug_info"]["has_software"]==="false")){noTopicsMessage["textContent"]=window["langManager"]["t"]("game.forum.no_visitors");container["appendChild"](noTopicsMessage)}else{noTopicsMessage["textContent"]=window["langManager"]["t"]("game.forum.no_topics");container["appendChild"](noTopicsMessage)}}}})["catch"](error=>{container["innerHTML"]="<div class=\"error-message\">"+window["langManager"]["t"]("game.forum.load_error")+"</div>"})}function moderateTopic(id,action){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=moderate_forum_topic&id="+id+"&topic_action="+action})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){const topicElement=document["querySelector"](".forum-topic-item[data-id=\""+id+"\"]");if(topicElement){topicElement["style"]["height"]=topicElement["offsetHeight"]+"px";topicElement["style"]["opacity"]="0";topicElement["style"]["transform"]="translateY(-20px)";topicElement["style"]["transition"]="all 0.5s ease";setTimeout(()=>{topicElement["remove"]();const remainingTopics=document["querySelectorAll"](".forum-topic-item");if(remainingTopics["length"]===0){const container=document["querySelector"](".website-center-content");if(container){const noTopicsMessage=document["createElement"]("div");noTopicsMessage["className"]="forum-no-topics";noTopicsMessage["textContent"]=window["langManager"]["t"]("game.forum.no_more_topics");container["appendChild"](noTopicsMessage);const waitMessage=document["createElement"]("div");waitMessage["className"]="forum-wait-message";waitMessage["textContent"]=window["langManager"]["t"]("game.forum.wait_for_next_quarter");container["appendChild"](waitMessage)}}},500);if(data["satisfaction_effect"]){const effect=parseFloat(data["satisfaction_effect"]);const effectText=effect>=0?"+"+(effect*100)["toFixed"](1)+"% "+window["langManager"]["t"]("game.forum.satisfaction"):""+(effect*100)["toFixed"](1)+"% "+window["langManager"]["t"]("game.forum.satisfaction");const effectClass=effect>=0?"positive-effect":"negative-effect";showFloatingText(effectText,effectClass)}}}else{}})["catch"](error=>{})}function purchaseVPN(){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=purchase_vpn"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){if(typeof showFloatingText==="function"){showFloatingText(data["message"]||"VPN purchased!","success")}if(window["game"]){window["game"]["creditsDisplay"]["textContent"]=data["credits"]||window["game"]["creditsDisplay"]["textContent"]}if(typeof window["refreshMarketplaceWindow"]==="function"){window["refreshMarketplaceWindow"]()}}else{if(typeof showFloatingText==="function"){showFloatingText(data["message"]||"Purchase failed","error")}}})["catch"](error=>{console["error"]("VPN purchase error:",error);if(typeof showFloatingText==="function"){showFloatingText("An error occurred","error")}})}function showVPNRefillPopup(){const marketplaceWindow=document["querySelector"](".marketplace-window")||document["body"];const overlay=document["createElement"]("div");overlay["className"]="vpn-refill-overlay";overlay["style"]["cssText"]="\n        position: fixed;\n        top: 0;\n        left: 0;\n        width: 100%;\n        height: 100%;\n        background: rgba(0, 0, 0, 0.8);\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        z-index: 10000;\n        animation: fadeIn 0.2s ease;\n    ";fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_vpn_refill_cost"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){const cost=data["cost"];const dialog=document["createElement"]("div");dialog["className"]="vpn-refill-dialog";dialog["style"]["cssText"]="\n                background: rgba(0, 15, 10, 0.95);\n                border: 2px solid var(--border-color);\n                border-radius: 8px;\n                padding: 25px;\n                min-width: 400px;\n                box-shadow: 0 0 30px rgba(0, 255, 150, 0.3);\n                animation: scaleIn 0.3s ease;\n            ";dialog["innerHTML"]="\n                <div style=\"margin-bottom: 20px; text-align: center;\">\n                    <div style=\"font-size: 48px; margin-bottom: 10px;\">\uD83D\uDD04</div>\n                    <h3 style=\"color: var(--primary-color); margin: 0 0 10px 0; font-size: 18px;\">\n                        "+window["langManager"]["t"]("game.marketplace.vpn.refill_title")+"\n                    </h3>\n                    <p style=\"color: rgba(0, 255, 150, 0.7); margin: 0; font-size: 14px;\">\n                        "+window["langManager"]["t"]("game.marketplace.vpn.refill_message",{["cost"]:cost})+"\n                    </p>\n                </div>\n                <div style=\"display: flex; gap: 10px; justify-content: center;\">\n                    <button class=\"btn-cancel\" style=\"\n                        background: rgba(100, 100, 100, 0.3);\n                        border: 1px solid rgba(150, 150, 150, 0.5);\n                        color: #ccc;\n                        padding: 10px 25px;\n                        border-radius: 4px;\n                        cursor: pointer;\n                        font-family: var(--game-font);\n                        font-size: 14px;\n                        transition: all 0.3s ease;\n                    \">\u274C "+window["langManager"]["t"]("game.files.cancel","Cancel")+"</button>\n                    <button class=\"btn-confirm-refill\" style=\"\n                        background: rgba(0, 255, 136, 0.2);\n                        border: 1px solid rgba(0, 255, 136, 0.5);\n                        color: var(--success-color);\n                        padding: 10px 25px;\n                        border-radius: 4px;\n                        cursor: pointer;\n                        font-family: var(--game-font);\n                        font-size: 14px;\n                        transition: all 0.3s ease;\n                    \">\u2713 "+window["langManager"]["t"]("game.marketplace.vpn.refill_confirm","Refill")+"</button>\n                </div>\n            ";overlay["appendChild"](dialog);document["body"]["appendChild"](overlay);const style=document["createElement"]("style");style["textContent"]="\n                @keyframes fadeIn {\n                    from { opacity: 0; }\n                    to { opacity: 1; }\n                }\n                @keyframes scaleIn {\n                    from { transform: scale(0.8); opacity: 0; }\n                    to { transform: scale(1); opacity: 1; }\n                }\n                .btn-cancel:hover {\n                    background: rgba(100, 100, 100, 0.5) !important;\n                    box-shadow: 0 0 10px rgba(150, 150, 150, 0.3);\n                }\n                .btn-confirm-refill:hover {\n                    background: rgba(0, 255, 136, 0.3) !important;\n                    box-shadow: 0 0 15px rgba(0, 255, 136, 0.5);\n                }\n            ";document["head"]["appendChild"](style);const cancelBtn=dialog["querySelector"](".btn-cancel");const confirmBtn=dialog["querySelector"](".btn-confirm-refill");const cleanup=()=>{overlay["style"]["animation"]="fadeOut 0.2s ease";setTimeout(()=>{overlay["remove"]();style["remove"]()},200)};cancelBtn["addEventListener"]("click",cleanup);confirmBtn["addEventListener"]("click",()=>{fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=refill_vpn_capacity"})["then"](response=>{return response["json"]()})["then"](data=>{cleanup();if(data["success"]){if(typeof showFloatingText==="function"){showFloatingText(data["message"]||"VPN capacity refilled!","success")}if(window["game"]&&data["tsx_balance"]!==undefined){const tsxDisplay=document["querySelector"](".mining-balance");if(tsxDisplay){tsxDisplay["textContent"]=data["tsx_balance"]["toFixed"](2)}}}else{if(typeof showFloatingText==="function"){showFloatingText(data["message"]||"Refill failed","error")}}})["catch"](error=>{cleanup();console["error"]("VPN refill error:",error);if(typeof showFloatingText==="function"){showFloatingText("An error occurred","error")}})});const escHandler=e=>{if(e["key"]==="Escape"){cleanup();document["removeEventListener"]("keydown",escHandler)}};document["addEventListener"]("keydown",escHandler);overlay["addEventListener"]("click",e=>{if(e["target"]===overlay){cleanup()}})}else{if(typeof showFloatingText==="function"){showFloatingText("Failed to get refill cost","error")}}})["catch"](error=>{console["error"]("Error getting VPN refill cost:",error);if(typeof showFloatingText==="function"){showFloatingText("An error occurred","error")}})}function showFloatingText(text,cssClass){const floatingText=document["createElement"]("div");floatingText["className"]="floating-text "+cssClass;floatingText["textContent"]=text;document["body"]["appendChild"](floatingText);setTimeout(()=>{floatingText["style"]["opacity"]="0";floatingText["style"]["transform"]="translateY(-30px)";setTimeout(()=>{floatingText["remove"]()},500)},1000)}function checkForumQuarterlyProcessing(){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=autoprocess_forum_topics"})["then"](response=>{return response["json"]()})["catch"](error=>{})}function addMenuCommand(){if(window["game"]&&window["game"]["processTerminalCommand"]){window["game"]["commands"]=window["game"]["commands"]||{};window["game"]["commands"]["menu"]={["description"]:window["langManager"]["t"]("game.commands.menu_description"),["usage"]:"menu",["execute"]:function(){window["game"]["writeToTerminal"](window["langManager"]["t"]("game.commands.returning_to_menu"));setTimeout(function(){window["location"]["href"]=window["BASE_URL"]+"/src/utils/Menu.php"},1000);return true}};window["game"]["commands"]["quit"]={["description"]:window["langManager"]["t"]("game.commands.quit_description"),["usage"]:"quit",["execute"]:function(){window["game"]["writeToTerminal"](window["langManager"]["t"]("game.commands.quitting_game"));setTimeout(function(){window["location"]["href"]=window["BASE_URL"]+"/src/utils/Menu.php"},1000);return true}}}}document["addEventListener"]("DOMContentLoaded",function(){setTimeout(addMenuCommand,500)});function getCurrentYear(){return game["getCurrentYear"]()}function getCurrentMonth(){return game["getCurrentMonth"]()}class FontScaling{constructor(){this["fontScale"]=parseFloat(localStorage["getItem"]("fontScale"))||1;this["minFontScale"]=0.5;this["maxFontScale"]=2;this["fontScaleStep"]=0.1}["init"](){this["applyFontScale"]();document["getElementById"]("font-decrease")["addEventListener"]("click",()=>{this["decreaseFontSize"]()});document["getElementById"]("font-increase")["addEventListener"]("click",()=>{this["increaseFontSize"]()});document["getElementById"]("font-reset")["addEventListener"]("click",()=>{this["resetFontSize"]()});document["addEventListener"]("keydown",e=>{if(e["ctrlKey"]&&e["key"]==="="){e["preventDefault"]();this["increaseFontSize"]()}else{if(e["ctrlKey"]&&e["key"]==="-"){e["preventDefault"]();this["decreaseFontSize"]()}else{if(e["ctrlKey"]&&e["key"]==="0"){e["preventDefault"]();this["resetFontSize"]()}}}})}["applyFontScale"](){document["documentElement"]["style"]["setProperty"]("--font-scale",this["fontScale"]);if(window["catAnimationInstance"]&&typeof window["catAnimationInstance"]["updateBoundaries"]==="function"){setTimeout(()=>{window["catAnimationInstance"]["updateBoundaries"]()},100)}}["setFontScale"](scale){this["fontScale"]=Math["max"](this["minFontScale"],Math["min"](this["maxFontScale"],scale));this["applyFontScale"]();localStorage["setItem"]("fontScale",this["fontScale"]["toString"]())}["increaseFontSize"](){this["setFontScale"](this["fontScale"]+this["fontScaleStep"])}["decreaseFontSize"](){this["setFontScale"](this["fontScale"]-this["fontScaleStep"])}["resetFontSize"](){this["setFontScale"](1)}}class CRTPowerOn{constructor(){this["overlay"]=null}["init"](){this["overlay"]=document["querySelector"](".crt-power-on-overlay");if(this["overlay"]){this["playPowerOn"]()}}["playPowerOn"](){if(!this["overlay"]){return}this["overlay"]["style"]["display"]="flex";setTimeout(()=>{this["overlay"]["style"]["display"]="none"},800)}}class WindowAnimator{constructor(){this["animationDuration"]=450}["animateOpen"](windowElement,sourceElement=null){if(!windowElement){return}windowElement["style"]["transformOrigin"]="bottom center";windowElement["classList"]["add"]("window-opening");setTimeout(()=>{windowElement["classList"]["remove"]("window-opening");windowElement["style"]["transformOrigin"]=""},this["animationDuration"])}["animateClose"](windowElement,callback,sourceElement=null){if(!windowElement){if(callback){callback()}return}windowElement["style"]["transformOrigin"]="bottom center";windowElement["classList"]["add"]("window-closing");setTimeout(()=>{windowElement["classList"]["remove"]("window-closing");windowElement["style"]["transformOrigin"]="";if(callback){callback()}},350)}["animateMinimize"](windowElement,taskbarApp,callback){if(!windowElement){if(callback){callback()}return}if(taskbarApp){const rect=taskbarApp["getBoundingClientRect"]();windowElement["style"]["transformOrigin"]=""+(rect["left"]+rect["width"]/2)+"px "+rect["top"]+"px"}else{windowElement["style"]["transformOrigin"]="bottom center"}windowElement["classList"]["add"]("window-minimizing");setTimeout(()=>{windowElement["classList"]["remove"]("window-minimizing");windowElement["style"]["transformOrigin"]="";if(callback){callback()}},this["animationDuration"])}["animateRestore"](windowElement,taskbarApp){if(!windowElement){return}if(taskbarApp){const rect=taskbarApp["getBoundingClientRect"]();windowElement["style"]["transformOrigin"]=""+(rect["left"]+rect["width"]/2)+"px "+rect["top"]+"px"}else{windowElement["style"]["transformOrigin"]="bottom center"}windowElement["classList"]["add"]("window-restoring");setTimeout(()=>{windowElement["classList"]["remove"]("window-restoring");windowElement["style"]["transformOrigin"]=""},this["animationDuration"])}}window["crtPowerOn"]=new CRTPowerOn;window["windowAnimator"]=new WindowAnimator;document["addEventListener"]("DOMContentLoaded",()=>{window["fontScaling"]=new FontScaling;window["fontScaling"]["init"]();window["crtPowerOn"]["init"]()});